/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.autoconfigure;

import com.baomidou.mybatisplus.core.MybatisParameterHandler;
import com.baomidou.mybatisplus.extension.scripting.MybatisFreeMarkerLanguageDriver;
import com.baomidou.mybatisplus.extension.scripting.MybatisThymeleafLanguageDriver;
import com.baomidou.mybatisplus.extension.scripting.MybatisVelocityLanguageDriver;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.scripting.LanguageDriver;
import org.mybatis.scripting.freemarker.FreeMarkerLanguageDriver;
import org.mybatis.scripting.freemarker.FreeMarkerLanguageDriverConfig;
import org.mybatis.scripting.thymeleaf.SqlGeneratorConfig;
import org.mybatis.scripting.thymeleaf.ThymeleafLanguageDriver;
import org.mybatis.scripting.thymeleaf.ThymeleafLanguageDriverConfig;
import org.mybatis.scripting.velocity.Driver;
import org.mybatis.scripting.velocity.VelocityLanguageDriver;
import org.mybatis.scripting.velocity.VelocityLanguageDriverConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Lazy
@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={LanguageDriver.class})
public class MybatisPlusLanguageDriverAutoConfiguration {
    private static final String CONFIGURATION_PROPERTY_PREFIX = "mybatis-plus.scripting-language-driver";

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ThymeleafLanguageDriver.class})
    public static class ThymeleafConfiguration {
        @Bean
        @ConditionalOnMissingBean
        ThymeleafLanguageDriver thymeleafLanguageDriver(ThymeleafLanguageDriverConfig config) {
            return new MybatisThymeleafLanguageDriver(config);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="mybatis-plus.scripting-language-driver.thymeleaf")
        public ThymeleafLanguageDriverConfig thymeleafLanguageDriverConfig() {
            return ThymeleafLanguageDriverConfig.newInstance();
        }

        private static class MetadataThymeleafLanguageDriverConfig
        extends ThymeleafLanguageDriverConfig {
            private MetadataThymeleafLanguageDriverConfig() {
            }

            @ConfigurationProperties(value="mybatis-plus.scripting-language-driver.thymeleaf.dialect")
            public SqlGeneratorConfig.DialectConfig getDialect() {
                return super.getDialect();
            }

            @ConfigurationProperties(value="mybatis-plus.scripting-language-driver.thymeleaf.template-file")
            public ThymeleafLanguageDriverConfig.TemplateFileConfig getTemplateFile() {
                return super.getTemplateFile();
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={VelocityLanguageDriver.class, VelocityLanguageDriverConfig.class})
    public static class VelocityConfiguration {
        @Bean
        @ConditionalOnMissingBean
        VelocityLanguageDriver velocityLanguageDriver(VelocityLanguageDriverConfig config) {
            return new MybatisVelocityLanguageDriver(config);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="mybatis-plus.scripting-language-driver.velocity")
        public VelocityLanguageDriverConfig velocityLanguageDriverConfig() {
            return VelocityLanguageDriverConfig.newInstance();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Driver.class})
    @ConditionalOnMissingClass(value={"org.mybatis.scripting.velocity.VelocityLanguageDriverConfig"})
    public static class LegacyVelocityConfiguration {
        @Bean
        @ConditionalOnMissingBean
        Driver velocityLanguageDriver() {
            return new Driver(){

                public ParameterHandler createParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
                    return new MybatisParameterHandler(mappedStatement, parameterObject, boundSql);
                }
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={FreeMarkerLanguageDriver.class, FreeMarkerLanguageDriverConfig.class})
    public static class FreeMarkerConfiguration {
        @Bean
        @ConditionalOnMissingBean
        FreeMarkerLanguageDriver freeMarkerLanguageDriver(FreeMarkerLanguageDriverConfig config) {
            return new MybatisFreeMarkerLanguageDriver(config);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="mybatis-plus.scripting-language-driver.freemarker")
        public FreeMarkerLanguageDriverConfig freeMarkerLanguageDriverConfig() {
            return FreeMarkerLanguageDriverConfig.newInstance();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={FreeMarkerLanguageDriver.class})
    @ConditionalOnMissingClass(value={"org.mybatis.scripting.freemarker.FreeMarkerLanguageDriverConfig"})
    public static class LegacyFreeMarkerConfiguration {
        @Bean
        @ConditionalOnMissingBean
        FreeMarkerLanguageDriver freeMarkerLanguageDriver() {
            return new MybatisFreeMarkerLanguageDriver();
        }
    }
}

