/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.eclipsesource.json.JsonObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;

public final class BoxSensitiveDataSanitizer {
    private static final Set<String> SENSITIVE_KEYS = new HashSet<String>(Arrays.asList("authorization", "access_token", "refresh_token", "subject_token", "token", "client_id", "client_secret", "code", "shared_link", "download_url", "jwt_private_key", "jwt_private_key_passphrase", "password"));

    private BoxSensitiveDataSanitizer() {
    }

    public static void addKeyToSanitize(String key) {
        SENSITIVE_KEYS.add(key);
    }

    @NotNull
    static Headers sanitizeHeaders(Headers originalHeaders) {
        Headers.Builder sanitizedHeadersBuilder = originalHeaders.newBuilder();
        for (String originalHeaderName : originalHeaders.names()) {
            if (BoxSensitiveDataSanitizer.isSensitiveKey(originalHeaderName)) {
                sanitizedHeadersBuilder.set(originalHeaderName, "[REDACTED]");
                continue;
            }
            String headerValue = originalHeaders.get(originalHeaderName);
            if (headerValue == null) continue;
            sanitizedHeadersBuilder.set(originalHeaderName, headerValue);
        }
        return sanitizedHeadersBuilder.build();
    }

    @NotNull
    static JsonObject sanitizeJsonBody(JsonObject originalBody) {
        JsonObject sanitizedBody = new JsonObject();
        for (String key : originalBody.names()) {
            if (BoxSensitiveDataSanitizer.isSensitiveKey(key)) {
                sanitizedBody.set(key, "[REDACATED]");
                continue;
            }
            sanitizedBody.set(key, originalBody.get(key));
        }
        return sanitizedBody;
    }

    private static boolean isSensitiveKey(@NotNull String key) {
        return SENSITIVE_KEYS.contains(key.toLowerCase(Locale.ROOT));
    }
}

