/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.AvatarUploadResponse;
import com.box.sdk.BinaryBodyUtils;
import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxEnterprise;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxGroupMembership;
import com.box.sdk.BoxGroupMembershipIterator;
import com.box.sdk.BoxImageMultipartRequest;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxNotificationEmail;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUserIterator;
import com.box.sdk.CreateUserParams;
import com.box.sdk.EmailAlias;
import com.box.sdk.ProgressListener;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.box.sdk.http.HttpMethod;
import com.box.sdk.internal.utils.JsonUtils;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

@BoxResourceType(value="user")
public class BoxUser
extends BoxCollaborator {
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "name", "login", "created_at", "modified_at", "role", "language", "timezone", "space_amount", "space_used", "max_upload_size", "tracking_codes", "can_see_managed_users", "is_sync_enabled", "is_external_collab_restricted", "status", "job_title", "phone", "address", "avatar_url", "is_exempt_from_device_limits", "is_exempt_from_login_verification", "enterprise", "my_tags", "hostname", "is_platform_access_only", "external_app_user_id", "notification_email"};
    public static final URLTemplate USER_URL_TEMPLATE = new URLTemplate("users/%s");
    public static final URLTemplate GET_ME_URL = new URLTemplate("users/me");
    public static final URLTemplate USERS_URL_TEMPLATE = new URLTemplate("users");
    public static final URLTemplate USER_MEMBERSHIPS_URL_TEMPLATE = new URLTemplate("users/%s/memberships");
    public static final URLTemplate EMAIL_ALIAS_URL_TEMPLATE = new URLTemplate("users/%s/email_aliases/%s");
    public static final URLTemplate EMAIL_ALIASES_URL_TEMPLATE = new URLTemplate("users/%s/email_aliases");
    public static final URLTemplate MOVE_FOLDER_TO_USER_TEMPLATE = new URLTemplate("users/%s/folders/%s");
    public static final URLTemplate USER_AVATAR_TEMPLATE = new URLTemplate("users/%s/avatar");

    public BoxUser(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info createAppUser(BoxAPIConnection api, String name, String ... fields) {
        return BoxUser.createAppUser(api, name, new CreateUserParams(), fields);
    }

    public static Info createAppUser(BoxAPIConnection api, String name, CreateUserParams params, String ... fields) {
        params.setIsPlatformAccessOnly(true);
        return BoxUser.createEnterpriseUser(api, null, name, params, fields);
    }

    public static Info createEnterpriseUser(BoxAPIConnection api, String login, String name, String ... fields) {
        return BoxUser.createEnterpriseUser(api, login, name, null, fields);
    }

    public static Info createEnterpriseUser(BoxAPIConnection api, String login, String name, CreateUserParams params, String ... fields) {
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("login", login);
        requestJSON.add("name", name);
        if (params != null) {
            if (params.getRole() != null) {
                requestJSON.add("role", params.getRole().toJSONValue());
            }
            if (params.getStatus() != null) {
                requestJSON.add("status", params.getStatus().toJSONValue());
            }
            if (params.getTrackingCodes() != null) {
                requestJSON.add("tracking_codes", (JsonValue)BoxUser.toTrackingCodesJson(params.getTrackingCodes()));
            }
            JsonUtils.addIfNotNull(requestJSON, "language", params.getLanguage());
            JsonUtils.addIfNotNull(requestJSON, "is_sync_enabled", params.getIsSyncEnabled());
            JsonUtils.addIfNotNull(requestJSON, "job_title", params.getJobTitle());
            JsonUtils.addIfNotNull(requestJSON, "phone", params.getPhone());
            JsonUtils.addIfNotNull(requestJSON, "address", params.getAddress());
            JsonUtils.addIfNotNull(requestJSON, "space_amount", params.getSpaceAmount());
            JsonUtils.addIfNotNull(requestJSON, "can_see_managed_users", params.getCanSeeManagedUsers());
            JsonUtils.addIfNotNull(requestJSON, "timezone", params.getTimezone());
            JsonUtils.addIfNotNull(requestJSON, "is_exempt_from_device_limits", params.getIsExemptFromDeviceLimits());
            JsonUtils.addIfNotNull(requestJSON, "is_exempt_from_login_verification", params.getIsExemptFromLoginVerification());
            JsonUtils.addIfNotNull(requestJSON, "is_platform_access_only", params.getIsPlatformAccessOnly());
            JsonUtils.addIfNotNull(requestJSON, "external_app_user_id", params.getExternalAppUserId());
            JsonUtils.addIfNotNull(requestJSON, "is_external_collab_restricted", params.getIsExternalCollabRestricted());
        }
        QueryStringBuilder queryString = new QueryStringBuilder();
        if (fields.length > 0) {
            queryString.appendParam("fields", fields);
        }
        URL url = USERS_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), queryString.toString(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        try (BoxJSONResponse response = request.send();){
            BoxUser createdUser;
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            BoxUser boxUser = createdUser = new BoxUser(api, responseJSON.get("id").asString());
            boxUser.getClass();
            Info info = boxUser.new Info(responseJSON);
            return info;
        }
    }

    public static BoxUser getCurrentUser(BoxAPIConnection api) {
        URL url = GET_ME_URL.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "GET");
        try (BoxJSONResponse response = request.send();){
            JsonObject jsonObject = Json.parse((String)response.getJSON()).asObject();
            BoxUser boxUser = new BoxUser(api, jsonObject.get("id").asString());
            return boxUser;
        }
    }

    public static Iterable<Info> getAllEnterpriseUsers(BoxAPIConnection api) {
        return BoxUser.getAllEnterpriseUsers(api, false, null);
    }

    public static Iterable<Info> getAllEnterpriseUsers(BoxAPIConnection api, boolean usemarker, String marker) {
        return BoxUser.getUsersInfoForType(api, null, null, null, usemarker, marker, new String[0]);
    }

    public static Iterable<Info> getAllEnterpriseUsers(BoxAPIConnection api, String filterTerm, String ... fields) {
        return BoxUser.getUsersInfoForType(api, filterTerm, null, null, false, null, fields);
    }

    public static Iterable<Info> getAllEnterpriseUsers(BoxAPIConnection api, String filterTerm, boolean usemarker, String marker, String ... fields) {
        return BoxUser.getUsersInfoForType(api, filterTerm, null, null, usemarker, marker, fields);
    }

    public static Iterable<Info> getExternalUsers(BoxAPIConnection api, String filterTerm, String ... fields) {
        return BoxUser.getUsersInfoForType(api, filterTerm, "external", null, false, null, fields);
    }

    public static Iterable<Info> getExternalUsers(BoxAPIConnection api, String filterTerm, boolean usemarker, String marker, String ... fields) {
        return BoxUser.getUsersInfoForType(api, filterTerm, "external", null, usemarker, marker, fields);
    }

    public static Iterable<Info> getAllEnterpriseOrExternalUsers(BoxAPIConnection api, String filterTerm, String ... fields) {
        return BoxUser.getUsersInfoForType(api, filterTerm, "all", null, false, null, fields);
    }

    public static Iterable<Info> getAllEnterpriseOrExternalUsers(BoxAPIConnection api, String filterTerm, boolean usemarker, String marker, String ... fields) {
        return BoxUser.getUsersInfoForType(api, filterTerm, "all", null, usemarker, marker, fields);
    }

    public static Iterable<Info> getAppUsersByExternalAppUserID(BoxAPIConnection api, String externalAppUserId, String ... fields) {
        return BoxUser.getUsersInfoForType(api, null, null, externalAppUserId, false, null, fields);
    }

    public static Iterable<Info> getAppUsersByExternalAppUserID(BoxAPIConnection api, String externalAppUserId, boolean usemarker, String marker, String ... fields) {
        return BoxUser.getUsersInfoForType(api, null, null, externalAppUserId, usemarker, marker, fields);
    }

    private static Iterable<Info> getUsersInfoForType(final BoxAPIConnection api, String filterTerm, String userType, String externalAppUserId, boolean usemarker, String marker, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (filterTerm != null) {
            builder.appendParam("filter_term", filterTerm);
        }
        if (userType != null) {
            builder.appendParam("user_type", userType);
        }
        if (externalAppUserId != null) {
            builder.appendParam("external_app_user_id", externalAppUserId);
        }
        if (usemarker) {
            builder.appendParam("usemarker", "true");
        }
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = USERS_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), new Object[0]);
        if (usemarker) {
            return new BoxResourceIterable<Info>(api, url, 100, null, marker){

                @Override
                protected Info factory(JsonObject jsonObject) {
                    BoxUser user;
                    BoxUser boxUser = user = new BoxUser(api, jsonObject.get("id").asString());
                    boxUser.getClass();
                    return boxUser.new Info(jsonObject);
                }
            };
        }
        return () -> new BoxUserIterator(api, url);
    }

    private static JsonArray toTrackingCodesJson(Map<String, String> trackingCodes) {
        JsonArray trackingCodesJsonArray = new JsonArray();
        for (String attrKey : trackingCodes.keySet()) {
            JsonObject trackingCode = new JsonObject();
            trackingCode.set("type", "tracking_code");
            trackingCode.set("name", attrKey);
            trackingCode.set("value", trackingCodes.get(attrKey));
            trackingCodesJsonArray.add((JsonValue)trackingCode);
        }
        return trackingCodesJsonArray;
    }

    public Info getInfo(String ... fields) {
        URL url;
        if (fields.length > 0) {
            String queryString = new QueryStringBuilder().appendParam("fields", fields).toString();
            url = USER_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        } else {
            url = USER_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        }
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "GET");
        try (BoxJSONResponse response = request.send();){
            JsonObject jsonObject = Json.parse((String)response.getJSON()).asObject();
            Info info = new Info(jsonObject);
            return info;
        }
    }

    public Collection<BoxGroupMembership.Info> getMemberships() {
        BoxAPIConnection api = this.getAPI();
        URL url = USER_MEMBERSHIPS_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(api, url, "GET");
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            int entriesCount = responseJSON.get("total_count").asInt();
            ArrayList<BoxGroupMembership.Info> memberships = new ArrayList<BoxGroupMembership.Info>(entriesCount);
            JsonArray entries = responseJSON.get("entries").asArray();
            for (JsonValue entry : entries) {
                BoxGroupMembership membership;
                JsonObject entryObject = entry.asObject();
                BoxGroupMembership boxGroupMembership = membership = new BoxGroupMembership(api, entryObject.get("id").asString());
                boxGroupMembership.getClass();
                BoxGroupMembership.Info info = new BoxGroupMembership.Info(boxGroupMembership, entryObject);
                memberships.add(info);
            }
            ArrayList<BoxGroupMembership.Info> arrayList = memberships;
            return arrayList;
        }
    }

    public Iterable<BoxGroupMembership.Info> getAllMemberships(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return () -> {
            URL url = USER_MEMBERSHIPS_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
            return new BoxGroupMembershipIterator(this.getAPI(), url);
        };
    }

    public EmailAlias addEmailAlias(String email) {
        return this.addEmailAlias(email, false);
    }

    public EmailAlias addEmailAlias(String email, boolean isConfirmed) {
        URL url = EMAIL_ALIASES_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        JsonObject requestJSON = new JsonObject().add("email", email);
        if (isConfirmed) {
            requestJSON.add("is_confirmed", isConfirmed);
        }
        request.setBody(requestJSON.toString());
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            EmailAlias emailAlias = new EmailAlias(responseJSON);
            return emailAlias;
        }
    }

    public void deleteEmailAlias(String emailAliasID) {
        URL url = EMAIL_ALIAS_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID(), emailAliasID);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        request.send().close();
    }

    public Collection<EmailAlias> getEmailAliases() {
        URL url = EMAIL_ALIASES_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "GET");
        try (BoxJSONResponse response = request.send();){
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            int totalCount = responseJSON.get("total_count").asInt();
            ArrayList<EmailAlias> emailAliases = new ArrayList<EmailAlias>(totalCount);
            JsonArray entries = responseJSON.get("entries").asArray();
            for (JsonValue value : entries) {
                JsonObject emailAliasJSON = value.asObject();
                emailAliases.add(new EmailAlias(emailAliasJSON));
            }
            ArrayList<EmailAlias> arrayList = emailAliases;
            return arrayList;
        }
    }

    public void delete(boolean notifyUser, boolean force) {
        String queryString = new QueryStringBuilder().appendParam("notify", String.valueOf(notifyUser)).appendParam("force", String.valueOf(force)).toString();
        this.performUserDelete(queryString);
    }

    public void delete() {
        this.performUserDelete("");
    }

    private void performUserDelete(String queryString) {
        URL url = USER_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        request.send().close();
    }

    public void updateInfo(Info info, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = USER_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        try (BoxJSONResponse response = request.send();){
            JsonObject jsonObject = Json.parse((String)response.getJSON()).asObject();
            info.update(jsonObject);
        }
    }

    public BoxFolder.Info transferContent(String destinationUserID) {
        URL url = MOVE_FOLDER_TO_USER_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID(), "0");
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        JsonObject destinationUser = new JsonObject();
        destinationUser.add("id", destinationUserID);
        JsonObject ownedBy = new JsonObject();
        ownedBy.add("owned_by", (JsonValue)destinationUser);
        request.setBody(ownedBy.toString());
        try (BoxJSONResponse response = request.send();){
            BoxFolder movedFolder;
            JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
            BoxFolder boxFolder = movedFolder = new BoxFolder(this.getAPI(), responseJSON.get("id").asString());
            boxFolder.getClass();
            BoxFolder.Info info = boxFolder.new BoxFolder.Info(responseJSON);
            return info;
        }
    }

    public void downloadAvatar(OutputStream outputStream) {
        URL url = USER_AVATAR_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BinaryBodyUtils.writeStream(request.send(), outputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getAvatar() {
        URL url = USER_AVATAR_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxAPIResponse response = request.send();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            BinaryBodyUtils.writeStream(response, outputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while closing stream", e);
        }
    }

    public AvatarUploadResponse uploadAvatar(File file) {
        try {
            return this.uploadAvatar(new FileInputStream(file), file.getName());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public AvatarUploadResponse uploadAvatar(File file, ProgressListener progressListener) {
        try {
            return this.uploadAvatar(new FileInputStream(file), file.getName(), progressListener);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public AvatarUploadResponse uploadAvatar(InputStream content, String fileName) {
        return this.uploadAvatar(content, fileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvatarUploadResponse uploadAvatar(InputStream content, String fileName, ProgressListener progressListener) {
        URL url = USER_AVATAR_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxImageMultipartRequest request = new BoxImageMultipartRequest(this.getAPI(), url, "pic");
        request.setFile(content, fileName);
        BoxAPIResponse response = null;
        try {
            response = progressListener != null ? request.send(progressListener) : request.send();
            AvatarUploadResponse avatarUploadResponse = this.parseUploadAvatarResponse(response);
            return avatarUploadResponse;
        }
        finally {
            Optional.ofNullable(response).ifPresent(BoxAPIResponse::close);
        }
    }

    public void deleteAvatar() {
        URL url = USER_AVATAR_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, HttpMethod.DELETE);
        request.send().close();
    }

    private AvatarUploadResponse parseUploadAvatarResponse(BoxAPIResponse response) {
        JsonObject responseObject = Json.parse((String)response.bodyToString()).asObject();
        JsonObject picUrls = responseObject.get("pic_urls").asObject();
        return new AvatarUploadResponse(picUrls.getString("small", null), picUrls.getString("large", null), picUrls.getString("preview", null));
    }

    public class Info
    extends BoxCollaborator.Info {
        private String login;
        private Role role;
        private String language;
        private String timezone;
        private long spaceAmount;
        private long spaceUsed;
        private long maxUploadSize;
        private boolean canSeeManagedUsers;
        private boolean isSyncEnabled;
        private boolean isExternalCollabRestricted;
        private Status status;
        private String jobTitle;
        private String phone;
        private String address;
        private String avatarURL;
        private BoxNotificationEmail notificationEmail;
        private boolean isExemptFromDeviceLimits;
        private boolean isExemptFromLoginVerification;
        private boolean isPasswordResetRequired;
        private boolean isPlatformAccessOnly;
        private String externalAppUserId;
        private BoxEnterprise enterprise;
        private List<String> myTags;
        private String hostname;
        private Map<String, String> trackingCodes;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxUser getResource() {
            return BoxUser.this;
        }

        @Override
        public String getLogin() {
            return this.login;
        }

        public void setLogin(String login) {
            this.login = login;
            this.addPendingChange("login", login);
        }

        public Role getRole() {
            return this.role;
        }

        public void setRole(Role role) {
            this.role = role;
            this.addPendingChange("role", role.name().toLowerCase(Locale.ROOT));
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
            this.addPendingChange("language", language);
        }

        public String getTimezone() {
            return this.timezone;
        }

        public void setTimezone(String timezone) {
            this.timezone = timezone;
            this.addPendingChange("timezone", timezone);
        }

        public long getSpaceAmount() {
            return this.spaceAmount;
        }

        public void setSpaceAmount(long spaceAmount) {
            this.spaceAmount = spaceAmount;
            this.addPendingChange("space_amount", spaceAmount);
        }

        public long getSpaceUsed() {
            return this.spaceUsed;
        }

        public long getMaxUploadSize() {
            return this.maxUploadSize;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
            this.addPendingChange("status", status.name().toLowerCase(Locale.ROOT));
        }

        public String getJobTitle() {
            return this.jobTitle;
        }

        public void setJobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            this.addPendingChange("job_title", jobTitle);
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
            this.addPendingChange("phone", phone);
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
            this.addPendingChange("address", address);
        }

        public String getAvatarURL() {
            return this.avatarURL;
        }

        public BoxNotificationEmail getNotificationEmail() {
            return this.notificationEmail;
        }

        public void setNotificationEmail(BoxNotificationEmail notificationEmail) {
            this.notificationEmail = notificationEmail;
        }

        public BoxEnterprise getEnterprise() {
            return this.enterprise;
        }

        public void removeEnterprise() {
            this.removeChildObject("enterprise");
            this.enterprise = null;
            this.addChildObject("enterprise", null);
        }

        public boolean getIsSyncEnabled() {
            return this.isSyncEnabled;
        }

        public void setIsSyncEnabled(boolean enabled) {
            this.isSyncEnabled = enabled;
            this.addPendingChange("is_sync_enabled", enabled);
        }

        public boolean getIsExternalCollabRestricted() {
            return this.isExternalCollabRestricted;
        }

        public void setIsExternalCollabRestricted(boolean isExternalCollabRestricted) {
            this.isExternalCollabRestricted = isExternalCollabRestricted;
            this.addPendingChange("is_external_collab_restricted", isExternalCollabRestricted);
        }

        public boolean getCanSeeManagedUsers() {
            return this.canSeeManagedUsers;
        }

        public void setCanSeeManagedUsers(boolean canSeeManagedUsers) {
            this.canSeeManagedUsers = canSeeManagedUsers;
            this.addPendingChange("can_see_managed_users", canSeeManagedUsers);
        }

        public boolean getIsExemptFromDeviceLimits() {
            return this.isExemptFromDeviceLimits;
        }

        public void setIsExemptFromDeviceLimits(boolean isExemptFromDeviceLimits) {
            this.isExemptFromDeviceLimits = isExemptFromDeviceLimits;
            this.addPendingChange("is_exempt_from_device_limits", isExemptFromDeviceLimits);
        }

        public boolean getIsExemptFromLoginVerification() {
            return this.isExemptFromLoginVerification;
        }

        public void setIsExemptFromLoginVerification(boolean isExemptFromLoginVerification) {
            this.isExemptFromLoginVerification = isExemptFromLoginVerification;
            this.addPendingChange("is_exempt_from_login_verification", isExemptFromLoginVerification);
        }

        public boolean getIsPasswordResetRequired() {
            return this.isPasswordResetRequired;
        }

        public void setIsPasswordResetRequired(boolean isPasswordResetRequired) {
            this.isPasswordResetRequired = isPasswordResetRequired;
            this.addPendingChange("is_password_reset_required", isPasswordResetRequired);
        }

        public boolean getIsPlatformAccessOnly() {
            return this.isPlatformAccessOnly;
        }

        public String getExternalAppUserId() {
            return this.externalAppUserId;
        }

        public void setExternalAppUserId(String externalAppUserId) {
            this.externalAppUserId = externalAppUserId;
            this.addPendingChange("external_app_user_id", externalAppUserId);
        }

        public List<String> getMyTags() {
            return this.myTags;
        }

        public String getHostname() {
            return this.hostname;
        }

        public Map<String, String> getTrackingCodes() {
            return this.trackingCodes;
        }

        public void setTrackingCodes(Map<String, String> trackingCodes) {
            this.trackingCodes = trackingCodes;
            this.addPendingChange("tracking_codes", BoxUser.toTrackingCodesJson(this.trackingCodes));
        }

        public void appendTrackingCodes(String name, String value) {
            this.getTrackingCodes().put(name, value);
            this.addPendingChange("tracking_codes", BoxUser.toTrackingCodesJson(this.trackingCodes));
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            JsonValue value = member.getValue();
            String memberName = member.getName();
            try {
                switch (memberName) {
                    case "login": {
                        this.login = value.asString();
                        break;
                    }
                    case "role": {
                        this.role = Role.fromJSONValue(value.asString());
                        break;
                    }
                    case "language": {
                        this.language = value.asString();
                        break;
                    }
                    case "timezone": {
                        this.timezone = value.asString();
                        break;
                    }
                    case "space_amount": {
                        this.spaceAmount = Double.valueOf(value.toString()).longValue();
                        break;
                    }
                    case "space_used": {
                        this.spaceUsed = Double.valueOf(value.toString()).longValue();
                        break;
                    }
                    case "max_upload_size": {
                        this.maxUploadSize = Double.valueOf(value.toString()).longValue();
                        break;
                    }
                    case "status": {
                        this.status = Status.fromJSONValue(value.asString());
                        break;
                    }
                    case "job_title": {
                        this.jobTitle = value.asString();
                        break;
                    }
                    case "phone": {
                        this.phone = value.asString();
                        break;
                    }
                    case "address": {
                        this.address = value.asString();
                        break;
                    }
                    case "avatar_url": {
                        this.avatarURL = value.asString();
                        break;
                    }
                    case "notification_email": {
                        if (value.isObject()) {
                            this.notificationEmail = new BoxNotificationEmail(value.asObject());
                            break;
                        }
                        this.notificationEmail = null;
                        break;
                    }
                    case "can_see_managed_users": {
                        this.canSeeManagedUsers = value.asBoolean();
                        break;
                    }
                    case "is_sync_enabled": {
                        this.isSyncEnabled = value.asBoolean();
                        break;
                    }
                    case "is_external_collab_restricted": {
                        this.isExternalCollabRestricted = value.asBoolean();
                        break;
                    }
                    case "is_exempt_from_device_limits": {
                        this.isExemptFromDeviceLimits = value.asBoolean();
                        break;
                    }
                    case "is_exempt_from_login_verification": {
                        this.isExemptFromLoginVerification = value.asBoolean();
                        break;
                    }
                    case "is_password_reset_required": {
                        this.isPasswordResetRequired = value.asBoolean();
                        break;
                    }
                    case "is_platform_access_only": {
                        this.isPlatformAccessOnly = value.asBoolean();
                        break;
                    }
                    case "external_app_user_id": {
                        this.externalAppUserId = value.asString();
                        break;
                    }
                    case "enterprise": {
                        JsonObject jsonObject = value.asObject();
                        if (this.enterprise == null) {
                            this.enterprise = new BoxEnterprise(jsonObject);
                            break;
                        }
                        this.enterprise.update(jsonObject);
                        break;
                    }
                    case "my_tags": {
                        this.myTags = this.parseMyTags(value.asArray());
                        break;
                    }
                    case "hostname": {
                        this.hostname = value.asString();
                        break;
                    }
                    case "tracking_codes": {
                        this.trackingCodes = this.parseTrackingCodes(value.asArray());
                    }
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }

        private List<String> parseMyTags(JsonArray jsonArray) {
            ArrayList<String> myTags = new ArrayList<String>(jsonArray.size());
            for (JsonValue value : jsonArray) {
                myTags.add(value.asString());
            }
            return myTags;
        }

        private Map<String, String> parseTrackingCodes(JsonArray jsonArray) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (jsonArray == null) {
                return null;
            }
            List valuesList = jsonArray.values();
            for (JsonValue jsonValue : valuesList) {
                JsonObject object = jsonValue.asObject();
                result.put(object.get("name").asString(), object.get("value").asString());
            }
            return result;
        }
    }

    public static enum Status {
        ACTIVE("active"),
        INACTIVE("inactive"),
        CANNOT_DELETE_EDIT("cannot_delete_edit"),
        CANNOT_DELETE_EDIT_UPLOAD("cannot_delete_edit_upload");

        private final String jsonValue;

        private Status(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Status fromJSONValue(String jsonValue) {
            return Status.valueOf(jsonValue.toUpperCase(Locale.ROOT));
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }

    public static enum Role {
        ADMIN("admin"),
        COADMIN("coadmin"),
        USER("user");

        private final String jsonValue;

        private Role(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Role fromJSONValue(String jsonValue) {
            return Role.valueOf(jsonValue.toUpperCase(Locale.ROOT));
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }
}

