/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonWriter;
import com.cedarsoftware.util.io.Readers;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaUtils {
    private static final Map<Class, Map<String, Field>> classMetaCache = new ConcurrentHashMap<Class, Map<String, Field>>();
    private static final Set<Class> prims = new HashSet<Class>();
    private static final Map<String, Class> nameToClass = new HashMap<String, Class>();
    private static final Byte[] byteCache = new Byte[256];
    private static final Character[] charCache = new Character[128];
    private static final Pattern extraQuotes = Pattern.compile("([\"]*)([^\"]*)([\"]*)");
    private static final Class[] emptyClassArray = new Class[0];
    private static final ConcurrentMap<Class, Object[]> constructors = new ConcurrentHashMap<Class, Object[]>();
    private static final Collection unmodifiableCollection = Collections.unmodifiableCollection(new ArrayList());
    private static final Collection unmodifiableSet = Collections.unmodifiableSet(new HashSet());
    private static final Collection unmodifiableSortedSet = Collections.unmodifiableSortedSet(new TreeSet());
    private static final Map unmodifiableMap = Collections.unmodifiableMap(new HashMap());
    private static final Map unmodifiableSortedMap = Collections.unmodifiableSortedMap(new TreeMap());
    static final ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };
    private static boolean useUnsafe = false;
    private static Unsafe unsafe;
    static Exception loadClassException;

    static {
        prims.add(Byte.class);
        prims.add(Integer.class);
        prims.add(Long.class);
        prims.add(Double.class);
        prims.add(Character.class);
        prims.add(Float.class);
        prims.add(Boolean.class);
        prims.add(Short.class);
        nameToClass.put("string", String.class);
        nameToClass.put("boolean", Boolean.TYPE);
        nameToClass.put("char", Character.TYPE);
        nameToClass.put("byte", Byte.TYPE);
        nameToClass.put("short", Short.TYPE);
        nameToClass.put("int", Integer.TYPE);
        nameToClass.put("long", Long.TYPE);
        nameToClass.put("float", Float.TYPE);
        nameToClass.put("double", Double.TYPE);
        nameToClass.put("date", java.util.Date.class);
        nameToClass.put("class", Class.class);
        int i = 0;
        while (i < byteCache.length) {
            MetaUtils.byteCache[i] = (byte)(i - 128);
            ++i;
        }
        i = 0;
        while (i < charCache.length) {
            MetaUtils.charCache[i] = Character.valueOf((char)i);
            ++i;
        }
    }

    private MetaUtils() {
    }

    public static void setUseUnsafe(boolean state) {
        useUnsafe = state;
        if (state) {
            try {
                unsafe = new Unsafe();
            }
            catch (InvocationTargetException invocationTargetException) {
                useUnsafe = false;
            }
        }
    }

    public static Field getField(Class c, String field) {
        return MetaUtils.getDeepDeclaredFields(c).get(field);
    }

    public static Map<String, Field> getDeepDeclaredFields(Class c) {
        Map<String, Field> classFields = classMetaCache.get(c);
        if (classFields != null) {
            return classFields;
        }
        classFields = new LinkedHashMap<String, Field>();
        Class curr = c;
        while (curr != null) {
            try {
                Field[] local;
                Field[] fieldArray = local = curr.getDeclaredFields();
                int n = local.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (!((field.getModifiers() & 8) != 0 || "metaClass".equals(field.getName()) && "groovy.lang.MetaClass".equals(field.getType().getName()))) {
                        if (!field.isAccessible()) {
                            try {
                                field.setAccessible(true);
                            }
                            catch (Exception exception) {}
                        }
                        if (classFields.containsKey(field.getName())) {
                            classFields.put(String.valueOf(curr.getName()) + '.' + field.getName(), field);
                        } else {
                            classFields.put(field.getName(), field);
                        }
                    }
                    ++n2;
                }
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable throwable) {}
            curr = curr.getSuperclass();
        }
        classMetaCache.put(c, classFields);
        return classFields;
    }

    public static int getDistance(Class a, Class b) {
        if (a.isInterface()) {
            return MetaUtils.getDistanceToInterface(a, b);
        }
        Class curr = b;
        int distance = 0;
        while (curr != a) {
            ++distance;
            if ((curr = curr.getSuperclass()) != null) continue;
            return Integer.MAX_VALUE;
        }
        return distance;
    }

    /*
     * WARNING - void declaration
     */
    static int getDistanceToInterface(Class<?> to, Class<?> from) {
        void var5_9;
        Class<?>[] interfaces;
        LinkedHashSet possibleCandidates = new LinkedHashSet();
        Class<?>[] classArray = interfaces = from.getInterfaces();
        int n = interfaces.length;
        boolean n2 = false;
        while (var5_9 < n) {
            Class<?> interfase = classArray[var5_9];
            if (to.equals(interfase)) {
                return 1;
            }
            if (to.isAssignableFrom(interfase)) {
                possibleCandidates.add(interfase);
            }
            ++var5_9;
        }
        if (from.getSuperclass() != null && to.isAssignableFrom(from.getSuperclass())) {
            possibleCandidates.add(from.getSuperclass());
        }
        int minimum = Integer.MAX_VALUE;
        for (Class clazz : possibleCandidates) {
            int distance = MetaUtils.getDistanceToInterface(to, clazz);
            if (distance >= minimum) continue;
            minimum = ++distance;
        }
        return minimum;
    }

    public static boolean isPrimitive(Class c) {
        return c.isPrimitive() || prims.contains(c);
    }

    public static boolean isLogicalPrimitive(Class c) {
        return c.isPrimitive() || prims.contains(c) || String.class.isAssignableFrom(c) || Number.class.isAssignableFrom(c) || java.util.Date.class.isAssignableFrom(c) || c.isEnum() || c.equals(Class.class);
    }

    static Class classForName(String name, ClassLoader classLoader, boolean failOnClassLoadingError) {
        if (name == null || name.isEmpty()) {
            throw new JsonIoException("Class name cannot be null or empty.");
        }
        Class c = nameToClass.get(name);
        try {
            loadClassException = null;
            return c == null ? MetaUtils.loadClass(name, classLoader) : c;
        }
        catch (Exception e) {
            loadClassException = e;
            if (failOnClassLoadingError) {
                throw new JsonIoException("Unable to create class: " + name, e);
            }
            return LinkedHashMap.class;
        }
    }

    static Class classForName(String name, ClassLoader classLoader) {
        return MetaUtils.classForName(name, classLoader, false);
    }

    private static Class loadClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        String className = name;
        boolean arrayType = false;
        Class<Object> primitiveArray = null;
        while (className.startsWith("[")) {
            arrayType = true;
            if (className.endsWith(";")) {
                className = className.substring(0, className.length() - 1);
            }
            if (className.equals("[B")) {
                primitiveArray = byte[].class;
            } else if (className.equals("[S")) {
                primitiveArray = short[].class;
            } else if (className.equals("[I")) {
                primitiveArray = int[].class;
            } else if (className.equals("[J")) {
                primitiveArray = long[].class;
            } else if (className.equals("[F")) {
                primitiveArray = float[].class;
            } else if (className.equals("[D")) {
                primitiveArray = double[].class;
            } else if (className.equals("[Z")) {
                primitiveArray = boolean[].class;
            } else if (className.equals("[C")) {
                primitiveArray = char[].class;
            }
            int startpos = className.startsWith("[L") ? 2 : 1;
            className = className.substring(startpos);
        }
        Class<?> currentClass = null;
        if (primitiveArray == null) {
            try {
                currentClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                currentClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
        }
        if (arrayType) {
            currentClass = primitiveArray != null ? primitiveArray : Array.newInstance(currentClass, 0).getClass();
            while (name.startsWith("[[")) {
                currentClass = Array.newInstance(currentClass, 0).getClass();
                name = name.substring(1);
            }
        }
        return currentClass;
    }

    static Character valueOf(char c) {
        return Character.valueOf(c <= '\u007f' ? charCache[c].charValue() : c);
    }

    static String removeLeadingAndTrailingQuotes(String s) {
        Matcher m = extraQuotes.matcher(s);
        if (m.find()) {
            s = m.group(2);
        }
        return s;
    }

    public static Object newInstance(Class c) {
        if (unmodifiableSortedMap.getClass().isAssignableFrom(c)) {
            return new TreeMap();
        }
        if (unmodifiableMap.getClass().isAssignableFrom(c)) {
            return new LinkedHashMap();
        }
        if (unmodifiableSortedSet.getClass().isAssignableFrom(c)) {
            return new TreeSet();
        }
        if (unmodifiableSet.getClass().isAssignableFrom(c)) {
            return new LinkedHashSet();
        }
        if (unmodifiableCollection.getClass().isAssignableFrom(c)) {
            return new ArrayList();
        }
        if (c.isInterface()) {
            throw new JsonIoException("Cannot instantiate unknown interface: " + c.getName());
        }
        Object[] constructorInfo = (Object[])constructors.get(c);
        if (constructorInfo != null) {
            Constructor constructor = (Constructor)constructorInfo[0];
            if (constructor == null && useUnsafe) {
                try {
                    return unsafe.allocateInstance(c);
                }
                catch (Exception e) {
                    throw new JsonIoException("Could not instantiate " + c.getName(), e);
                }
            }
            if (constructor == null) {
                throw new JsonIoException("No constructor found to instantiate " + c.getName());
            }
            Boolean useNull = (Boolean)constructorInfo[1];
            Class[] paramTypes = constructor.getParameterTypes();
            if (paramTypes == null || paramTypes.length == 0) {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new JsonIoException("Could not instantiate " + c.getName(), e);
                }
            }
            Object[] values = MetaUtils.fillArgs(paramTypes, useNull);
            try {
                return constructor.newInstance(values);
            }
            catch (Exception e) {
                throw new JsonIoException("Could not instantiate " + c.getName(), e);
            }
        }
        Object[] ret = MetaUtils.newInstanceEx(c);
        constructors.put(c, new Object[]{ret[1], ret[2]});
        return ret[0];
    }

    static Object[] newInstanceEx(Class c) {
        try {
            Constructor constructor = c.getConstructor(emptyClassArray);
            if (constructor != null) {
                return new Object[]{constructor.newInstance(new Object[0]), constructor, true};
            }
            return MetaUtils.tryOtherConstruction(c);
        }
        catch (Exception exception) {
            return MetaUtils.tryOtherConstruction(c);
        }
    }

    static Object[] tryOtherConstruction(Class c) {
        Object[] values;
        Class[] argTypes;
        Constructor<?>[] constructors = c.getDeclaredConstructors();
        if (constructors.length == 0) {
            throw new JsonIoException("Cannot instantiate '" + c.getName() + "' - Primitive, interface, array[] or void");
        }
        List<Constructor<?>> constructorList = Arrays.asList(constructors);
        Collections.sort(constructorList, new Comparator<Constructor>(){

            @Override
            public int compare(Constructor c1, Constructor c2) {
                int c2Vis;
                int c1Vis = c1.getModifiers();
                if (c1Vis == (c2Vis = c2.getModifiers())) {
                    return MetaUtils.compareConstructors(c1, c2);
                }
                if (Modifier.isPublic(c1Vis) != Modifier.isPublic(c2Vis)) {
                    return Modifier.isPublic(c1Vis) ? -1 : 1;
                }
                if (Modifier.isProtected(c1Vis) != Modifier.isProtected(c2Vis)) {
                    return Modifier.isProtected(c1Vis) ? -1 : 1;
                }
                if (Modifier.isPrivate(c1Vis) != Modifier.isPrivate(c2Vis)) {
                    return Modifier.isPrivate(c1Vis) ? 1 : -1;
                }
                return 0;
            }
        });
        for (Constructor<?> constructor : constructorList) {
            constructor.setAccessible(true);
            argTypes = constructor.getParameterTypes();
            values = MetaUtils.fillArgs(argTypes, true);
            try {
                return new Object[]{constructor.newInstance(values), constructor, true};
            }
            catch (Exception exception) {}
        }
        for (Constructor<?> constructor : constructorList) {
            constructor.setAccessible(true);
            argTypes = constructor.getParameterTypes();
            values = MetaUtils.fillArgs(argTypes, false);
            try {
                return new Object[]{constructor.newInstance(values), constructor, false};
            }
            catch (Exception exception) {}
        }
        if (useUnsafe) {
            try {
                Object[] objectArray = new Object[3];
                objectArray[0] = unsafe.allocateInstance(c);
                return objectArray;
            }
            catch (Exception exception) {}
        }
        throw new JsonIoException("Could not instantiate " + c.getName() + " using any constructor");
    }

    private static int compareConstructors(Constructor c1, Constructor c2) {
        Class<?>[] c2ParamTypes;
        Class<?>[] c1ParamTypes = c1.getParameterTypes();
        if (c1ParamTypes.length != (c2ParamTypes = c2.getParameterTypes()).length) {
            return c1ParamTypes.length - c2ParamTypes.length;
        }
        int len = c1ParamTypes.length;
        int i = 0;
        while (i < len) {
            Class<?> class1 = c1ParamTypes[i];
            Class<?> class2 = c2ParamTypes[i];
            int compare = class1.getName().compareTo(class2.getName());
            if (compare != 0) {
                return compare;
            }
            ++i;
        }
        return 0;
    }

    static Object[] fillArgs(Class[] argTypes, boolean useNull) {
        Object[] values = new Object[argTypes.length];
        int i = 0;
        while (i < argTypes.length) {
            Class argType = argTypes[i];
            if (MetaUtils.isPrimitive(argType)) {
                values[i] = MetaUtils.convert(argType, null);
            } else if (useNull) {
                values[i] = null;
            } else if (argType == String.class) {
                values[i] = "";
            } else if (argType == java.util.Date.class) {
                values[i] = new java.util.Date();
            } else if (List.class.isAssignableFrom(argType)) {
                values[i] = new ArrayList();
            } else if (SortedSet.class.isAssignableFrom(argType)) {
                values[i] = new TreeSet();
            } else if (Set.class.isAssignableFrom(argType)) {
                values[i] = new LinkedHashSet();
            } else if (SortedMap.class.isAssignableFrom(argType)) {
                values[i] = new TreeMap();
            } else if (Map.class.isAssignableFrom(argType)) {
                values[i] = new LinkedHashMap();
            } else if (Collection.class.isAssignableFrom(argType)) {
                values[i] = new ArrayList();
            } else if (Calendar.class.isAssignableFrom(argType)) {
                values[i] = Calendar.getInstance();
            } else if (TimeZone.class.isAssignableFrom(argType)) {
                values[i] = TimeZone.getDefault();
            } else if (argType == BigInteger.class) {
                values[i] = BigInteger.TEN;
            } else if (argType == BigDecimal.class) {
                values[i] = BigDecimal.TEN;
            } else if (argType == StringBuilder.class) {
                values[i] = new StringBuilder();
            } else if (argType == StringBuffer.class) {
                values[i] = new StringBuffer();
            } else if (argType == Locale.class) {
                values[i] = Locale.FRANCE;
            } else if (argType == Class.class) {
                values[i] = String.class;
            } else if (argType == Timestamp.class) {
                values[i] = new Timestamp(System.currentTimeMillis());
            } else if (argType == Date.class) {
                values[i] = new Date(System.currentTimeMillis());
            } else if (argType == URL.class) {
                try {
                    values[i] = new URL("http://localhost");
                }
                catch (MalformedURLException malformedURLException) {
                    values[i] = null;
                }
            } else {
                values[i] = argType == Object.class ? new Object() : null;
            }
            ++i;
        }
        return values;
    }

    static Object convert(Class c, Object rhs) {
        try {
            if (c == Boolean.TYPE || c == Boolean.class) {
                if (rhs instanceof String) {
                    if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "false";
                    }
                    return Boolean.parseBoolean((String)rhs);
                }
                return rhs != null ? rhs : Boolean.FALSE;
            }
            if (c == Byte.TYPE || c == Byte.class) {
                if (rhs instanceof String) {
                    if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "0";
                    }
                    return Byte.parseByte((String)rhs);
                }
                return rhs != null ? byteCache[((Number)rhs).byteValue() + 128] : (byte)0;
            }
            if (c == Character.TYPE || c == Character.class) {
                if (rhs == null) {
                    return Character.valueOf('\u0000');
                }
                if (rhs instanceof String) {
                    if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "\u0000";
                    }
                    return Character.valueOf(((CharSequence)rhs).charAt(0));
                }
                if (rhs instanceof Character) {
                    return rhs;
                }
            } else {
                if (c == Double.TYPE || c == Double.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0.0";
                        }
                        return Double.parseDouble((String)rhs);
                    }
                    return rhs != null ? ((Number)rhs).doubleValue() : 0.0;
                }
                if (c == Float.TYPE || c == Float.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0.0f";
                        }
                        return Float.valueOf(Float.parseFloat((String)rhs));
                    }
                    return Float.valueOf(rhs != null ? ((Number)rhs).floatValue() : 0.0f);
                }
                if (c == Integer.TYPE || c == Integer.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0";
                        }
                        return Integer.parseInt((String)rhs);
                    }
                    return rhs != null ? ((Number)rhs).intValue() : 0;
                }
                if (c == Long.TYPE || c == Long.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0";
                        }
                        return Long.parseLong((String)rhs);
                    }
                    return rhs != null ? ((Number)rhs).longValue() : 0L;
                }
                if (c == Short.TYPE || c == Short.class) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0";
                        }
                        return Short.parseShort((String)rhs);
                    }
                    return rhs != null ? ((Number)rhs).shortValue() : (short)0;
                }
                if (c == java.util.Date.class) {
                    if (rhs instanceof String) {
                        return Readers.DateReader.parseDate((String)rhs);
                    }
                    if (rhs instanceof Long) {
                        return new java.util.Date((Long)rhs);
                    }
                } else {
                    if (c == BigInteger.class) {
                        return Readers.bigIntegerFrom(rhs);
                    }
                    if (c == BigDecimal.class) {
                        return Readers.bigDecimalFrom(rhs);
                    }
                }
            }
        }
        catch (Exception e) {
            String className = c == null ? "null" : c.getName();
            throw new JsonIoException("Error creating primitive wrapper instance for Class: " + className, e);
        }
        throw new JsonIoException("Class '" + c.getName() + "' does not have primitive wrapper.");
    }

    public static String getLogMessage(String methodName, Object[] args) {
        return MetaUtils.getLogMessage(methodName, args, 64);
    }

    public static String getLogMessage(String methodName, Object[] args, int argCharLen) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append('(');
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            sb.append(MetaUtils.getJsonStringToMaxLength(arg, argCharLen));
            sb.append("  ");
            ++n2;
        }
        String result = sb.toString().trim();
        return String.valueOf(result) + ')';
    }

    private static String getJsonStringToMaxLength(Object obj, int argCharLen) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("TYPE", false);
        args.put("SHORT_META_KEYS", true);
        String arg = JsonWriter.objectToJson(obj, args);
        if (arg.length() > argCharLen) {
            arg = String.valueOf(arg.substring(0, argCharLen)) + "...";
        }
        return arg;
    }

    static final class Unsafe {
        private final Object sunUnsafe;
        private final Method allocateInstance;

        public Unsafe() throws InvocationTargetException {
            try {
                Constructor unsafeConstructor = MetaUtils.classForName("sun.misc.Unsafe", MetaUtils.class.getClassLoader()).getDeclaredConstructor(new Class[0]);
                unsafeConstructor.setAccessible(true);
                this.sunUnsafe = unsafeConstructor.newInstance(new Object[0]);
                this.allocateInstance = this.sunUnsafe.getClass().getMethod("allocateInstance", Class.class);
                this.allocateInstance.setAccessible(true);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }

        public Object allocateInstance(Class clazz) {
            try {
                return this.allocateInstance.invoke(this.sunUnsafe, clazz);
            }
            catch (IllegalAccessException e) {
                String name = clazz == null ? "null" : clazz.getName();
                throw new JsonIoException("Unable to create instance of class: " + name, e);
            }
            catch (IllegalArgumentException e) {
                String name = clazz == null ? "null" : clazz.getName();
                throw new JsonIoException("Unable to create instance of class: " + name, e);
            }
            catch (InvocationTargetException e) {
                String name = clazz == null ? "null" : clazz.getName();
                throw new JsonIoException("Unable to create instance of class: " + name, e.getCause() != null ? e.getCause() : e);
            }
        }
    }
}

