/**
 * Copyright (c) 2017 by CyberSource
 */
package com.cybersource.flex.sdk;

import com.cybersource.flex.sdk.exception.FlexException;
import com.cybersource.flex.sdk.model.FlexPublicKey;
import com.cybersource.flex.sdk.model.FlexToken;
import com.cybersource.flex.sdk.model.KeysRequestParameters;
import java.security.PublicKey;
import java.util.Map;
import javax.security.auth.Destroyable;

public interface FlexService extends Destroyable {

    /**
     *
     * @return Flex-API specific limited time use public RSA key. The encryption
     * defaults to RSA with OEAP padding, @see EncryptionType.RsaOaep256.
     * @throws FlexException
     */
    FlexPublicKey createKey() throws FlexException;

    /**
     *
     * @param params
     * @return the flexPublicKey instance
     * @throws FlexException
     */
    FlexPublicKey createKey(KeysRequestParameters params) throws FlexException;

    /**
     *
     * @param keyId
     * @return the flexPublicKey instance
     * @throws FlexException
     */
    FlexPublicKey retrieveKey(String keyId) throws FlexException;

    PublicKey decodePublicKey(FlexPublicKey flexKey) throws FlexException;

    boolean verify(String flexKey, String token) throws FlexException;

    boolean verify(FlexPublicKey flexKey, String token) throws FlexException;

    boolean verify(FlexPublicKey flexKey, FlexToken token) throws FlexException;

    boolean verify(FlexPublicKey flexKey, Map postParams) throws FlexException;

}
