/**
 * Copyright (c) 2017 by CyberSource
 */
package com.cybersource.flex.sdk;

import com.cybersource.flex.sdk.authentication.FlexCredentials;
import com.cybersource.flex.sdk.impl.FlexKeyServiceImpl;

public class FlexServiceFactory {

    public static FlexService createInstance(FlexCredentials credentials) {
        return new FlexKeyServiceImpl(credentials, FlexServiceFactory.FlexServiceConfiguration.DEFAULT);
    }

    public static FlexService createInstance(FlexCredentials credentials, FlexServiceConfiguration flexServiceConfiguration) {
        return new FlexKeyServiceImpl(credentials, flexServiceConfiguration);
    }

    public static class FlexServiceConfiguration {

        public final static FlexServiceConfiguration DEFAULT = new FlexServiceConfigurationBuilder().build();
        public final static FlexServiceConfiguration DEBUG = new FlexServiceConfigurationBuilder().setLoggingEnabled(true).build();

        private final boolean loggingEnabled;
        // configurable timeouts to be added in future

        private FlexServiceConfiguration(boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
        }

        public boolean isLoggingEnabled() {
            return loggingEnabled;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("version:").append("0.1.1").append(",");
            sb.append("loggingEnabled:").append(loggingEnabled).append(",");
            sb.append("}");
            return sb.toString();
        }

    }

    public static class FlexServiceConfigurationBuilder {

        private boolean loggingEnabled = false;

        public FlexServiceConfiguration build() {
            return new FlexServiceConfiguration(loggingEnabled);
        }

        public boolean isLoggingEnabled() {
            return loggingEnabled;
        }

        public FlexServiceConfigurationBuilder setLoggingEnabled(boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
            return this;
        }

    }

}
