/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.shaded.common.base.MoreObjects;
import java.net.URI;
import java.util.Map;

public class DatabendSession {
    private static final String DEFAULT_DATABASE = "default";
    private static final int DEFAULT_SESSION_ALIVE_SECS = 30;
    private final String database;
    private final int keepServerSessionSecs;
    private final Map<String, String> settings;

    @JsonCreator
    public DatabendSession(@JsonProperty(value="database") String database, @JsonProperty(value="keep_server_session_secs") int keepServerSessionSecs, @JsonProperty(value="settings") Map<String, String> settings2) {
        this.database = database;
        this.keepServerSessionSecs = keepServerSessionSecs;
        this.settings = settings2;
    }

    public static DatabendSession createDefault() {
        return new DatabendSession(DEFAULT_DATABASE, 30, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty
    public int getKeepServerSessionSecs() {
        return this.keepServerSessionSecs;
    }

    @JsonProperty
    public Map<String, String> getSettings() {
        return this.settings;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("database", this.database).add("keepServerSessionSecs", this.keepServerSessionSecs).add("settings", this.settings).toString();
    }

    public static final class Builder {
        private URI host;
        private String database;
        private int keepServerSessionSecs = 30;
        private Map<String, String> settings;

        public Builder setHost(URI host) {
            this.host = host;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setKeepServerSessionSecs(int keepServerSessionSecs) {
            this.keepServerSessionSecs = keepServerSessionSecs;
            return this;
        }

        public Builder setSettings(Map<String, String> settings2) {
            this.settings = settings2;
            return this;
        }

        public DatabendSession build() {
            return new DatabendSession(this.database, this.keepServerSessionSecs, this.settings);
        }
    }
}

