/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.shaded.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;

public class StageAttachment {
    private final String location;
    public static final String defaultFileFormat = "CSV";
    private final Map<String, String> fileFormatOptions;
    private final Map<String, String> copyOptions;

    @JsonCreator
    public StageAttachment(@JsonProperty(value="location") String location, @JsonProperty(value="file_format_options") Map<String, String> fileFormatOptions, @JsonProperty(value="copy_options") Map<String, String> copyOptions) {
        this.location = location;
        StringBuilder sb = new StringBuilder();
        sb.append("( type = ");
        this.fileFormatOptions = fileFormatOptions == null ? new HashMap<String, String>() : fileFormatOptions;
        this.fileFormatOptions.put("type", defaultFileFormat);
        this.copyOptions = copyOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    @JsonProperty(value="file_format_options")
    public Map<String, String> getFileFormatOptions() {
        return this.fileFormatOptions;
    }

    @JsonProperty(value="copy_options")
    public Map<String, String> getCopyOptions() {
        return this.copyOptions;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("location", this.location).add("file_format_options", this.fileFormatOptions).add("copy_options", this.copyOptions).toString();
    }

    public static final class Builder {
        private String location;
        private Map<String, String> fileFormatOptions;
        private Map<String, String> copyOptions;

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFileFormatOptions(Map<String, String> fileFormatOptions) {
            this.fileFormatOptions = fileFormatOptions;
            return this;
        }

        public Builder setCopyOptions(Map<String, String> copyOptions) {
            this.copyOptions = copyOptions;
            return this;
        }

        public StageAttachment build() {
            return new StageAttachment(this.location, this.fileFormatOptions, this.copyOptions);
        }
    }
}

