/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml;

import com.databricks.spark.xml.XmlInputFormat$;
import com.databricks.spark.xml.XmlOptions$;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t5b!\u0002\u001c8\u0001]z\u0004\"B+\u0001\t\u00039\u0006\"\u0003.\u0001\u0001\u0004\u0005\r\u0011\"\u0003\\\u0011%I\u0007\u00011AA\u0002\u0013%!\u000eC\u0005r\u0001\u0001\u0007\t\u0011)Q\u00059\"I!\u000f\u0001a\u0001\u0002\u0004%Ia\u0017\u0005\ng\u0002\u0001\r\u00111A\u0005\nQD\u0011B\u001e\u0001A\u0002\u0003\u0005\u000b\u0015\u0002/\t\u0013]\u0004\u0001\u0019!a\u0001\n\u0013Y\u0006\"\u0003=\u0001\u0001\u0004\u0005\r\u0011\"\u0003z\u0011%Y\b\u00011A\u0001B\u0003&A\fC\u0005}\u0001\u0001\u0007\t\u0019!C\u0005{\"Ia\u0010\u0001a\u0001\u0002\u0004%Ia \u0005\u000b\u0003\u0007\u0001\u0001\u0019!A!B\u0013a\u0005bCA\u0003\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000fA1\"!\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\f!Q\u0011q\u0002\u0001A\u0002\u0003\u0005\u000b\u0015\u0002*\t\u0017\u0005E\u0001\u00011AA\u0002\u0013%\u00111\u0003\u0005\f\u00037\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0002C\u0006\u0002\"\u0001\u0001\r\u0011!Q!\n\u0005U\u0001bCA\u0012\u0001\u0001\u0007\t\u0019!C\u0005\u0003'A1\"!\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002(!Y\u00111\u0006\u0001A\u0002\u0003\u0005\u000b\u0015BA\u000b\u0011-\ti\u0003\u0001a\u0001\u0002\u0004%I!a\f\t\u0017\u0005}\u0002\u00011AA\u0002\u0013%\u0011\u0011\t\u0005\f\u0003\u000b\u0002\u0001\u0019!A!B\u0013\t\t\u0004C\u0006\u0002H\u0001\u0001\r\u00111A\u0005\n\u0005%\u0003bCA,\u0001\u0001\u0007\t\u0019!C\u0005\u00033B1\"!\u0018\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002L!Y\u0011q\f\u0001A\u0002\u0003\u0007I\u0011BA1\u0011-\t)\b\u0001a\u0001\u0002\u0004%I!a\u001e\t\u0017\u0005m\u0004\u00011A\u0001B\u0003&\u00111\r\u0005\f\u0003{\u0002\u0001\u0019!a\u0001\n\u0013\ty\bC\u0006\u0002\u000e\u0002\u0001\r\u00111A\u0005\n\u0005=\u0005bCAJ\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0003C1\"!&\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0018\"Y\u0011Q\u0015\u0001A\u0002\u0003\u0007I\u0011BAT\u0011-\tY\u000b\u0001a\u0001\u0002\u0003\u0006K!!'\t\u0017\u00055\u0006\u00011AA\u0002\u0013%\u0011q\u0016\u0005\f\u0003{\u0003\u0001\u0019!a\u0001\n\u0013\ty\fC\u0006\u0002D\u0002\u0001\r\u0011!Q!\n\u0005E\u0006\"CAc\u0001\u0001\u0007I\u0011BAd\u0011%\tI\u000e\u0001a\u0001\n\u0013\tY\u000e\u0003\u0005\u0002`\u0002\u0001\u000b\u0015BAe\u0011\u001d\t\t\u000f\u0001C!\u0003GDq!!?\u0001\t\u0013\tY\u0010C\u0004\u0002~\u0002!\t%a@\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004!9!Q\u0002\u0001\u0005\n\u0005}\bb\u0002B\b\u0001\u0011%!\u0011\u0003\u0005\b\u0005/\u0001A\u0011\tB\r\u0011\u001d\u0011\t\u0003\u0001C!\u0005GAqA!\n\u0001\t\u0003\u00129\u0003C\u0004\u0003*\u0001!\tAa\u000b\u0003\u001fakGNU3d_J$'+Z1eKJT!\u0001O\u001d\u0002\u0007alGN\u0003\u0002;w\u0005)1\u000f]1sW*\u0011A(P\u0001\u000bI\u0006$\u0018M\u0019:jG.\u001c(\"\u0001 \u0002\u0007\r|Wn\u0005\u0002\u0001\u0001B!\u0011I\u0013'S\u001b\u0005\u0011%BA\"E\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002F\r\u00061\u0001.\u00193p_BT!a\u0012%\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0015aA8sO&\u00111J\u0011\u0002\r%\u0016\u001cwN\u001d3SK\u0006$WM\u001d\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\u0012\u000b!![8\n\u0005Es%\u0001\u0004'p]\u001e<&/\u001b;bE2,\u0007CA'T\u0013\t!fJ\u0001\u0003UKb$\u0018A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003a\u0003\"!\u0017\u0001\u000e\u0003]\n\u0001b\u001d;beR$\u0016mZ\u000b\u00029B\u0011QL\u001a\b\u0003=\u0012\u0004\"a\u00182\u000e\u0003\u0001T!!\u0019,\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0019\u0017!B:dC2\f\u0017BA3c\u0003\u0019\u0001&/\u001a3fM&\u0011q\r\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015\u0014\u0017\u0001D:uCJ$H+Y4`I\u0015\fHCA6p!\taW.D\u0001c\u0013\tq'M\u0001\u0003V]&$\bb\u00029\u0004\u0003\u0003\u0005\r\u0001X\u0001\u0004q\u0012\n\u0014!C:uCJ$H+Y4!\u0003=\u0019WO\u001d:f]R\u001cF/\u0019:u)\u0006<\u0017aE2veJ,g\u000e^*uCJ$H+Y4`I\u0015\fHCA6v\u0011\u001d\u0001h!!AA\u0002q\u000b\u0001cY;se\u0016tGo\u0015;beR$\u0016m\u001a\u0011\u0002\r\u0015tG\rV1h\u0003))g\u000e\u001a+bO~#S-\u001d\u000b\u0003WjDq\u0001]\u0005\u0002\u0002\u0003\u0007A,A\u0004f]\u0012$\u0016m\u001a\u0011\u0002\u0015\r,(O]3oi.+\u00170F\u0001M\u00039\u0019WO\u001d:f]R\\U-_0%KF$2a[A\u0001\u0011\u001d\u0001H\"!AA\u00021\u000b1bY;se\u0016tGoS3zA\u0005a1-\u001e:sK:$h+\u00197vKV\t!+\u0001\tdkJ\u0014XM\u001c;WC2,Xm\u0018\u0013fcR\u00191.!\u0004\t\u000fA|\u0011\u0011!a\u0001%\u0006i1-\u001e:sK:$h+\u00197vK\u0002\nQa\u001d;beR,\"!!\u0006\u0011\u00071\f9\"C\u0002\u0002\u001a\t\u0014A\u0001T8oO\u0006I1\u000f^1si~#S-\u001d\u000b\u0004W\u0006}\u0001\u0002\u00039\u0013\u0003\u0003\u0005\r!!\u0006\u0002\rM$\u0018M\u001d;!\u0003\r)g\u000eZ\u0001\bK:$w\fJ3r)\rY\u0017\u0011\u0006\u0005\taV\t\t\u00111\u0001\u0002\u0016\u0005!QM\u001c3!\u0003\u0019\u0011X-\u00193feV\u0011\u0011\u0011\u0007\t\u0005\u0003g\tY$\u0004\u0002\u00026)\u0019q*a\u000e\u000b\u0005\u0005e\u0012\u0001\u00026bm\u0006LA!!\u0010\u00026\t1!+Z1eKJ\f!B]3bI\u0016\u0014x\fJ3r)\rY\u00171\t\u0005\tab\t\t\u00111\u0001\u00022\u00059!/Z1eKJ\u0004\u0013\u0001\u00044jY\u0016\u0004vn]5uS>tWCAA&!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)\t\u0006\u0011am]\u0005\u0005\u0003+\nyE\u0001\u0005TK\u0016\\\u0017M\u00197f\u0003A1\u0017\u000e\\3Q_NLG/[8o?\u0012*\u0017\u000fF\u0002l\u00037B\u0001\u0002]\u000e\u0002\u0002\u0003\u0007\u00111J\u0001\u000eM&dW\rU8tSRLwN\u001c\u0011\u0002\u0015\r|WO\u001c;j]\u001eLe.\u0006\u0002\u0002dA!\u0011QMA9\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014!B5oaV$(bA(\u0002n)\u0019\u0011q\u000e$\u0002\u000f\r|W.\\8og&!\u00111OA4\u0005M\u0019u.\u001e8uS:<\u0017J\u001c9viN#(/Z1n\u00039\u0019w.\u001e8uS:<\u0017J\\0%KF$2a[A=\u0011!\u0001h$!AA\u0002\u0005\r\u0014aC2pk:$\u0018N\\4J]\u0002\nAC]3bI\u0016\u0014H*\u001a4u_Z,'o\u00115be\u001asWCAAA!\u0015a\u00171QAD\u0013\r\t)I\u0019\u0002\n\rVt7\r^5p]B\u00022\u0001\\AE\u0013\r\tYI\u0019\u0002\b\u0005>|G.Z1o\u0003a\u0011X-\u00193fe2+g\r^8wKJ\u001c\u0005.\u0019:G]~#S-\u001d\u000b\u0004W\u0006E\u0005\u0002\u00039\"\u0003\u0003\u0005\r!!!\u0002+I,\u0017\rZ3s\u0019\u00164Go\u001c<fe\u000eC\u0017M\u001d$oA\u0005\u0001\"/Z1eKJ\u0014\u0015\u0010^3Ck\u001a4WM]\u000b\u0003\u00033\u0003B!a'\u0002\"6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b9$A\u0002oS>LA!a)\u0002\u001e\nQ!)\u001f;f\u0005V4g-\u001a:\u0002)I,\u0017\rZ3s\u0005f$XMQ;gM\u0016\u0014x\fJ3r)\rY\u0017\u0011\u0016\u0005\ta\u0012\n\t\u00111\u0001\u0002\u001a\u0006\t\"/Z1eKJ\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u0011\u0002\u0019\u0011,7m\\7qe\u0016\u001c8o\u001c:\u0016\u0005\u0005E\u0006\u0003BAZ\u0003sk!!!.\u000b\u0007\u0005]f*\u0001\u0005d_6\u0004(/Z:t\u0013\u0011\tY,!.\u0003\u0019\u0011+7m\\7qe\u0016\u001c8o\u001c:\u0002!\u0011,7m\\7qe\u0016\u001c8o\u001c:`I\u0015\fHcA6\u0002B\"A\u0001oJA\u0001\u0002\u0004\t\t,A\u0007eK\u000e|W\u000e\u001d:fgN|'\u000fI\u0001\u0007EV4g-\u001a:\u0016\u0005\u0005%\u0007\u0003BAf\u0003+l!!!4\u000b\t\u0005=\u0017\u0011[\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019NY\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAl\u0003\u001b\u0014Qb\u0015;sS:<')^5mI\u0016\u0014\u0018A\u00032vM\u001a,'o\u0018\u0013fcR\u00191.!8\t\u0011AT\u0013\u0011!a\u0001\u0003\u0013\fqAY;gM\u0016\u0014\b%\u0001\u0006j]&$\u0018.\u00197ju\u0016$Ra[As\u0003_Dq!a:-\u0001\u0004\tI/A\u0003ta2LG\u000fE\u0002B\u0003WL1!!<C\u0005)Ie\u000e];u'Bd\u0017\u000e\u001e\u0005\b\u0003cd\u0003\u0019AAz\u0003\u001d\u0019wN\u001c;fqR\u00042!QA{\u0013\r\t9P\u0011\u0002\u0013)\u0006\u001c8.\u0011;uK6\u0004HoQ8oi\u0016DH/A\bhKR4\u0015\u000e\\3Q_NLG/[8o)\t\t)\"\u0001\u0007oKb$8*Z=WC2,X\r\u0006\u0002\u0002\b\u0006!a.\u001a=u)\u0019\t9I!\u0002\u0003\n!1!qA\u0018A\u00021\u000b1a[3z\u0011\u0019\u0011Ya\fa\u0001%\u0006)a/\u00197vK\u0006)\"/Z1e+:$\u0018\u000e\\*uCJ$X\t\\3nK:$\u0018a\u0005:fC\u0012,f\u000e^5m\u000b:$W\t\\3nK:$H\u0003BAD\u0005'AqA!\u00062\u0001\u0004\t9)\u0001\bti\u0006\u0014H\u000fV1h\u00072|7/\u001a3\u0002\u0017\u001d,G\u000f\u0015:pOJ,7o\u001d\u000b\u0003\u00057\u00012\u0001\u001cB\u000f\u0013\r\u0011yB\u0019\u0002\u0006\r2|\u0017\r^\u0001\u000eO\u0016$8)\u001e:sK:$8*Z=\u0015\u00031\u000bqbZ3u\u0007V\u0014(/\u001a8u-\u0006dW/\u001a\u000b\u0002%\u0006)1\r\\8tKR\t1\u000e")
public class XmlRecordReader
extends RecordReader<LongWritable, Text> {
    private String startTag;
    private String currentStartTag;
    private String endTag;
    private LongWritable currentKey;
    private Text currentValue;
    private long start;
    private long end;
    private Reader reader;
    private Seekable filePosition;
    private CountingInputStream countingIn;
    private Function0<Object> readerLeftoverCharFn;
    private ByteBuffer readerByteBuffer;
    private Decompressor decompressor;
    private scala.collection.mutable.StringBuilder buffer = new scala.collection.mutable.StringBuilder();

    private String startTag() {
        return this.startTag;
    }

    private void startTag_$eq(String x$1) {
        this.startTag = x$1;
    }

    private String currentStartTag() {
        return this.currentStartTag;
    }

    private void currentStartTag_$eq(String x$1) {
        this.currentStartTag = x$1;
    }

    private String endTag() {
        return this.endTag;
    }

    private void endTag_$eq(String x$1) {
        this.endTag = x$1;
    }

    private LongWritable currentKey() {
        return this.currentKey;
    }

    private void currentKey_$eq(LongWritable x$1) {
        this.currentKey = x$1;
    }

    private Text currentValue() {
        return this.currentValue;
    }

    private void currentValue_$eq(Text x$1) {
        this.currentValue = x$1;
    }

    private long start() {
        return this.start;
    }

    private void start_$eq(long x$1) {
        this.start = x$1;
    }

    private long end() {
        return this.end;
    }

    private void end_$eq(long x$1) {
        this.end = x$1;
    }

    private Reader reader() {
        return this.reader;
    }

    private void reader_$eq(Reader x$1) {
        this.reader = x$1;
    }

    private Seekable filePosition() {
        return this.filePosition;
    }

    private void filePosition_$eq(Seekable x$1) {
        this.filePosition = x$1;
    }

    private CountingInputStream countingIn() {
        return this.countingIn;
    }

    private void countingIn_$eq(CountingInputStream x$1) {
        this.countingIn = x$1;
    }

    private Function0<Object> readerLeftoverCharFn() {
        return this.readerLeftoverCharFn;
    }

    private void readerLeftoverCharFn_$eq(Function0<Object> x$1) {
        this.readerLeftoverCharFn = x$1;
    }

    private ByteBuffer readerByteBuffer() {
        return this.readerByteBuffer;
    }

    private void readerByteBuffer_$eq(ByteBuffer x$1) {
        this.readerByteBuffer = x$1;
    }

    private Decompressor decompressor() {
        return this.decompressor;
    }

    private void decompressor_$eq(Decompressor x$1) {
        this.decompressor = x$1;
    }

    private scala.collection.mutable.StringBuilder buffer() {
        return this.buffer;
    }

    private void buffer_$eq(scala.collection.mutable.StringBuilder x$1) {
        this.buffer = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(InputSplit split, TaskAttemptContext context) {
        FileSplit fileSplit = (FileSplit)split;
        Configuration conf = context.getConfiguration();
        Charset charset = Charset.forName(conf.get(XmlInputFormat$.MODULE$.ENCODING_KEY(), XmlOptions$.MODULE$.DEFAULT_CHARSET()));
        this.startTag_$eq(conf.get(XmlInputFormat$.MODULE$.START_TAG_KEY()));
        this.endTag_$eq(conf.get(XmlInputFormat$.MODULE$.END_TAG_KEY()));
        this.start_$eq(fileSplit.getStart());
        this.end_$eq(this.start() + fileSplit.getLength());
        Path path = fileSplit.getPath();
        FileSystem fs = path.getFileSystem(conf);
        FSDataInputStream fsin = fs.open(fileSplit.getPath());
        CountingInputStream in = null;
        CompressionCodec codec = new CompressionCodecFactory(conf).getCodec(path);
        if (codec != null) {
            this.decompressor_$eq(CodecPool.getDecompressor((CompressionCodec)codec));
            CompressionCodec compressionCodec = codec;
            if (compressionCodec instanceof SplittableCompressionCodec) {
                SplittableCompressionCodec splittableCompressionCodec = (SplittableCompressionCodec)compressionCodec;
                SplitCompressionInputStream cIn = splittableCompressionCodec.createInputStream((InputStream)fsin, this.decompressor(), this.start(), this.end(), SplittableCompressionCodec.READ_MODE.BYBLOCK);
                this.start_$eq(cIn.getAdjustedStart());
                this.end_$eq(cIn.getAdjustedEnd());
                in = cIn;
                this.filePosition_$eq((Seekable)cIn);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (compressionCodec == null) throw new MatchError((Object)compressionCodec);
                CompressionCodec compressionCodec2 = compressionCodec;
                if (this.start() != 0L) {
                    throw new IOException(new StringBuilder(33).append("Cannot seek in ").append(codec.getClass().getSimpleName()).append(" compressed stream").toString());
                }
                CompressionInputStream cIn = compressionCodec2.createInputStream((InputStream)fsin, this.decompressor());
                in = cIn;
                this.filePosition_$eq((Seekable)fsin);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            fsin.seek(this.start());
            this.countingIn_$eq(new CountingInputStream((InputStream)fsin));
            in = this.countingIn();
        }
        this.reader_$eq(new InputStreamReader((InputStream)in, charset));
        if (codec != null) return;
        Field sdField = this.reader().getClass().getDeclaredField("sd");
        sdField.setAccessible(true);
        Object sd = sdField.get(this.reader());
        Field readerLeftoverCharField = sd.getClass().getDeclaredField("haveLeftoverChar");
        readerLeftoverCharField.setAccessible(true);
        this.readerLeftoverCharFn_$eq((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)readerLeftoverCharField.get(sd)));
        Field bbField = sd.getClass().getDeclaredField("bb");
        bbField.setAccessible(true);
        this.readerByteBuffer_$eq((ByteBuffer)bbField.get(sd));
    }

    private long getFilePosition() {
        return this.filePosition() != null ? this.filePosition().getPos() : this.start() + this.countingIn().getByteCount() - (long)this.readerByteBuffer().remaining() - (long)(this.readerLeftoverCharFn().apply$mcZ$sp() ? 1 : 0);
    }

    public boolean nextKeyValue() {
        this.currentKey_$eq(new LongWritable());
        this.currentValue_$eq(new Text());
        return this.next(this.currentKey(), this.currentValue());
    }

    private boolean next(LongWritable key, Text value) {
        if (this.readUntilStartElement()) {
            boolean bl;
            try {
                this.buffer().append(this.currentStartTag());
                this.readUntilEndElement(this.currentStartTag().endsWith(">"));
                key.set(this.getFilePosition());
                value.set(this.buffer().toString());
                bl = true;
            }
            finally {
                this.buffer_$eq(new scala.collection.mutable.StringBuilder());
            }
            return bl;
        }
        return false;
    }

    private boolean readUntilStartElement() {
        this.currentStartTag_$eq(this.startTag());
        int i = 0;
        int cOrEOF;
        while ((cOrEOF = this.reader().read()) != -1 && (i != 0 || this.getFilePosition() <= this.end())) {
            char c = (char)cOrEOF;
            if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.startTag()), i)) {
                if (i >= this.startTag().length() - 1) {
                    return true;
                }
                ++i;
                continue;
            }
            if (i == this.startTag().length() - 1 && Character.isWhitespace(c)) {
                this.currentStartTag_$eq(new StringBuilder(0).append((String)new StringOps(Predef$.MODULE$.augmentString(this.startTag())).dropRight(1)).append(c).toString());
                return true;
            }
            i = 0;
        }
        return false;
    }

    private boolean readUntilEndElement(boolean startTagClosed) {
        boolean canSelfClose;
        int si = 0;
        int ei = 0;
        int depth = 0;
        int prevC = 0;
        boolean bl = canSelfClose = !startTagClosed;
        int cOrEOF;
        while ((cOrEOF = this.reader().read()) != -1) {
            char c = (char)cOrEOF;
            this.buffer().append(c);
            if (c == '>' && prevC != 47) {
                canSelfClose = false;
            }
            if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.startTag()), si)) {
                if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.endTag()), ei)) {
                    ++si;
                    ++ei;
                } else if (si >= this.startTag().length() - 1) {
                    si = 0;
                    ei = 0;
                    ++depth;
                } else {
                    ++si;
                    ei = 0;
                }
            } else if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.endTag()), ei)) {
                if (ei >= this.endTag().length() - 1) {
                    if (depth == 0) {
                        return true;
                    }
                    si = 0;
                    ei = 0;
                    --depth;
                } else {
                    si = 0;
                    ++ei;
                }
            } else if (c == '>' && prevC == 47 && canSelfClose) {
                if (depth == 0) {
                    return true;
                }
                si = 0;
                ei = 0;
                --depth;
            } else if (si == this.startTag().length() - 1 && Character.isWhitespace(c)) {
                si = 0;
                ei = 0;
                ++depth;
            } else {
                si = 0;
                ei = 0;
            }
            prevC = c;
        }
        return false;
    }

    public float getProgress() {
        return this.start() == this.end() ? 0.0f : package$.MODULE$.min(1.0f, (float)((double)(this.getFilePosition() - this.start()) / (double)(this.end() - this.start())));
    }

    public LongWritable getCurrentKey() {
        return this.currentKey();
    }

    public Text getCurrentValue() {
        return this.currentValue();
    }

    public void close() {
        try {
            if (this.reader() != null) {
                this.reader().close();
                this.reader_$eq(null);
            }
        }
        finally {
            if (this.decompressor() != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor());
                this.decompressor_$eq(null);
            }
        }
    }
}

