/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.java;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.extra.EquoBasedStepBuilder;
import dev.equo.solstice.p2.P2Model;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Properties;

public final class EclipseJdtFormatterStep {
    private static final String NAME = "eclipse jdt formatter";
    private static final Jvm.Support<String> JVM_SUPPORT = Jvm.support((String)"eclipse jdt formatter").add(11, (Object)"4.26").add(17, (Object)"4.29");

    private EclipseJdtFormatterStep() {
    }

    public static String defaultVersion() {
        return (String)JVM_SUPPORT.getRecommendedFormatterVersion();
    }

    public static EquoBasedStepBuilder createBuilder(Provisioner provisioner) {
        return new EquoBasedStepBuilder(NAME, provisioner, EclipseJdtFormatterStep.defaultVersion(), EclipseJdtFormatterStep::apply){

            @Override
            protected P2Model model(String version) {
                P2Model model = new P2Model();
                this.addPlatformRepo(model, version);
                model.getInstall().add("org.eclipse.jdt.core");
                return model;
            }

            @Override
            public void setVersion(String version) {
                if (version.endsWith(".0")) {
                    String newVersion = version.substring(0, version.length() - 2);
                    System.err.println("Recommend replacing '" + version + "' with '" + newVersion + "' for Eclipse JDT");
                    version = newVersion;
                }
                super.setVersion(version);
            }
        };
    }

    private static FormatterFunc apply(EquoBasedStepBuilder.State state) throws Exception {
        JVM_SUPPORT.assertFormatterSupported((Object)state.getSemanticVersion());
        Class<?> formatterClazz = state.getJarState().getClassLoader().loadClass("com.diffplug.spotless.extra.glue.jdt.EclipseJdtFormatterStepImpl");
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod("format", String.class, File.class);
        FormatterFunc.NeedsFile formatterFunc = (input, file) -> (String)method.invoke(formatter, input, file);
        return JVM_SUPPORT.suggestLaterVersionOnError((Object)state.getSemanticVersion(), (FormatterFunc)formatterFunc);
    }
}

