/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.python;

import com.diffplug.spotless.ForeignExe;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.ProcessRunner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class BlackStep {
    private final String version;
    @Nullable
    private final String pathToExe;

    public static String name() {
        return "black";
    }

    public static String defaultVersion() {
        return "22.3.0";
    }

    private BlackStep(String version, @Nullable String pathToExe) {
        this.version = version;
        this.pathToExe = pathToExe;
    }

    public static BlackStep withVersion(String version) {
        return new BlackStep(version, null);
    }

    public BlackStep withPathToExe(String pathToExe) {
        return new BlackStep(this.version, pathToExe);
    }

    public FormatterStep create() {
        return FormatterStep.createLazy(BlackStep.name(), this::createRoundtrip, rec$ -> ((RoundtripState)rec$).toEquality(), EqualityState::toFunc);
    }

    private RoundtripState createRoundtrip() {
        String trackingIssue = "\n  github issue to handle this better: https://github.com/diffplug/spotless/issues/674";
        ForeignExe exeAbsPath = ForeignExe.nameAndVersion("black", this.version).pathToExe(this.pathToExe).versionRegex(Pattern.compile("(?:black, version|black,|version) (\\S*)")).fixCantFind("Try running {@code pip install black=={version}}, or else tell Spotless where it is with {@code black().pathToExe('path/to/executable')}" + trackingIssue).fixWrongVersion("Try running {@code pip install --force-reinstall black=={version}}, or else specify {@code black('{versionFound}')} to Spotless" + trackingIssue);
        return new RoundtripState(this.version, exeAbsPath);
    }

    static class RoundtripState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String version;
        final ForeignExe exe;

        RoundtripState(String version, ForeignExe exe) {
            this.version = version;
            this.exe = exe;
        }

        private EqualityState toEquality() {
            return new EqualityState(this.version, this.exe);
        }
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    static class EqualityState
    implements Serializable {
        private static final long serialVersionUID = -1825662356883926318L;
        final String version;
        final transient ForeignExe exe;
        @Nullable
        private transient String[] args;

        EqualityState(String version, ForeignExe exeAbsPath) {
            this.version = version;
            this.exe = Objects.requireNonNull(exeAbsPath);
        }

        String format(ProcessRunner runner, String input) throws IOException, InterruptedException {
            if (this.args == null) {
                this.args = new String[]{this.exe.confirmVersionAndGetAbsolutePath(), "-"};
            }
            return runner.exec(input.getBytes(StandardCharsets.UTF_8), this.args).assertExitZero(StandardCharsets.UTF_8);
        }

        FormatterFunc.Closeable toFunc() {
            ProcessRunner runner = new ProcessRunner();
            return FormatterFunc.Closeable.of(runner, this::format);
        }
    }
}

