/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.ForeignExe;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.ProcessRunner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.generic.TestEnvVars;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdeaStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeaStep.class);
    public static final String NAME = "IDEA";
    public static final String IDEA_EXECUTABLE_DEFAULT = "idea";
    public static final String IDEA_CONFIG_PATH_PROPERTY = "idea.config.path";
    public static final String IDEA_SYSTEM_PATH_PROPERTY = "idea.system.path";
    @Nonnull
    private final IdeaStepBuilder builder;

    private IdeaStep(@Nonnull IdeaStepBuilder builder) {
        this.builder = builder;
    }

    public static IdeaStepBuilder newBuilder(@Nonnull File buildDir) {
        return new IdeaStepBuilder(Objects.requireNonNull(buildDir));
    }

    private static FormatterStep create(IdeaStepBuilder builder) {
        return new IdeaStep(builder).createFormatterStep();
    }

    private FormatterStep createFormatterStep() {
        return FormatterStep.createLazy(NAME, this::createState, rec$ -> ((State)rec$).toFunc());
    }

    private State createState() {
        return new State(Objects.requireNonNull(this.builder));
    }

    public static final class IdeaStepBuilder {
        private boolean useDefaults = true;
        @Nonnull
        private String binaryPath = "idea";
        @Nullable
        private String codeStyleSettingsPath;
        private final Map<String, String> ideaProperties = new HashMap<String, String>();
        @Nonnull
        private final File buildDir;

        private IdeaStepBuilder(@Nonnull File buildDir) {
            this.buildDir = Objects.requireNonNull(buildDir);
        }

        public IdeaStepBuilder setUseDefaults(boolean useDefaults) {
            this.useDefaults = useDefaults;
            return this;
        }

        public IdeaStepBuilder setBinaryPath(@Nonnull String binaryPath) {
            this.binaryPath = Objects.requireNonNull(binaryPath);
            return this;
        }

        public IdeaStepBuilder setCodeStyleSettingsPath(@Nullable String codeStyleSettingsPath) {
            this.codeStyleSettingsPath = codeStyleSettingsPath;
            return this;
        }

        public IdeaStepBuilder setIdeaProperties(@Nonnull Map<String, String> ideaProperties) {
            if (ideaProperties.containsKey(IdeaStep.IDEA_CONFIG_PATH_PROPERTY) || ideaProperties.containsKey(IdeaStep.IDEA_SYSTEM_PATH_PROPERTY)) {
                throw new IllegalArgumentException("Cannot override IDEA config or system path");
            }
            this.ideaProperties.putAll(ideaProperties);
            return this;
        }

        public FormatterStep build() {
            return IdeaStep.create(this);
        }

        public String toString() {
            return String.format("IdeaStepBuilder[useDefaults=%s, binaryPath=%s, codeStyleSettingsPath=%s, ideaProperties=%s, buildDir=%s]", this.useDefaults, this.binaryPath, this.codeStyleSettingsPath, this.ideaProperties, this.buildDir);
        }
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = -1426311255869303398L;
        private final File uniqueBuildFolder;
        private final String binaryPath;
        @Nullable
        private final String codeStyleSettingsPath;
        private final boolean withDefaults;
        private final TreeMap<String, String> ideaProperties;

        private State(@Nonnull IdeaStepBuilder builder) {
            LOGGER.debug("Creating {} state with configuration {}", (Object)IdeaStep.NAME, (Object)builder);
            this.uniqueBuildFolder = new File(builder.buildDir, UUID.randomUUID().toString());
            this.withDefaults = builder.useDefaults;
            this.codeStyleSettingsPath = builder.codeStyleSettingsPath;
            this.ideaProperties = new TreeMap<String, String>(builder.ideaProperties);
            this.binaryPath = State.resolveFullBinaryPathAndCheckVersion(builder.binaryPath);
        }

        private static String resolveFullBinaryPathAndCheckVersion(String binaryPath) {
            ForeignExe exe = ForeignExe.nameAndVersion(binaryPath, "IntelliJ IDEA").pathToExe(State.pathToExe(binaryPath)).versionRegex(Pattern.compile("(IntelliJ IDEA) .*")).fixCantFind("IDEA executable cannot be found on your machine, please install it and put idea binary to PATH, provide a valid path to the executable or report the problem").fixWrongVersion("Provided binary is not IDEA, please check it and fix the problem; or report the problem");
            try {
                return exe.confirmVersionAndGetAbsolutePath();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("binary cannot be found", e);
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("binary cannot be found, process was interrupted", e);
            }
        }

        @CheckForNull
        private static String pathToExe(String binaryPath) {
            String testEnvBinaryPath = TestEnvVars.read().get(String.format("%s.%s", IdeaStep.class.getName(), "binaryPath"));
            if (testEnvBinaryPath != null) {
                return testEnvBinaryPath;
            }
            if (State.isMacOs()) {
                return State.macOsFix(binaryPath);
            }
            if (new File(binaryPath).exists()) {
                return binaryPath;
            }
            return null;
        }

        private static String macOsFix(String binaryPath) {
            File binary = new File(binaryPath);
            if (!binary.exists() && !(binary = new File(binaryPath + ".app")).exists()) {
                return binaryPath;
            }
            if (binaryPath.endsWith(".app") || binary.isDirectory()) {
                binary = new File(binary, "Contents/MacOS/idea");
            }
            if (binary.isFile() && binary.canExecute()) {
                return binary.getPath();
            }
            return binaryPath;
        }

        private static boolean isMacOs() {
            return System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String format(IdeaStepFormatterCleanupResources ideaStepFormatterCleanupResources, String unix, File file) throws Exception {
            File tempFile = File.createTempFile("spotless", file.getName());
            try {
                Files.write(tempFile.toPath(), unix.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                List<String> params = this.getParams(tempFile);
                Map<String, String> env = this.createEnv();
                LOGGER.info("Launching IDEA formatter for orig file {} with params: {} and env: {}", new Object[]{file, params, env});
                ProcessRunner.Result result = ideaStepFormatterCleanupResources.runner.exec(null, env, null, params);
                LOGGER.debug("command finished with exit code: {}", (Object)result.exitCode());
                LOGGER.debug("command finished with stdout: {}", (Object)result.assertExitZero(StandardCharsets.UTF_8));
                String string = Files.readString(tempFile.toPath(), StandardCharsets.UTF_8);
                return string;
            }
            finally {
                Files.delete(tempFile.toPath());
            }
        }

        private Map<String, String> createEnv() {
            File ideaProps = this.createIdeaPropertiesFile();
            Map.Entry[] entryArray = new Map.Entry[1];
            entryArray[0] = Map.entry("IDEA_PROPERTIES", ThrowingEx.get(ideaProps::getCanonicalPath));
            Map<String, String> env = Map.ofEntries(entryArray);
            return env;
        }

        private File createIdeaPropertiesFile() {
            Path ideaProps = this.uniqueBuildFolder.toPath().resolve("idea.properties");
            if (Files.exists(ideaProps, new LinkOption[0])) {
                return ideaProps.toFile();
            }
            Path parent = ideaProps.getParent();
            if (parent == null) {
                throw new IllegalStateException(String.format("Parent directory for IDEA properties file %s cannot be null", ideaProps));
            }
            ThrowingEx.run(() -> Files.createDirectories(parent, new FileAttribute[0]));
            Path configPath = parent.resolve("config");
            Path systemPath = parent.resolve("system");
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.ideaProperties);
            properties.put(IdeaStep.IDEA_CONFIG_PATH_PROPERTY, ThrowingEx.get(configPath.toFile()::getCanonicalPath));
            properties.put(IdeaStep.IDEA_SYSTEM_PATH_PROPERTY, ThrowingEx.get(systemPath.toFile()::getCanonicalPath));
            LOGGER.debug("Creating IDEA properties file at {} with content: {}", (Object)ideaProps, (Object)properties);
            try (FileOutputStream out = new FileOutputStream(ideaProps.toFile());){
                properties.store(out, "Generated by spotless");
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create IDEA properties file", e);
            }
            return ideaProps.toFile();
        }

        private List<String> getParams(File file) {
            Stream.Builder<String> builder = Stream.builder();
            builder.add(this.binaryPath);
            builder.add("format");
            if (this.withDefaults) {
                builder.add("-allowDefaults");
            }
            if (this.codeStyleSettingsPath != null) {
                builder.add("-s");
                builder.add(this.codeStyleSettingsPath);
            }
            builder.add("-charset").add("UTF-8");
            builder.add(ThrowingEx.get(file::getCanonicalPath));
            return builder.build().collect(Collectors.toList());
        }

        private FormatterFunc.Closeable toFunc() {
            IdeaStepFormatterCleanupResources ideaStepFormatterCleanupResources = new IdeaStepFormatterCleanupResources(this.uniqueBuildFolder, new ProcessRunner());
            return FormatterFunc.Closeable.of(ideaStepFormatterCleanupResources, this::format);
        }
    }

    private static class IdeaStepFormatterCleanupResources
    implements AutoCloseable {
        @Nonnull
        private final File uniqueBuildFolder;
        @Nonnull
        private final ProcessRunner runner;

        public IdeaStepFormatterCleanupResources(@Nonnull File uniqueBuildFolder, @Nonnull ProcessRunner runner) {
            this.uniqueBuildFolder = uniqueBuildFolder;
            this.runner = runner;
        }

        @Override
        public void close() throws Exception {
            this.runner.close();
            if (this.uniqueBuildFolder.exists()) {
                try (Stream<Path> paths = Files.walk(this.uniqueBuildFolder.toPath(), new FileVisitOption[0]);){
                    paths.sorted((o1, o2) -> o2.compareTo((Path)o1)).forEach(path -> {
                        try {
                            Files.delete(path);
                        }
                        catch (IOException e) {
                            LOGGER.warn("Failed to delete file: {}", path, (Object)e);
                        }
                    });
                }
            }
        }
    }
}

