/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.message;

import com.edb.jms.message.EDBMessageImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;

public class EDBTextMessageImpl
extends EDBMessageImpl
implements TextMessage {
    static final long serialVersionUID = 1L;
    private String _text = null;

    public EDBTextMessageImpl() throws JMSException {
        this.setJMSType("TextMessage");
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(1L);
        out.writeObject(this._text);
    }

    @Override
    public final void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        super.readExternal(in);
        long version = in.readLong();
        if (version != 1L) {
            throw new IOException("Incorrect version enountered: " + version + ". This version = " + 1L);
        }
        this._text = (String)in.readObject();
    }

    public final void setText(String string) throws MessageNotWriteableException {
        this.checkWrite();
        this._text = string;
    }

    public final String getText() {
        return this._text;
    }

    @Override
    public final void clearBody() throws JMSException {
        super.clearBody();
        this._text = null;
    }

    public final String toString() {
        return this.getText();
    }
}

