/*
 * Decompiled with CFR 0.152.
 */
package com.edb.aq.operations;

import com.edb.aq.UDTType;
import com.edb.aq.operations.QueueTable;
import com.edb.aq.operations.UDTTypeReflection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Queue {
    private String queueName;
    private String queueTableName;
    private String comments;
    private Connection conn;

    public Queue(Connection conn, String queueName, String queueTableName, String comments) {
        this.conn = conn;
        this.queueName = queueName;
        this.queueTableName = queueTableName;
        this.comments = comments;
    }

    public boolean create() {
        try (CallableStatement callStmt = this.conn.prepareCall("{call DBMS_AQADM.CREATE_QUEUE(?,?,?,?,?,?,?,?,?)}");){
            callStmt.setString(1, this.queueName);
            callStmt.setString(2, this.queueTableName);
            callStmt.setInt(3, 0);
            callStmt.setInt(4, 5);
            callStmt.setInt(5, 0);
            callStmt.setInt(6, 0);
            callStmt.setBoolean(7, false);
            callStmt.setString(8, this.comments);
            callStmt.setBoolean(9, true);
            callStmt.execute();
            Logger.getLogger(QueueTable.class.getName()).log(Level.FINE, "Queue '" + this.queueName + "' created successfully.");
        }
        catch (SQLException ex) {
            Logger.getLogger(QueueTable.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    public boolean start() {
        try (CallableStatement callStmt = this.conn.prepareCall("{call DBMS_AQADM.START_QUEUE(?)}");){
            callStmt.setString(1, this.queueName);
            callStmt.execute();
            Logger.getLogger(QueueTable.class.getName()).log(Level.FINE, "Queue started successfully.");
        }
        catch (SQLException ex) {
            Logger.getLogger(QueueTable.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    public boolean enqueueMessage(UDTType udtType, String queueName, Connection conn) {
        try (CallableStatement callStmt = conn.prepareCall("{call DBMS_AQ.ENQUEUE(?,?,?,?,?)}");){
            callStmt.setString(1, queueName);
            Struct enqueueOptions = conn.createStruct("dbms_aq.enqueue_options_t", new Object[]{0, null, null, null, 0});
            callStmt.setObject(2, (Object)enqueueOptions);
            Struct messageProperties = conn.createStruct("dbms_aq.message_properties_t", new Object[]{1, 0, null, null, null, null, null, null, null, null, null, 0});
            callStmt.setObject(3, (Object)messageProperties);
            Object[] paramObjects = UDTTypeReflection.getParamValues(udtType);
            Struct mytype = conn.createStruct(udtType.getName(), paramObjects);
            callStmt.setObject(4, (Object)mytype);
            callStmt.registerOutParameter(5, -2);
            System.out.println(callStmt.toString());
            boolean result = callStmt.execute();
            Logger.getLogger(Queue.class.getName()).log(Level.FINE, "Message Queued Successfully.");
        }
        catch (SQLException ex) {
            Logger.getLogger(Queue.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    public Object dequeueMessage(Connection conn, String queueName, String typeName, int dequeue_mode) {
        Object message = null;
        try (CallableStatement callStmt = conn.prepareCall("{call DBMS_AQ.DEQUEUE(?,?,?,?::" + typeName + ",?)}");){
            callStmt.setString(1, queueName);
            Struct dequeueOptions = conn.createStruct("dbms_aq.dequeue_options_t", new Object[]{null, dequeue_mode, 1, 0, 1, null, null, null, null, 0});
            callStmt.setObject(2, (Object)dequeueOptions);
            callStmt.registerOutParameter(3, 2002, "dbms_aq.message_properties_t");
            callStmt.registerOutParameter(4, 2002, typeName);
            callStmt.registerOutParameter(5, -2);
            callStmt.execute();
            message = callStmt.getObject(4);
            System.out.println("Message DeQueued Successfully.");
        }
        catch (SQLException ex) {
            Logger.getLogger(Queue.class.getName()).log(Level.SEVERE, null, ex);
        }
        return message;
    }
}

