/*
 * Decompiled with CFR 0.152.
 */
package com.edb.aq.operations;

import com.edb.aq.UDTType;
import com.edb.aq.operations.MyType;
import com.edb.jms.common.MethodAnnotationComparator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UDTTypeReflection {
    public static void main(String[] args) throws Exception {
        MyType udtType = new MyType();
        String data = "{0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09}";
        udtType.setProject(data);
        udtType.setCode(123);
        udtType.setName("mytype");
        Object[] objVal = UDTTypeReflection.getParamValues(udtType);
        System.out.println("Before Main: " + objVal);
        System.out.println("From MAIN:");
        for (int i = 0; i < objVal.length; ++i) {
            String objVals = objVal[i].toString();
            System.out.println(objVals);
        }
    }

    public static Object[] getParamValues(UDTType udtType) {
        Object[] objects = null;
        try {
            Class<?> udt = Class.forName(udtType.getClass().getName());
            Method[] methods = udt.getDeclaredMethods();
            Method method = udt.getDeclaredMethod("getParamValues", new Class[0]);
            objects = (Object[])method.invoke((Object)udtType, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(UDTTypeReflection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return objects;
    }

    public static boolean hasUserDefinedClassReference(UDTType udtType) {
        boolean hasUserDefinedClazz = false;
        try {
            Field[] fields;
            Class<?> classToCheck = Class.forName(udtType.getClass().getName());
            for (Field field : fields = classToCheck.getDeclaredFields()) {
                Class<?> fieldType = field.getType();
                if (fieldType.isPrimitive() || fieldType.getName().startsWith("java.")) continue;
                hasUserDefinedClazz = true;
            }
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException ex) {
            Logger.getLogger(UDTTypeReflection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return hasUserDefinedClazz;
    }

    public static Set<Class<?>> extractUserDefinedClasses(Class<?> udtType) {
        HashSet userDefinedClasses = new HashSet();
        UDTTypeReflection.extractUserDefinedClasses(udtType, userDefinedClasses);
        return userDefinedClasses;
    }

    private static void extractUserDefinedClasses(Class<?> clazz, Set<Class<?>> userDefinedClasses) {
        Method[] methods;
        Field[] fields;
        if (clazz.getName().contains("java.")) {
            return;
        }
        if (!clazz.isPrimitive()) {
            userDefinedClasses.add(clazz);
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            UDTTypeReflection.extractUserDefinedClasses(field.getType(), userDefinedClasses);
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
                UDTTypeReflection.extractUserDefinedClasses(parameterType, userDefinedClasses);
            }
            UDTTypeReflection.extractUserDefinedClasses(method.getReturnType(), userDefinedClasses);
        }
    }

    public static ArrayList getSetterMethods(UDTType udtType) {
        ArrayList<Method> setterMethod = new ArrayList<Method>();
        try {
            Method[] methods;
            Class<?> udt = Class.forName(udtType.getClass().getName());
            for (Method method : methods = udt.getDeclaredMethods()) {
                if (!UDTTypeReflection.isSetter(method)) continue;
                setterMethod.add(method);
            }
            Collections.sort(setterMethod, new MethodAnnotationComparator());
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException ex) {
            Logger.getLogger(UDTTypeReflection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return setterMethod;
    }

    public static boolean isSetter(Method method) {
        if (!method.getName().startsWith("set")) {
            return false;
        }
        return method.getParameterTypes().length == 1;
    }
}

