/*
 * Decompiled with CFR 0.152.
 */
package com.edb.core.v3;

import com.edb.PGProperty;
import com.edb.core.ConnectionFactory;
import com.edb.core.PGStream;
import com.edb.core.QueryExecutor;
import com.edb.core.ServerVersion;
import com.edb.core.SetupQueryRunner;
import com.edb.core.SocketFactoryFactory;
import com.edb.core.Tuple;
import com.edb.core.Utils;
import com.edb.core.Version;
import com.edb.core.v3.AuthenticationPluginManager;
import com.edb.core.v3.QueryExecutorImpl;
import com.edb.gss.MakeGSS;
import com.edb.hostchooser.CandidateHost;
import com.edb.hostchooser.GlobalHostStatusTracker;
import com.edb.hostchooser.HostChooser;
import com.edb.hostchooser.HostChooserFactory;
import com.edb.hostchooser.HostRequirement;
import com.edb.hostchooser.HostStatus;
import com.edb.jdbc.GSSEncMode;
import com.edb.jdbc.SslMode;
import com.edb.jre7.sasl.ScramAuthenticator;
import com.edb.plugin.AuthenticationRequestType;
import com.edb.ssl.MakeSSL;
import com.edb.sspi.ISSPIClient;
import com.edb.util.GT;
import com.edb.util.HostSpec;
import com.edb.util.MD5Digest;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import com.edb.util.ServerErrorMessage;
import com.edb.util.internal.Nullness;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger(ConnectionFactoryImpl.class.getName());
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    private static final int AUTH_REQ_GSS = 7;
    private static final int AUTH_REQ_GSS_CONTINUE = 8;
    private static final int AUTH_REQ_SSPI = 9;
    private static final int AUTH_REQ_SASL = 10;
    private static final int AUTH_REQ_SASL_CONTINUE = 11;
    private static final int AUTH_REQ_SASL_FINAL = 12;
    private static final String IN_HOT_STANDBY = "in_hot_standby";

    private ISSPIClient createSSPI(PGStream pgStream, @Nullable String spnServiceClass, boolean enableNegotiate) {
        try {
            Class<?> c = Class.forName("com.edb.sspi.SSPIClient");
            return (ISSPIClient)c.getDeclaredConstructor(PGStream.class, String.class, Boolean.TYPE).newInstance(pgStream, spnServiceClass, enableNegotiate);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load com.edb.sspi.SSPIClient. Please check that SSPIClient is included in your pgjdbc distribution.", e);
        }
    }

    private PGStream tryConnect(Properties info, SocketFactory socketFactory, HostSpec hostSpec, SslMode sslMode, GSSEncMode gssEncMode) throws SQLException, IOException {
        int connectTimeout = PGProperty.CONNECT_TIMEOUT.getInt(info) * 1000;
        String user = PGProperty.USER.getOrDefault(info);
        String database = PGProperty.PG_DBNAME.getOrDefault(info);
        if (user == null) {
            throw new PSQLException(GT.tr("User cannot be null", new Object[0]), PSQLState.INVALID_NAME);
        }
        if (database == null) {
            throw new PSQLException(GT.tr("Database cannot be null", new Object[0]), PSQLState.INVALID_NAME);
        }
        PGStream newStream = new PGStream(socketFactory, hostSpec, connectTimeout);
        try {
            int sendBufferSize;
            int socketTimeout = PGProperty.SOCKET_TIMEOUT.getInt(info);
            if (socketTimeout > 0) {
                newStream.setNetworkTimeout(socketTimeout * 1000);
            }
            String maxResultBuffer = PGProperty.MAX_RESULT_BUFFER.getOrDefault(info);
            newStream.setMaxResultBuffer(maxResultBuffer);
            boolean requireTCPKeepAlive = PGProperty.TCP_KEEP_ALIVE.getBoolean(info);
            newStream.getSocket().setKeepAlive(requireTCPKeepAlive);
            boolean requireTCPNoDelay = PGProperty.TCP_NO_DELAY.getBoolean(info);
            newStream.getSocket().setTcpNoDelay(requireTCPNoDelay);
            int receiveBufferSize = PGProperty.RECEIVE_BUFFER_SIZE.getInt(info);
            if (receiveBufferSize > -1) {
                if (receiveBufferSize > 0) {
                    newStream.getSocket().setReceiveBufferSize(receiveBufferSize);
                } else {
                    LOGGER.log(Level.WARNING, "Ignore invalid value for receiveBufferSize: {0}", receiveBufferSize);
                }
            }
            if ((sendBufferSize = PGProperty.SEND_BUFFER_SIZE.getInt(info)) > -1) {
                if (sendBufferSize > 0) {
                    newStream.getSocket().setSendBufferSize(sendBufferSize);
                } else {
                    LOGGER.log(Level.WARNING, "Ignore invalid value for sendBufferSize: {0}", sendBufferSize);
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Receive Buffer Size is {0}", newStream.getSocket().getReceiveBufferSize());
                LOGGER.log(Level.FINE, "Send Buffer Size is {0}", newStream.getSocket().getSendBufferSize());
            }
            if (!(newStream = this.enableGSSEncrypted(newStream, gssEncMode, hostSpec.getHost(), info, connectTimeout)).isGssEncrypted()) {
                newStream = this.enableSSL(newStream, sslMode, info, connectTimeout);
            }
            if (socketTimeout > 0) {
                newStream.setNetworkTimeout(socketTimeout * 1000);
            }
            List<StartupParam> paramList = this.getParametersForStartup(user, database, info);
            this.sendStartupPacket(newStream, paramList);
            this.doAuthentication(newStream, hostSpec.getHost(), user, info);
            return newStream;
        }
        catch (Exception e) {
            this.closeStream(newStream);
            throw e;
        }
    }

    @Override
    public QueryExecutor openConnectionImpl(HostSpec[] hostSpecs, Properties info) throws SQLException {
        HostRequirement targetServerType;
        SslMode sslMode = SslMode.of(info);
        GSSEncMode gssEncMode = GSSEncMode.of(info);
        String targetServerTypeStr = Nullness.castNonNull(PGProperty.TARGET_SERVER_TYPE.getOrDefault(info));
        List<Object> syncSlaves = new ArrayList();
        HostSpec masterHostSpec = null;
        Object masterCandidate = null;
        ArrayList<HostSpec> previousHosts = new ArrayList<HostSpec>();
        Iterator previousHostIter = null;
        try {
            targetServerType = HostRequirement.getTargetServerType(targetServerTypeStr);
        }
        catch (IllegalArgumentException ex) {
            throw new PSQLException(GT.tr("Invalid targetServerType value: {0}", targetServerTypeStr), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        SocketFactory socketFactory = SocketFactoryFactory.getSocketFactory(info);
        HostChooser hostChooser = HostChooserFactory.createHostChooser(hostSpecs, targetServerType, info);
        Iterator<CandidateHost> hostIter = hostChooser.iterator();
        HashMap<HostSpec, HostStatus> knownStates = new HashMap<HostSpec, HostStatus>();
        while (hostIter.hasNext() || targetServerType == HostRequirement.preferSyncSecondary && (previousHostIter != null && previousHostIter.hasNext() || masterHostSpec != null)) {
            HostSpec hostSpec = null;
            CandidateHost candidateHost = null;
            if (hostIter.hasNext()) {
                candidateHost = hostIter.next();
                hostSpec = candidateHost.hostSpec;
            } else if (targetServerType == HostRequirement.preferSyncSecondary && masterHostSpec != null) {
                candidateHost = new CandidateHost(masterHostSpec, HostRequirement.preferSyncSecondary);
                hostSpec = masterHostSpec;
                if (previousHostIter != null && previousHostIter.hasNext()) {
                    hostSpec = (HostSpec)previousHostIter.next();
                    candidateHost = new CandidateHost(hostSpec, HostRequirement.preferSyncSecondary);
                }
            }
            LOGGER.log(Level.FINE, "Trying to establish a protocol version 3 connection to {0}", hostSpec);
            HostStatus knownStatus = (HostStatus)((Object)knownStates.get(Nullness.castNonNull(hostSpec)));
            Nullness.castNonNull(candidateHost);
            if (knownStatus != null && !candidateHost.targetServerType.allowConnectingTo(knownStatus)) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Known status of host {0} is {1}, and required status was {2}. Will try next host", new Object[]{hostSpec, knownStatus, candidateHost.targetServerType});
                continue;
            }
            PGStream newStream = null;
            try {
                HostStatus hostStatus;
                QueryExecutorImpl queryExecutor;
                block32: {
                    block33: {
                        try {
                            newStream = this.tryConnect(info, socketFactory, Nullness.castNonNull(hostSpec), sslMode, gssEncMode);
                        }
                        catch (SQLException e) {
                            Exception ex;
                            if (sslMode == SslMode.PREFER && PSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(e.getSQLState())) {
                                ex = null;
                                try {
                                    newStream = this.tryConnect(info, socketFactory, Nullness.castNonNull(hostSpec), SslMode.DISABLE, gssEncMode);
                                    LOGGER.log(Level.FINE, "Downgraded to non-encrypted connection for host {0}", hostSpec);
                                }
                                catch (IOException | SQLException ee) {
                                    ex = ee;
                                }
                                if (ex != null) {
                                    ConnectionFactoryImpl.log(Level.FINE, "sslMode==PREFER, however non-SSL connection failed as well", ex, new Object[0]);
                                    e.addSuppressed(ex);
                                    throw e;
                                }
                            }
                            if (sslMode == SslMode.ALLOW && PSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(e.getSQLState())) {
                                ex = null;
                                try {
                                    newStream = this.tryConnect(info, socketFactory, Nullness.castNonNull(hostSpec), SslMode.REQUIRE, gssEncMode);
                                    LOGGER.log(Level.FINE, "Upgraded to encrypted connection for host {0}", hostSpec);
                                }
                                catch (SQLException ee) {
                                    ex = ee;
                                }
                                catch (IOException ee) {
                                    ex = ee;
                                }
                                if (ex != null) {
                                    ConnectionFactoryImpl.log(Level.FINE, "sslMode==ALLOW, however SSL connection failed as well", ex, new Object[0]);
                                    e.addSuppressed(ex);
                                    throw e;
                                }
                            }
                            throw e;
                        }
                        int cancelSignalTimeout = PGProperty.CANCEL_SIGNAL_TIMEOUT.getInt(info) * 1000;
                        Nullness.castNonNull(newStream);
                        queryExecutor = new QueryExecutorImpl(newStream, cancelSignalTimeout, info);
                        queryExecutor.setEdbServer(this.isEDBServer(queryExecutor));
                        hostStatus = HostStatus.ConnectOK;
                        if (candidateHost.targetServerType != HostRequirement.any) {
                            HostStatus hostStatus2 = hostStatus = this.isPrimary(queryExecutor) ? HostStatus.Primary : HostStatus.Secondary;
                        }
                        if (candidateHost.targetServerType != HostRequirement.preferSyncSecondary) break block32;
                        String hostIPAddress = this.getServerIPAddress(queryExecutor);
                        LOGGER.log(Level.FINE, "********** Resolving host IP address:  {0} ", hostIPAddress);
                        if (masterHostSpec == null) break block33;
                        if (hostIPAddress == null || !syncSlaves.contains(hostIPAddress)) break block32;
                        LOGGER.log(Level.FINE, "********** host is a synchronous standby:  {0} ", hostSpec);
                        if (masterHostSpec.equals(hostSpec)) break block32;
                        hostStatus = HostStatus.SyncSecondary;
                        LOGGER.log(Level.FINE, "********** host is a synchronous standby:  {0} ", hostSpec);
                        break block32;
                    }
                    if (hostStatus == HostStatus.Primary) {
                        LOGGER.log(Level.FINE, "********** Found primary server:  {0} loading standbys...", hostSpec);
                        masterHostSpec = new HostSpec(hostSpec.getHost(), hostSpec.getPort());
                        syncSlaves = this.getSynchronousSlaves(queryExecutor);
                        if (!previousHosts.isEmpty() || hostIter.hasNext()) {
                            previousHostIter = previousHosts.iterator();
                            LOGGER.log(Level.FINE, "********** Closing  Primary server:  {0} ...", hostSpec);
                            queryExecutor.close();
                            continue;
                        }
                    } else {
                        LOGGER.log(Level.FINE, "********** Adding server to recheck after primary is found:  {0} ", hostSpec);
                        previousHosts.add(hostSpec);
                        LOGGER.log(Level.FINE, "********** Closing  secondary server:  {0} ...", hostSpec);
                        queryExecutor.close();
                        continue;
                    }
                }
                GlobalHostStatusTracker.reportHostStatus(hostSpec, hostStatus);
                knownStates.put(hostSpec, hostStatus);
                if (!candidateHost.targetServerType.allowConnectingTo(hostStatus)) {
                    queryExecutor.close();
                    if (hostIter.hasNext() || targetServerType == HostRequirement.preferSyncSecondary && (previousHostIter != null && previousHostIter.hasNext() || masterHostSpec != null)) continue;
                }
                this.runInitialQueries(queryExecutor, info);
                return queryExecutor;
            }
            catch (ConnectException cex) {
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext() || targetServerType == HostRequirement.preferSyncSecondary && (previousHostIter != null && previousHostIter.hasNext() || masterHostSpec != null)) {
                    ConnectionFactoryImpl.log(Level.FINE, "ConnectException occurred while connecting to {0}", cex, hostSpec);
                    continue;
                }
                throw new PSQLException(GT.tr("Connection to {0} refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections.", hostSpec), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
            }
            catch (IOException ioe) {
                this.closeStream(newStream);
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext() || targetServerType == HostRequirement.preferSyncSecondary && (previousHostIter != null && previousHostIter.hasNext() || masterHostSpec != null)) {
                    ConnectionFactoryImpl.log(Level.FINE, "IOException occurred while connecting to {0}", ioe, hostSpec);
                    continue;
                }
                throw new PSQLException(GT.tr("The connection attempt failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
            }
            catch (SQLException se) {
                this.closeStream(newStream);
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext() || targetServerType == HostRequirement.preferSyncSecondary && (previousHostIter != null && previousHostIter.hasNext() || masterHostSpec != null)) {
                    ConnectionFactoryImpl.log(Level.FINE, "SQLException occurred while connecting to {0}", se, hostSpec);
                    continue;
                }
                throw se;
            }
        }
        throw new PSQLException(GT.tr("Could not find a server with specified targetServerType: {0}", new Object[]{targetServerType}), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private List<StartupParam> getParametersForStartup(String user, String database, Properties info) {
        String options;
        String currentSchema;
        ArrayList<StartupParam> paramList = new ArrayList<StartupParam>();
        paramList.add(new StartupParam("user", user));
        paramList.add(new StartupParam("database", database));
        paramList.add(new StartupParam("client_encoding", "UTF8"));
        paramList.add(new StartupParam("DateStyle", "ISO"));
        paramList.add(new StartupParam("TimeZone", ConnectionFactoryImpl.createPostgresTimeZone()));
        Version assumeVersion = ServerVersion.from(PGProperty.ASSUME_MIN_SERVER_VERSION.getOrDefault(info));
        if (assumeVersion.getVersionNum() >= ServerVersion.v9_0.getVersionNum()) {
            paramList.add(new StartupParam("extra_float_digits", "3"));
            String appName = PGProperty.APPLICATION_NAME.getOrDefault(info);
            if (appName != null) {
                paramList.add(new StartupParam("application_name", appName));
            }
        } else {
            paramList.add(new StartupParam("extra_float_digits", "2"));
        }
        String replication = PGProperty.REPLICATION.getOrDefault(info);
        if (replication != null && assumeVersion.getVersionNum() >= ServerVersion.v9_4.getVersionNum()) {
            paramList.add(new StartupParam("replication", replication));
        }
        if ((currentSchema = PGProperty.CURRENT_SCHEMA.getOrDefault(info)) != null) {
            paramList.add(new StartupParam("search_path", currentSchema));
        }
        if ((options = PGProperty.OPTIONS.getOrDefault(info)) != null) {
            paramList.add(new StartupParam("options", options));
        }
        return paramList;
    }

    private static void log(Level level, String msg, Throwable thrown, Object ... params) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        LogRecord rec = new LogRecord(level, msg);
        rec.setLoggerName(LOGGER.getName());
        rec.setParameters(params);
        rec.setThrown(thrown);
        LOGGER.log(rec);
    }

    private static String createPostgresTimeZone() {
        String start;
        String tz = TimeZone.getDefault().getID();
        if (tz.length() <= 3 || !tz.startsWith("GMT")) {
            return tz;
        }
        char sign = tz.charAt(3);
        switch (sign) {
            case '+': {
                start = "GMT-";
                break;
            }
            case '-': {
                start = "GMT+";
                break;
            }
            default: {
                return tz;
            }
        }
        return start + tz.substring(4);
    }

    private PGStream enableGSSEncrypted(PGStream pgStream, GSSEncMode gssEncMode, String host, Properties info, int connectTimeout) throws IOException, PSQLException {
        if (gssEncMode == GSSEncMode.DISABLE) {
            return pgStream;
        }
        if (gssEncMode == GSSEncMode.ALLOW) {
            return pgStream;
        }
        String user = PGProperty.USER.getOrDefault(info);
        if (user == null) {
            throw new PSQLException("GSSAPI encryption required but was impossible user is null", PSQLState.CONNECTION_REJECTED);
        }
        LOGGER.log(Level.FINEST, " FE=> GSSENCRequest");
        int gssTimeout = PGProperty.SSL_RESPONSE_TIMEOUT.getInt(info);
        int currentTimeout = pgStream.getNetworkTimeout();
        if (currentTimeout > 0 && currentTimeout < gssTimeout) {
            gssTimeout = currentTimeout;
        }
        pgStream.setNetworkTimeout(gssTimeout);
        pgStream.sendInteger4(8);
        pgStream.sendInteger2(1234);
        pgStream.sendInteger2(5680);
        pgStream.flush();
        int beresp = pgStream.receiveChar();
        pgStream.setNetworkTimeout(currentTimeout);
        switch (beresp) {
            case 69: {
                LOGGER.log(Level.FINEST, " <=BE GSSEncrypted Error");
                if (gssEncMode.requireEncryption()) {
                    throw new PSQLException(GT.tr("The server does not support GSS Encoding.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                pgStream.close();
                return new PGStream(pgStream.getSocketFactory(), pgStream.getHostSpec(), connectTimeout);
            }
            case 78: {
                LOGGER.log(Level.FINEST, " <=BE GSSEncrypted Refused");
                if (gssEncMode.requireEncryption()) {
                    throw new PSQLException(GT.tr("The server does not support GSS Encryption.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                return pgStream;
            }
            case 71: {
                LOGGER.log(Level.FINEST, " <=BE GSSEncryptedOk");
                try {
                    AuthenticationPluginManager.withPassword(AuthenticationRequestType.GSS, info, password -> {
                        MakeGSS.authenticate(true, pgStream, host, user, password, PGProperty.JAAS_APPLICATION_NAME.getOrDefault(info), PGProperty.KERBEROS_SERVER_NAME.getOrDefault(info), false, PGProperty.JAAS_LOGIN.getBoolean(info), PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                        return Void.TYPE;
                    });
                    return pgStream;
                }
                catch (PSQLException ex) {
                    if (gssEncMode != GSSEncMode.PREFER) break;
                    return new PGStream(pgStream, connectTimeout);
                }
            }
        }
        throw new PSQLException(GT.tr("An error occurred while setting up the GSS Encoded connection.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
    }

    private PGStream enableSSL(PGStream pgStream, SslMode sslMode, Properties info, int connectTimeout) throws IOException, PSQLException {
        if (sslMode == SslMode.DISABLE) {
            return pgStream;
        }
        if (sslMode == SslMode.ALLOW) {
            return pgStream;
        }
        LOGGER.log(Level.FINEST, " FE=> SSLRequest");
        int sslTimeout = PGProperty.SSL_RESPONSE_TIMEOUT.getInt(info);
        int currentTimeout = pgStream.getNetworkTimeout();
        if (currentTimeout > 0 && currentTimeout < sslTimeout) {
            sslTimeout = currentTimeout;
        }
        pgStream.setNetworkTimeout(sslTimeout);
        pgStream.sendInteger4(8);
        pgStream.sendInteger2(1234);
        pgStream.sendInteger2(5679);
        pgStream.flush();
        int beresp = pgStream.receiveChar();
        pgStream.setNetworkTimeout(currentTimeout);
        switch (beresp) {
            case 69: {
                LOGGER.log(Level.FINEST, " <=BE SSLError");
                if (sslMode.requireEncryption()) {
                    throw new PSQLException(GT.tr("The server does not support SSL.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                return new PGStream(pgStream, connectTimeout);
            }
            case 78: {
                LOGGER.log(Level.FINEST, " <=BE SSLRefused");
                if (sslMode.requireEncryption()) {
                    throw new PSQLException(GT.tr("The server does not support SSL.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                return pgStream;
            }
            case 83: {
                LOGGER.log(Level.FINEST, " <=BE SSLOk");
                MakeSSL.convert(pgStream, info);
                return pgStream;
            }
        }
        throw new PSQLException(GT.tr("An error occurred while setting up the SSL connection.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
    }

    private void sendStartupPacket(PGStream pgStream, List<StartupParam> params) throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder details = new StringBuilder();
            for (int i = 0; i < params.size(); ++i) {
                if (i != 0) {
                    details.append(", ");
                }
                details.append(params.get(i).toString());
            }
            LOGGER.log(Level.FINEST, " FE=> StartupPacket({0})", details);
        }
        int length = 8;
        byte[][] encodedParams = new byte[params.size() * 2][];
        for (int i = 0; i < params.size(); ++i) {
            encodedParams[i * 2] = params.get(i).getEncodedKey();
            encodedParams[i * 2 + 1] = params.get(i).getEncodedValue();
            length += encodedParams[i * 2].length + 1 + encodedParams[i * 2 + 1].length + 1;
        }
        pgStream.sendInteger4(++length);
        pgStream.sendInteger2(3);
        pgStream.sendInteger2(0);
        for (byte[] encodedParam : encodedParams) {
            pgStream.send(encodedParam);
            pgStream.sendChar(0);
        }
        pgStream.sendChar(0);
        pgStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAuthentication(PGStream pgStream, String host, String user, Properties info) throws IOException, SQLException {
        block36: {
            ISSPIClient sspiClient = null;
            ScramAuthenticator scramAuthenticator = null;
            try {
                while (true) {
                    int beresp = pgStream.receiveChar();
                    block4 : switch (beresp) {
                        case 69: {
                            int elen = pgStream.receiveInteger4();
                            ServerErrorMessage errorMsg = new ServerErrorMessage(pgStream.receiveErrorString(elen - 4));
                            LOGGER.log(Level.FINEST, " <=BE ErrorMessage({0})", errorMsg);
                            throw new PSQLException(errorMsg, PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                        }
                        case 82: {
                            int msgLen = pgStream.receiveInteger4();
                            int areq = pgStream.receiveInteger4();
                            switch (areq) {
                                case 5: {
                                    byte[] md5Salt = pgStream.receive(4);
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.log(Level.FINEST, " <=BE AuthenticationReqMD5(salt={0})", Utils.toHexString(md5Salt));
                                    }
                                    byte[] digest = AuthenticationPluginManager.withEncodedPassword(AuthenticationRequestType.MD5_PASSWORD, info, encodedPassword -> MD5Digest.encode(user.getBytes(StandardCharsets.UTF_8), encodedPassword, md5Salt));
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.log(Level.FINEST, " FE=> Password(md5digest={0})", new String(digest, StandardCharsets.US_ASCII));
                                    }
                                    try {
                                        pgStream.sendChar(112);
                                        pgStream.sendInteger4(4 + digest.length + 1);
                                        pgStream.send(digest);
                                    }
                                    finally {
                                        Arrays.fill(digest, (byte)0);
                                    }
                                    pgStream.sendChar(0);
                                    pgStream.flush();
                                    break block4;
                                }
                                case 3: {
                                    LOGGER.log(Level.FINEST, "<=BE AuthenticationReqPassword");
                                    LOGGER.log(Level.FINEST, " FE=> Password(password=<not shown>)");
                                    AuthenticationPluginManager.withEncodedPassword(AuthenticationRequestType.CLEARTEXT_PASSWORD, info, encodedPassword -> {
                                        pgStream.sendChar(112);
                                        pgStream.sendInteger4(4 + ((byte[])encodedPassword).length + 1);
                                        pgStream.send((byte[])encodedPassword);
                                        return Void.TYPE;
                                    });
                                    pgStream.sendChar(0);
                                    pgStream.flush();
                                    break block4;
                                }
                                case 7: 
                                case 9: {
                                    String gsslib = PGProperty.GSS_LIB.getOrDefault(info);
                                    boolean usespnego = PGProperty.USE_SPNEGO.getBoolean(info);
                                    boolean useSSPI = false;
                                    if ("gssapi".equals(gsslib)) {
                                        LOGGER.log(Level.FINE, "Using JSSE GSSAPI, param gsslib=gssapi");
                                    } else if (areq == 7 && !"sspi".equals(gsslib)) {
                                        LOGGER.log(Level.FINE, "Using JSSE GSSAPI, gssapi requested by server and gsslib=sspi not forced");
                                    } else {
                                        sspiClient = this.createSSPI(pgStream, PGProperty.SSPI_SERVICE_CLASS.getOrDefault(info), areq == 9 || areq == 7 && usespnego);
                                        useSSPI = sspiClient.isSSPISupported();
                                        LOGGER.log(Level.FINE, "SSPI support detected: {0}", useSSPI);
                                        if (!useSSPI) {
                                            sspiClient = null;
                                            if ("sspi".equals(gsslib)) {
                                                throw new PSQLException("SSPI forced with gsslib=sspi, but SSPI not available; set loglevel=2 for details", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                                            }
                                        }
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.log(Level.FINE, "Using SSPI: {0}, gsslib={1} and SSPI support detected", new Object[]{useSSPI, gsslib});
                                        }
                                    }
                                    if (useSSPI) {
                                        Nullness.castNonNull(sspiClient).startSSPI();
                                        break block4;
                                    }
                                    AuthenticationPluginManager.withPassword(AuthenticationRequestType.GSS, info, password -> {
                                        MakeGSS.authenticate(false, pgStream, host, user, password, PGProperty.JAAS_APPLICATION_NAME.getOrDefault(info), PGProperty.KERBEROS_SERVER_NAME.getOrDefault(info), usespnego, PGProperty.JAAS_LOGIN.getBoolean(info), PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                                        return Void.TYPE;
                                    });
                                    break block4;
                                }
                                case 8: {
                                    Nullness.castNonNull(sspiClient).continueSSPI(msgLen - 8);
                                    break block4;
                                }
                                case 10: {
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationSASL");
                                    scramAuthenticator = AuthenticationPluginManager.withPassword(AuthenticationRequestType.SASL, info, password -> {
                                        if (password == null) {
                                            throw new PSQLException(GT.tr("The server requested SCRAM-based authentication, but no password was provided.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                                        }
                                        if (((char[])password).length == 0) {
                                            throw new PSQLException(GT.tr("The server requested SCRAM-based authentication, but the password is an empty string.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                                        }
                                        return new ScramAuthenticator(user, String.valueOf(password), pgStream);
                                    });
                                    scramAuthenticator.processServerMechanismsAndInit();
                                    scramAuthenticator.sendScramClientFirstMessage();
                                    break block4;
                                }
                                case 11: {
                                    ((ScramAuthenticator)Nullness.castNonNull(scramAuthenticator)).processServerFirstMessage(msgLen - 4 - 4);
                                    break block4;
                                }
                                case 12: {
                                    ((ScramAuthenticator)Nullness.castNonNull(scramAuthenticator)).verifyServerSignature(msgLen - 4 - 4);
                                    break block4;
                                }
                                case 0: {
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationOk");
                                    break block36;
                                }
                                default: {
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationReq (unsupported type {0})", areq);
                                    throw new PSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", areq), PSQLState.CONNECTION_REJECTED);
                                }
                            }
                        }
                        default: {
                            throw new PSQLException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
                        }
                    }
                }
            }
            finally {
                if (sspiClient != null) {
                    try {
                        sspiClient.dispose();
                    }
                    catch (RuntimeException ex) {
                        LOGGER.log(Level.FINE, "Unexpected error during SSPI context disposal", ex);
                    }
                }
            }
        }
    }

    private void runInitialQueries(QueryExecutor queryExecutor, Properties info) throws SQLException {
        String appName;
        String assumeMinServerVersion = PGProperty.ASSUME_MIN_SERVER_VERSION.getOrDefault(info);
        if (Utils.parseServerVersionStr(assumeMinServerVersion) >= ServerVersion.v9_0.getVersionNum()) {
            return;
        }
        int dbVersion = queryExecutor.getServerVersionNum();
        if (PGProperty.GROUP_STARTUP_PARAMETERS.getBoolean(info) && dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            SetupQueryRunner.run(queryExecutor, "BEGIN", false);
        }
        if (dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            SetupQueryRunner.run(queryExecutor, "SET extra_float_digits = 3", false);
        }
        if ((appName = PGProperty.APPLICATION_NAME.getOrDefault(info)) != null && dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            StringBuilder sql = new StringBuilder();
            sql.append("SET application_name = '");
            Utils.escapeLiteral(sql, appName, queryExecutor.getStandardConformingStrings());
            sql.append("'");
            SetupQueryRunner.run(queryExecutor, sql.toString(), false);
        }
        if (PGProperty.GROUP_STARTUP_PARAMETERS.getBoolean(info) && dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            SetupQueryRunner.run(queryExecutor, "COMMIT", false);
        }
    }

    private boolean isPrimary(QueryExecutor queryExecutor) throws SQLException, IOException {
        String inHotStandby = queryExecutor.getParameterStatus(IN_HOT_STANDBY);
        if ("on".equalsIgnoreCase(inHotStandby)) {
            return false;
        }
        Tuple results = SetupQueryRunner.run(queryExecutor, "show transaction_read_only", true);
        Tuple nonNullResults = Nullness.castNonNull(results);
        String queriedTransactionReadonly = queryExecutor.getEncoding().decode(Nullness.castNonNull(nonNullResults.get(0)));
        return "off".equalsIgnoreCase(queriedTransactionReadonly);
    }

    private @Nullable String getServerIPAddress(QueryExecutor queryExecutor) throws SQLException, IOException {
        Tuple results = SetupQueryRunner.run(queryExecutor, "select inet_server_addr()", true);
        if (results != null && results.get(0) != null) {
            String value = queryExecutor.getEncoding().decode(Nullness.castNonNull(results.get(0)));
            return value;
        }
        return null;
    }

    private List<String> getSynchronousSlaves(QueryExecutor queryExecutor) throws SQLException, IOException {
        ArrayList<String> synchronousSlaves = new ArrayList<String>();
        List<Tuple> results = SetupQueryRunner.runwithResults(queryExecutor, "select host(client_addr) from pg_stat_replication where sync_state='sync'");
        if (results != null) {
            for (int i = 0; i < results.size(); ++i) {
                String slave;
                if (results.get(i) == null || results.get(i).get(0) == null || (slave = queryExecutor.getEncoding().decode(Nullness.castNonNull(results.get(i).get(0)))) == null) continue;
                synchronousSlaves.add(slave);
            }
        }
        return synchronousSlaves;
    }

    private boolean isEDBServer(QueryExecutor queryExecutor) throws SQLException, IOException {
        Tuple results = SetupQueryRunner.run(queryExecutor, "select version()", true);
        if (results != null && results.get(0) != null) {
            String value = queryExecutor.getEncoding().decode(Nullness.castNonNull(results.get(0)));
            return value.contains("EnterpriseDB");
        }
        return false;
    }

    private static class StartupParam {
        private final String key;
        private final String value;

        StartupParam(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public byte[] getEncodedKey() {
            return this.key.getBytes(StandardCharsets.UTF_8);
        }

        public byte[] getEncodedValue() {
            return this.value.getBytes(StandardCharsets.UTF_8);
        }
    }
}

