/*
 * Decompiled with CFR 0.152.
 */
package com.edb.core.v3;

import com.edb.core.PGStream;
import com.edb.core.ParameterList;
import com.edb.core.Utils;
import com.edb.core.v3.TypeTransferModeRegistry;
import com.edb.core.v3.V3ParameterList;
import com.edb.geometric.PGbox;
import com.edb.geometric.PGpoint;
import com.edb.jdbc.UUIDArrayAssistant;
import com.edb.jdbc2.Struct;
import com.edb.util.ByteConverter;
import com.edb.util.ByteStreamWriter;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import com.edb.util.StreamWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Arrays;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimpleParameterList
implements V3ParameterList {
    private static final byte IN = 1;
    private static final byte OUT = 2;
    private static final byte INOUT = 3;
    private static final byte TEXT = 0;
    private static final byte BINARY = 4;
    private static final int PARAM_INDEX_LIMIT = Short.MAX_VALUE;
    boolean isCallable = false;
    private int return_type = -1;
    private int[] outParameterTypes;
    private String[] outParameterTypeNames;
    private @Nullable String returnTypeName;
    private int pos = 0;
    private boolean outParamBeforeFunc = false;
    private final @Nullable Object[] paramValues;
    private final int[] paramTypes;
    private final byte[] flags;
    private final byte[] @Nullable [] encoded;
    private final @Nullable TypeTransferModeRegistry transferModeRegistry;
    private static final Object NULL_OBJECT = new Object();

    SimpleParameterList(int paramCount, @Nullable TypeTransferModeRegistry transferModeRegistry) {
        this.paramValues = new Object[paramCount];
        this.paramTypes = new int[paramCount];
        this.encoded = new byte[paramCount][];
        this.flags = new byte[paramCount];
        this.transferModeRegistry = transferModeRegistry;
        this.outParameterTypeNames = new String[paramCount];
        this.outParameterTypes = new int[paramCount];
    }

    @Override
    public void registerOutParameter(int index, int oid) throws SQLException {
        if (this.outParamBeforeFunc) {
            if (index == 1) {
                this.return_type = oid;
                return;
            }
            --index;
        }
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", index, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        int n = index - 1;
        this.flags[n] = (byte)(this.flags[n] | 2);
        if (oid == 1560) {
            oid = 16;
        }
        this.outParameterTypes[index - 1] = oid;
        this.paramTypes[index - 1] = oid;
    }

    private void bind(int index, Object value, int oid, byte binary) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", index, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.encoded[--index] = null;
        this.paramValues[index] = value;
        this.flags[index] = (byte)(this.direction(index) | 1 | binary);
        if (oid == 0 && this.paramTypes[index] != 0 && value == NULL_OBJECT) {
            return;
        }
        this.paramTypes[index] = oid;
        this.pos = index + 1;
    }

    @Override
    public @NonNegative int getParameterCount() {
        return this.paramValues.length;
    }

    @Override
    public @NonNegative int getOutParameterCount() {
        int count = 0;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if ((this.direction(i) & 2) != 2) continue;
            ++count;
        }
        if (this.outParamBeforeFunc) {
            ++count;
        }
        return count;
    }

    @Override
    public @NonNegative int getInParameterCount() {
        int count = 0;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) == 2) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void setIntParameter(@Positive int index, int value) throws SQLException {
        byte[] data = new byte[4];
        ByteConverter.int4(data, 0, value);
        this.bind(index, data, 23, (byte)4);
    }

    @Override
    public void setLiteralParameter(@Positive int index, String value, int oid) throws SQLException {
        this.bind(index, value, oid, (byte)0);
    }

    @Override
    public void setObjectParameter(int index, Object o, int oid) throws SQLException {
        this.bind(index, o, oid, (byte)0);
    }

    @Override
    public void setStringParameter(@Positive int index, String value, int oid) throws SQLException {
        this.bind(index, value, oid, (byte)0);
    }

    @Override
    public void setBinaryParameter(@Positive int index, byte[] value, int oid) throws SQLException {
        this.bind(index, value, oid, (byte)4);
    }

    @Override
    public void setBytea(@Positive int index, byte[] data, int offset, @NonNegative int length) throws SQLException {
        this.bind(index, new StreamWrapper(data, offset, length), 17, (byte)4);
    }

    @Override
    public void setBytea(@Positive int index, InputStream stream, @NonNegative int length) throws SQLException {
        this.bind(index, new StreamWrapper(stream, length), 17, (byte)4);
    }

    @Override
    public void setBytea(@Positive int index, InputStream stream) throws SQLException {
        this.bind(index, new StreamWrapper(stream), 17, (byte)4);
    }

    @Override
    public void setBytea(@Positive int index, ByteStreamWriter writer) throws SQLException {
        this.bind(index, writer, 17, (byte)4);
    }

    @Override
    public void setText(@Positive int index, InputStream stream) throws SQLException {
        this.bind(index, new StreamWrapper(stream), 25, (byte)0);
    }

    @Override
    public void setNull(@Positive int index, int oid) throws SQLException {
        int binaryTransfer = 0;
        if (this.transferModeRegistry != null && this.transferModeRegistry.useBinaryForReceive(oid)) {
            binaryTransfer = 4;
        }
        this.bind(index, NULL_OBJECT, oid, (byte)binaryTransfer);
    }

    private static String quoteAndCast(String text, @Nullable String type, boolean standardConformingStrings) {
        StringBuilder sb = new StringBuilder((text.length() + 10) / 10 * 11);
        sb.append("('");
        try {
            Utils.escapeLiteral(sb, text, standardConformingStrings);
        }
        catch (SQLException e) {
            sb.append('\u0000');
        }
        sb.append("'");
        if (type != null) {
            sb.append("::");
            sb.append(type);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String toString(@Positive int index, boolean standardConformingStrings) {
        String type;
        String textValue;
        block37: {
            Object paramValue;
            block36: {
                if ((paramValue = this.paramValues[--index]) == null) {
                    return "?";
                }
                if (paramValue == NULL_OBJECT) {
                    return "(NULL)";
                }
                if ((this.flags[index] & 4) != 4) break block36;
                switch (this.paramTypes[index]) {
                    case 21: {
                        short s = ByteConverter.int2((byte[])paramValue, 0);
                        textValue = Short.toString(s);
                        type = "int2";
                        break block37;
                    }
                    case 23: {
                        int i = ByteConverter.int4((byte[])paramValue, 0);
                        textValue = Integer.toString(i);
                        type = "int4";
                        break block37;
                    }
                    case 20: {
                        long l = ByteConverter.int8((byte[])paramValue, 0);
                        textValue = Long.toString(l);
                        type = "int8";
                        break block37;
                    }
                    case 700: {
                        float f = ByteConverter.float4((byte[])paramValue, 0);
                        if (Float.isNaN(f)) {
                            return "('NaN'::real)";
                        }
                        textValue = Float.toString(f);
                        type = "real";
                        break block37;
                    }
                    case 701: {
                        double d = ByteConverter.float8((byte[])paramValue, 0);
                        if (Double.isNaN(d)) {
                            return "('NaN'::double precision)";
                        }
                        textValue = Double.toString(d);
                        type = "double precision";
                        break block37;
                    }
                    case 1700: {
                        Number n = ByteConverter.numeric((byte[])paramValue);
                        if (n instanceof Double) {
                            assert (((Double)n).isNaN());
                            return "('NaN'::numeric)";
                        }
                        textValue = n.toString();
                        type = "numeric";
                        break block37;
                    }
                    case 2950: {
                        textValue = new UUIDArrayAssistant().buildElement((byte[])paramValue, 0, 16).toString();
                        type = "uuid";
                        break block37;
                    }
                    case 600: {
                        PGpoint pgPoint = new PGpoint();
                        pgPoint.setByteValue((byte[])paramValue, 0);
                        textValue = pgPoint.toString();
                        type = "point";
                        break block37;
                    }
                    case 603: {
                        PGbox pgBox = new PGbox();
                        pgBox.setByteValue((byte[])paramValue, 0);
                        textValue = pgBox.toString();
                        type = "box";
                        break block37;
                    }
                    default: {
                        return "?";
                    }
                }
            }
            if (paramValue instanceof Struct) {
                return ((java.sql.Struct)this.paramValues[index]).toString();
            }
            textValue = paramValue.toString();
            switch (this.paramTypes[index]) {
                case 21: {
                    type = "int2";
                    break;
                }
                case 23: {
                    type = "int4";
                    break;
                }
                case 20: {
                    type = "int8";
                    break;
                }
                case 700: {
                    type = "real";
                    break;
                }
                case 701: {
                    type = "double precision";
                    break;
                }
                case 1114: {
                    type = "timestamp";
                    break;
                }
                case 1184: {
                    type = "timestamp with time zone";
                    break;
                }
                case 1083: {
                    type = "time";
                    break;
                }
                case 1266: {
                    type = "time with time zone";
                    break;
                }
                case 1082: {
                    type = "date";
                    break;
                }
                case 1186: {
                    type = "interval";
                    break;
                }
                case 1700: {
                    type = "numeric";
                    break;
                }
                case 2950: {
                    type = "uuid";
                    break;
                }
                case 16: {
                    type = "boolean";
                    break;
                }
                case 603: {
                    type = "box";
                    break;
                }
                case 600: {
                    type = "point";
                    break;
                }
                default: {
                    type = null;
                }
            }
        }
        return SimpleParameterList.quoteAndCast(textValue, type, standardConformingStrings);
    }

    @Override
    public void checkAllParametersSet() throws SQLException {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) == 2 || this.paramValues[i] != null) continue;
            throw new PSQLException(GT.tr("No value specified for parameter {0}.", i + 1), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public void convertFunctionOutParameters() {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) != 2) continue;
            this.paramTypes[i] = 2278;
            this.paramValues[i] = NULL_OBJECT;
        }
    }

    private static void streamBytea(PGStream pgStream, StreamWrapper wrapper) throws IOException {
        byte[] rawData = wrapper.getBytes();
        if (rawData != null) {
            pgStream.send(rawData, wrapper.getOffset(), wrapper.getLength());
            return;
        }
        pgStream.sendStream(wrapper.getStream(), wrapper.getLength());
    }

    private static void streamBytea(PGStream pgStream, ByteStreamWriter writer) throws IOException {
        pgStream.send(writer);
    }

    @Override
    public int[] getTypeOIDs() {
        return this.paramTypes;
    }

    int getTypeOID(@Positive int index) {
        return this.paramTypes[index - 1];
    }

    boolean hasUnresolvedTypes() {
        for (int paramType : this.paramTypes) {
            if (paramType != 0) continue;
            return true;
        }
        return false;
    }

    void setResolvedType(@Positive int index, int oid) {
        if (this.paramTypes[index - 1] == 0) {
            this.paramTypes[index - 1] = oid;
        } else if (this.paramTypes[index - 1] != oid) {
            throw new IllegalArgumentException("Can't change resolved type for param: " + index + " from " + this.paramTypes[index - 1] + " to " + oid);
        }
    }

    boolean isNull(@Positive int index) {
        return this.paramValues[index - 1] == NULL_OBJECT || this.paramValues[index - 1] == null;
    }

    boolean isBinary(@Positive int index) {
        return (this.flags[index - 1] & 4) != 0;
    }

    private byte direction(@Positive int index) {
        return (byte)(this.flags[index] & 3);
    }

    int getV3Length(@Positive int index) {
        if (this.paramValues[--index] == NULL_OBJECT || this.paramValues[index] == null) {
            throw new IllegalArgumentException("can't getV3Length() on a null parameter");
        }
        if (this.paramValues[index] instanceof byte[]) {
            return ((byte[])this.paramValues[index]).length;
        }
        if (this.paramValues[index] instanceof java.sql.Struct) {
            return this.toString(index + 1, false).getBytes(StandardCharsets.UTF_8).length;
        }
        if (this.paramValues[index] instanceof StreamWrapper) {
            return ((StreamWrapper)this.paramValues[index]).getLength();
        }
        if (this.paramValues[index] instanceof ByteStreamWriter) {
            return ((ByteStreamWriter)this.paramValues[index]).getLength();
        }
        if (this.encoded[index] == null) {
            this.encoded[index] = this.paramValues[index].toString().getBytes(StandardCharsets.UTF_8);
        }
        return this.encoded[index].length;
    }

    void writeV3Value(@Positive int index, PGStream pgStream) throws IOException {
        if (this.paramValues[--index] == NULL_OBJECT || this.paramValues[index] == null) {
            throw new IllegalArgumentException("can't writeV3Value() on a null parameter");
        }
        if (this.paramValues[index] instanceof byte[]) {
            pgStream.send((byte[])this.paramValues[index]);
            return;
        }
        if (this.paramValues[index] instanceof java.sql.Struct) {
            pgStream.send(this.toString(index + 1, false).getBytes(StandardCharsets.UTF_8));
            return;
        }
        if (this.paramValues[index] instanceof StreamWrapper) {
            SimpleParameterList.streamBytea(pgStream, (StreamWrapper)this.paramValues[index]);
            return;
        }
        if (this.paramValues[index] instanceof ByteStreamWriter) {
            SimpleParameterList.streamBytea(pgStream, (ByteStreamWriter)this.paramValues[index]);
            return;
        }
        if (this.encoded[index] == null) {
            this.encoded[index] = ((String)this.paramValues[index]).getBytes(StandardCharsets.UTF_8);
        }
        pgStream.send(this.encoded[index]);
    }

    @Override
    public ParameterList copy() {
        SimpleParameterList newCopy = new SimpleParameterList(this.paramValues.length, this.transferModeRegistry);
        System.arraycopy(this.paramValues, 0, newCopy.paramValues, 0, this.paramValues.length);
        System.arraycopy(this.paramTypes, 0, newCopy.paramTypes, 0, this.paramTypes.length);
        System.arraycopy(this.flags, 0, newCopy.flags, 0, this.flags.length);
        newCopy.pos = this.pos;
        return newCopy;
    }

    @Override
    public void clear() {
        Arrays.fill(this.paramValues, null);
        Arrays.fill(this.paramTypes, 0);
        Arrays.fill((Object[])this.encoded, null);
        Arrays.fill(this.flags, (byte)0);
        this.pos = 0;
    }

    @Override
    public SimpleParameterList @Nullable [] getSubparams() {
        return null;
    }

    public int getReturnType() {
        return this.return_type;
    }

    public void setReturnType(int type) {
        this.return_type = type;
    }

    @Override
    public @Nullable Object[] getValues() {
        return this.paramValues;
    }

    @Override
    public int[] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public byte[] getFlags() {
        return this.flags;
    }

    @Override
    public byte[] @Nullable [] getEncoding() {
        return this.encoded;
    }

    @Override
    public void appendAll(ParameterList list) throws SQLException {
        if (list instanceof SimpleParameterList) {
            SimpleParameterList spl = (SimpleParameterList)list;
            int inParamCount = spl.getInParameterCount();
            if (this.pos + inParamCount > this.paramValues.length) {
                throw new PSQLException(GT.tr("Added parameters index out of range: {0}, number of columns: {1}.", this.pos + inParamCount, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
            }
            System.arraycopy(spl.getValues(), 0, this.paramValues, this.pos, inParamCount);
            System.arraycopy(spl.getParamTypes(), 0, this.paramTypes, this.pos, inParamCount);
            System.arraycopy(spl.getFlags(), 0, this.flags, this.pos, inParamCount);
            System.arraycopy(spl.getEncoding(), 0, this.encoded, this.pos, inParamCount);
            this.pos += inParamCount;
        }
    }

    public String toString() {
        StringBuilder ts = new StringBuilder("<[");
        if (this.paramValues.length > 0) {
            ts.append(this.toString(1, true));
            for (int c = 2; c <= this.paramValues.length; ++c) {
                ts.append(" ,").append(this.toString(c, true));
            }
        }
        ts.append("]>");
        return ts.toString();
    }

    public void setIsCallable(boolean isCallable) {
        this.isCallable = isCallable;
    }

    public int getParamDirection(int index) throws SQLException {
        this.checkIndex(index);
        return this.direction(index - 1);
    }

    private void checkIndex(int index) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Integer(index), new Integer(this.paramValues.length)), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public void setFunctionReturns(boolean funcReturns) {
        this.outParamBeforeFunc = funcReturns;
    }

    public void setOutParameterTypeName(int index, String typeName) {
        this.outParameterTypeNames[--index] = typeName;
    }

    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    public void setReturnTypeName(String typeName) {
        this.returnTypeName = typeName;
    }

    public String getOutParameterTypeName(int index) {
        return this.outParameterTypeNames[index - 1];
    }
}

