/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jdbc;

import com.edb.core.BaseConnection;
import com.edb.jdbc.AbstractBlobClob;
import com.edb.jdbc.ResourceLock;
import com.edb.largeobject.LargeObject;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class PgBlob
extends AbstractBlobClob
implements Blob {
    public PgBlob(BaseConnection conn, long oid) throws SQLException {
        super(conn, oid);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        try (ResourceLock ignore = this.lock.obtain();){
            this.checkFreed();
            LargeObject subLO = this.getLo(false).copy();
            this.addSubLO(subLO);
            if (pos > Integer.MAX_VALUE) {
                subLO.seek64(pos - 1L, 0);
            } else {
                subLO.seek((int)pos - 1, 0);
            }
            InputStream inputStream = subLO.getInputStream(length);
            return inputStream;
        }
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        try (ResourceLock ignore = this.lock.obtain();){
            this.assertPosition(pos);
            this.getLo(true).seek((int)(pos - 1L));
            this.getLo(true).write(bytes, offset, len);
            int n = len;
            return n;
        }
    }
}

