/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.client;

import com.edb.jms.message.EDBDestinationImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.Destination;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public abstract class EDBJmsDestination
extends EDBDestinationImpl
implements Destination,
Externalizable,
Referenceable {
    static final String TEMP_QUEUE_PREFIX = "tempqueue:";
    static final String TEMP_TOPIC_PREFIX = "temptopic:";
    static final long serialVersionUID = 1L;
    private boolean persistent_ = false;

    public EDBJmsDestination() {
    }

    protected EDBJmsDestination(String name) {
        super(name);
    }

    public static boolean isTemporaryDestination(EDBDestinationImpl destination) {
        boolean result = destination.getDestination().startsWith(TEMP_QUEUE_PREFIX) || destination.getDestination().startsWith(TEMP_TOPIC_PREFIX);
        return result;
    }

    @Override
    public Reference getReference() throws NamingException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getName() {
        return this.getDestination();
    }

    public boolean getPersistent() {
        return this.persistent_;
    }

    public void setPersistent(boolean flag) {
        this.persistent_ = flag;
    }

    @Override
    public String toString() {
        return this.getDestination() + "-" + this.persistent_;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeLong(1L);
        stream.writeBoolean(this.persistent_);
        super.writeExternal(stream);
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version != 1L) {
            throw new IOException("JmsDestination with version " + version + " is not supported.");
        }
        this.persistent_ = stream.readBoolean();
        super.readExternal(stream);
    }

    public boolean isTemporaryDestination() {
        boolean result = this.getDestination().startsWith(TEMP_QUEUE_PREFIX) || this.getDestination().startsWith(TEMP_TOPIC_PREFIX);
        return result;
    }
}

