/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.client;

import com.edb.aq.UDTType;
import com.edb.jms.client.EDBJmsDestination;
import com.edb.jms.client.EDBQueueTable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class EDBJmsQueue
extends EDBJmsDestination
implements Queue,
Externalizable {
    static final long serialVersionUID = 1L;
    private EDBQueueTable edbQueueTbl;
    private String typeName;
    private String schemaName;
    private int dequeue_mode;
    private boolean dequeue_mode_forced;
    private int messageType;
    private UDTType udtType;

    public EDBJmsQueue() {
        this.dequeue_mode_forced = false;
    }

    public EDBJmsQueue(String name) {
        super(name);
        this.schemaName = null;
    }

    public UDTType getUdtType() {
        return this.udtType;
    }

    public void setUdtType(UDTType udtType) {
        this.udtType = udtType;
    }

    public String getQueueName() throws JMSException {
        return this.getName();
    }

    public boolean equals(Object object) {
        boolean result = object instanceof EDBJmsQueue && ((EDBJmsQueue)object).getName().equals(this.getName());
        return result;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeLong(1L);
        super.writeExternal(stream);
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version != 1L) {
            throw new IOException("JmsQueue with version " + version + " is not supported.");
        }
        super.readExternal(stream);
    }

    @Override
    public Reference getReference() {
        Reference reference = new Reference(EDBJmsQueue.class.getName(), new StringRefAddr("name", this.getName()), Destination.class.getName(), null);
        reference.add(new StringRefAddr("persistent", this.getPersistent() ? "true" : "false"));
        return reference;
    }

    public void start() {
        EDBQueueTable tbl = this.getEdbQueueTbl();
        Connection con = tbl.getConn();
        try (CallableStatement callStmt = this.getEdbQueueTbl().getConn().prepareCall("{call DBMS_AQADM.START_QUEUE(?)}");){
            callStmt.setString(1, this.getName());
            callStmt.execute();
            Logger.getLogger(EDBJmsQueue.class.getName()).log(Level.FINE, "Queue '" + this.getName() + "' started successfully");
        }
        catch (SQLException ex) {
            Logger.getLogger(EDBJmsQueue.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    @Override
    public EDBQueueTable getEdbQueueTbl() {
        return this.edbQueueTbl;
    }

    @Override
    public void setEdbQueueTbl(EDBQueueTable edbQueueTbl) {
        this.edbQueueTbl = edbQueueTbl;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public int getDequeue_mode() {
        return this.dequeue_mode;
    }

    public void setDequeue_mode(int dequeue_mode) {
        this.dequeue_mode = dequeue_mode;
        if (dequeue_mode == 0) {
            this.dequeue_mode_forced = true;
        }
    }

    public boolean getDequeue_mode_forced() {
        return this.dequeue_mode_forced;
    }

    public void setDequeue_mode_forced(int dequeue_mode) {
        this.dequeue_mode = dequeue_mode;
        this.dequeue_mode_forced = false;
    }
}

