/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.client;

import com.edb.aq.UDTType;
import com.edb.aq.operations.QueueTable;
import com.edb.aq.operations.UDTTypeReflection;
import com.edb.jms.client.EDBCachedMessage;
import com.edb.jms.client.EDBJmsConnection;
import com.edb.jms.client.EDBJmsMessageConsumer;
import com.edb.jms.client.EDBJmsMessageProducer;
import com.edb.jms.client.EDBJmsQueue;
import com.edb.jms.client.EDBJmsQueueResolver;
import com.edb.jms.client.EDBQueueTable;
import com.edb.jms.message.EDBBytesMessageImpl;
import com.edb.jms.message.EDBMessageImpl;
import com.edb.jms.message.EDBObjectMessageImpl;
import com.edb.jms.message.EDBTextMessageImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class EDBJmsSession
implements Session {
    private final int _acknowledgeMode;
    private final Connection _connection;
    private final EDBJmsConnection _jmsConnection;
    private String _queueTableName;
    private final boolean _transacted;
    private List<EDBCachedMessage> sentMessages;
    private List<String> receivedMessages;
    private boolean _closed = false;

    public EDBJmsSession(EDBJmsConnection connection, boolean transacted, int acknowledgeMode) {
        this._jmsConnection = connection;
        this._connection = connection.getConn();
        this._transacted = transacted;
        this._acknowledgeMode = acknowledgeMode;
        try {
            if (this.getTransacted()) {
                this.sentMessages = new ArrayList<EDBCachedMessage>();
            }
            if (this.getTransacted() || this._acknowledgeMode == 2) {
                this.receivedMessages = new ArrayList<String>();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(EDBJmsSession.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Connection getConnection() {
        return this._connection;
    }

    public EDBJmsConnection getJmsConnection() {
        return this._jmsConnection;
    }

    private Array getPropsArray(EDBMessageImpl message, String schemaName) throws JMSException {
        String propType = "AQ$_JMS_USERPROPERTY";
        if (schemaName != null) {
            propType = schemaName + "." + propType;
        }
        Enumeration props = message.getPropertyNames();
        ArrayList<String> propNames = new ArrayList<String>();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            propNames.add(propName);
        }
        Object[] ctArr = new Struct[propNames.size()];
        try {
            for (int i = 0; i < propNames.size(); ++i) {
                String propName = (String)propNames.get(i);
                String propVal = message.getStringProperty(propName);
                ctArr[i] = this._connection.createStruct(propType, new Object[]{propName, propVal});
            }
            Array propsTypeArray = this._connection.createArrayOf(propType, ctArr);
            return propsTypeArray;
        }
        catch (SQLException ex) {
            Logger.getLogger(EDBJmsSession.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    protected void sendMessage(Message message, Destination dest) throws JMSException {
        block21: {
            this.ensureOpen();
            EDBJmsQueue queue = (EDBJmsQueue)dest;
            String queueName = queue.getQueueName();
            String typeName = queue.getTypeName();
            try {
                if (message instanceof EDBTextMessageImpl) {
                    EDBTextMessageImpl textMessage = (EDBTextMessageImpl)message;
                    Array propsTypeArray = this.getPropsArray((EDBTextMessageImpl)message, queue.getSchemaName());
                    Struct texttype = this._connection.createStruct(typeName, new Object[]{propsTypeArray, textMessage.getText()});
                    if (this.getTransacted()) {
                        this.sentMessages.add(new EDBCachedMessage(queueName, texttype));
                    } else {
                        this.enqueueMessage(texttype, queueName);
                    }
                    break block21;
                }
                if (message instanceof EDBBytesMessageImpl) {
                    EDBBytesMessageImpl bytesMessage = (EDBBytesMessageImpl)message;
                    byte[] bytes = new byte[]{};
                    try {
                        ByteArrayOutputStream stream1 = new ByteArrayOutputStream();
                        ObjectOutputStream out1 = new ObjectOutputStream(stream1);
                        bytesMessage.writeExternal(out1);
                        bytes = stream1.toByteArray();
                        stream1.close();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(EDBJmsSession.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    Array propsTypeArray = this.getPropsArray((EDBBytesMessageImpl)message, queue.getSchemaName());
                    Struct bytestype = this._connection.createStruct(typeName, new Object[]{propsTypeArray, EDBJmsSession.bytesToHex(bytes)});
                    if (this.getTransacted()) {
                        this.sentMessages.add(new EDBCachedMessage(queueName, bytestype));
                    } else {
                        this.enqueueMessage(bytestype, queueName);
                    }
                    break block21;
                }
                if (message instanceof EDBObjectMessageImpl) {
                    EDBObjectMessageImpl objMessage = (EDBObjectMessageImpl)message;
                    byte[] bytes = new byte[]{};
                    try {
                        ByteArrayOutputStream stream1 = new ByteArrayOutputStream();
                        ObjectOutputStream out1 = new ObjectOutputStream(stream1);
                        objMessage.writeExternal(out1);
                        bytes = stream1.toByteArray();
                        stream1.close();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(EDBJmsSession.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    Array propsTypeArray = this.getPropsArray((EDBObjectMessageImpl)message, queue.getSchemaName());
                    Struct objtype = this._connection.createStruct(typeName, new Object[]{propsTypeArray, EDBJmsSession.bytesToHex(bytes)});
                    if (this.getTransacted()) {
                        this.sentMessages.add(new EDBCachedMessage(queueName, objtype));
                    } else {
                        this.enqueueMessage(objtype, queueName);
                    }
                    break block21;
                }
                if (message instanceof EDBMessageImpl && !(message instanceof UDTType)) {
                    Array propsTypeArray = this.getPropsArray((EDBMessageImpl)message, queue.getSchemaName());
                    Struct msgtype = this._connection.createStruct(typeName, new Object[]{propsTypeArray});
                    if (this.getTransacted()) {
                        this.sentMessages.add(new EDBCachedMessage(queueName, msgtype));
                    } else {
                        this.enqueueMessage(msgtype, queueName);
                    }
                } else {
                    Object[] paramObjects = UDTTypeReflection.getParamValues((UDTType)message);
                    Struct mytype = this.createMixedStruct(this._connection, ((UDTType)message).getName(), paramObjects);
                    if (this.getTransacted()) {
                        this.sentMessages.add(new EDBCachedMessage(queueName, mytype));
                    } else {
                        this.enqueueMessage(mytype, queueName);
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(EDBJmsSession.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private boolean enqueueMessage(Struct structType, String queueName) {
        try (CallableStatement callStmt = this._connection.prepareCall("{call DBMS_AQ.ENQUEUE(?,?,?,?,?)}");){
            callStmt.setString(1, queueName);
            Struct enqueueOptions = this._connection.createStruct("dbms_aq.enqueue_options_t", new Object[]{0, null, null, null, 0});
            callStmt.setObject(2, (Object)enqueueOptions);
            Struct messageProperties = this._connection.createStruct("dbms_aq.message_properties_t", new Object[]{1, 0, null, null, null, null, null, null, null, null, null, 0});
            callStmt.setObject(3, (Object)messageProperties);
            callStmt.setObject(4, (Object)structType);
            callStmt.registerOutParameter(5, -2);
            boolean result = callStmt.execute();
            Logger.getLogger(EDBJmsSession.class.getName()).log(Level.FINE, "Message Queued Successfully.");
        }
        catch (SQLException ex) {
            Logger.getLogger(EDBJmsSession.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    private Struct createMixedStruct(Connection connection, String typeName, Object[] paramValues) throws SQLException {
        Object[] structParams = new Object[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            if (paramValues[i].getClass().getName().contains("java.")) {
                structParams[i] = paramValues[i];
                continue;
            }
            UDTType innerUdt = (UDTType)paramValues[i];
            Object[] innerObj = UDTTypeReflection.getParamValues(innerUdt);
            structParams[i] = this.createMixedStruct(connection, innerUdt.getName(), innerObj);
        }
        return connection.createStruct(typeName, structParams);
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public Message receive(Destination dest) throws JMSException {
        this.ensureOpen();
        if (this._jmsConnection.isStopped()) {
            Logger.getLogger(EDBJmsSession.class.getName()).log(Level.WARNING, "Connection is closed.");
            return null;
        }
        EDBJmsQueue queue = (EDBJmsQueue)dest;
        String queueName = queue.getQueueName();
        String typeName = queue.getTypeName();
        String queueTableName = queue.getEdbQueueTbl().getQueueTableName();
        int dequeueMode = queue.getDequeue_mode();
        return this.dequeueMessage(queue.getUdtType(), queue, queueTableName, typeName, dequeueMode, queue.getMessageType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message dequeueMessage(UDTType udtType, EDBJmsQueue queue, String queueTableName, String typeName, int dequeueMode, int msgType) throws JMSException {
        String queueName = queue.getQueueName();
        UDTType message = null;
        try (CallableStatement callStmt = this._connection.prepareCall("{call DBMS_AQ.DEQUEUE(?,?,?,?::" + typeName + ",?)}");){
            String ackId;
            block61: {
                int msgCnt;
                Statement stmt = this._connection.createStatement();
                ResultSet rs = stmt.executeQuery("select count(*) from " + queueTableName);
                if (rs.next() && (msgCnt = rs.getInt(1)) == 0) {
                    rs.close();
                    stmt.close();
                    Logger.getLogger(Queue.class.getName()).log(Level.FINE, "Queue '" + queueName + "' is empty.");
                    UDTType uDTType = message;
                    return uDTType;
                }
                callStmt.setString(1, queueName);
                Struct dequeueOptions = this._connection.createStruct("dbms_aq.dequeue_options_t", new Object[]{null, dequeueMode, 1, 0, 1, null, null, null, null, 0});
                callStmt.setObject(2, (Object)dequeueOptions);
                callStmt.registerOutParameter(3, 2002, "dbms_aq.message_properties_t");
                callStmt.registerOutParameter(4, 2002, typeName);
                callStmt.registerOutParameter(5, -2);
                callStmt.execute();
                ackId = null;
                try {
                    ackId = EDBJmsSession.bytesToHex(callStmt.getBytes(5));
                    if (!this.getTransacted() && this._acknowledgeMode != 2) break block61;
                    if (!this.receivedMessages.contains(ackId)) {
                        this.receivedMessages.add(ackId);
                    } else if (!queue.getDequeue_mode_forced()) {
                        Logger.getLogger(Queue.class.getName()).log(Level.FINE, "Message already delivered.");
                        Message message2 = null;
                        return message2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Struct str = (Struct)callStmt.getObject(4);
            Object[] obj = str.getAttributes();
            if (typeName.toLowerCase().contains("aq$_jms_message")) {
                if (obj.length == 1) {
                    EDBMessageImpl msg = (EDBMessageImpl)this.createMessage();
                    msg.setAckMessageID(ackId);
                    msg.setSession(this);
                    msg.setJMSMessageID("ID:" + ackId);
                    Array array = (Array)obj[0];
                    ResultSet rs2 = array.getResultSet();
                    while (true) {
                        Object pair;
                        if (!rs2.next()) {
                            pair = msg;
                            return pair;
                        }
                        pair = (Struct)rs2.getObject(2);
                        Object[] pairVals = pair.getAttributes();
                        msg.setStringProperty((String)pairVals[0], (String)pairVals[1]);
                    }
                }
                Logger.getLogger(Queue.class.getName()).log(Level.SEVERE, "Invalid Message");
            } else if (typeName.toLowerCase().contains("aq$_jms_text_message")) {
                if (obj.length == 2) {
                    EDBTextMessageImpl msg = (EDBTextMessageImpl)this.createTextMessage((String)obj[1]);
                    msg.setAckMessageID(ackId);
                    msg.setSession(this);
                    msg.setJMSMessageID("ID:" + ackId);
                    Array array = (Array)obj[0];
                    ResultSet rs2 = array.getResultSet();
                    while (true) {
                        Object pair;
                        if (!rs2.next()) {
                            pair = msg;
                            return pair;
                        }
                        pair = (Struct)rs2.getObject(2);
                        Object[] pairVals = pair.getAttributes();
                        msg.setStringProperty((String)pairVals[0], (String)pairVals[1]);
                    }
                }
                Logger.getLogger(Queue.class.getName()).log(Level.SEVERE, "Invalid Text Message");
            } else if (typeName.toLowerCase().contains("aq$_jms_bytes_message")) {
                if (obj.length == 2) {
                    EDBBytesMessageImpl msg = (EDBBytesMessageImpl)this.createBytesMessage();
                    msg.setAckMessageID(ackId);
                    msg.setSession(this);
                    msg.setJMSMessageID("ID:" + ackId);
                    byte[] bytesMessage = EDBJmsSession.hexStringToByteArray((String)obj[1]);
                    try {
                        ByteArrayInputStream stream = new ByteArrayInputStream(bytesMessage);
                        ObjectInputStream in = new ObjectInputStream(stream);
                        msg.readExternal(in);
                        stream.close();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(EDBJmsSession.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    Array array = (Array)obj[0];
                    ResultSet rs2 = array.getResultSet();
                    while (true) {
                        Object pair;
                        if (!rs2.next()) {
                            pair = msg;
                            return pair;
                        }
                        pair = (Struct)rs2.getObject(2);
                        Object[] pairVals = pair.getAttributes();
                        msg.setStringProperty((String)pairVals[0], (String)pairVals[1]);
                    }
                }
                Logger.getLogger(Queue.class.getName()).log(Level.SEVERE, "Invalid Bytes Message");
            } else if (typeName.toLowerCase().contains("aq$_jms_object_message")) {
                if (obj.length == 2) {
                    EDBObjectMessageImpl msg = (EDBObjectMessageImpl)this.createObjectMessage();
                    msg.setAckMessageID(ackId);
                    msg.setSession(this);
                    msg.setJMSMessageID("ID:" + ackId);
                    byte[] bytesMessage = EDBJmsSession.hexStringToByteArray((String)obj[1]);
                    try {
                        ByteArrayInputStream stream = new ByteArrayInputStream(bytesMessage);
                        ObjectInputStream in = new ObjectInputStream(stream);
                        msg.readExternal(in);
                        stream.close();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(EDBJmsSession.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    Array array = (Array)obj[0];
                    ResultSet rs2 = array.getResultSet();
                    while (true) {
                        if (!rs2.next()) {
                            EDBObjectMessageImpl eDBObjectMessageImpl = msg;
                            return eDBObjectMessageImpl;
                        }
                        Struct pair = (Struct)rs2.getObject(2);
                        Object[] pairVals = pair.getAttributes();
                        msg.setStringProperty((String)pairVals[0], (String)pairVals[1]);
                    }
                }
                Logger.getLogger(Queue.class.getName()).log(Level.SEVERE, "Invalid Object Message");
            }
            message = this.reconstructUdt(udtType, obj);
            message.setJMSMessageID("ID:" + ackId);
            return message;
        }
        catch (SQLException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    private UDTType reconstructUdt(UDTType udtType, Object[] udtAttributeValues) {
        ArrayList setterMethods = UDTTypeReflection.getSetterMethods(udtType);
        int i = 0;
        try {
            for (Method setterMethod : setterMethods) {
                Method method = udtType.getClass().getMethod(setterMethod.getName(), setterMethod.getParameterTypes()[0]);
                Object reconstructedValue = this.reconstructObject(setterMethod, udtAttributeValues[i]);
                Object returnValue = method.invoke((Object)udtType, reconstructedValue);
                ++i;
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | SQLException ex) {
            Logger.getLogger(Queue.class.getName()).log(Level.SEVERE, null, ex);
        }
        return udtType;
    }

    private Object reconstructObject(Method setterMethod, Object attributeValue) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, SQLException {
        if (setterMethod.getParameterTypes()[0].toString().contains("java.")) {
            return attributeValue;
        }
        Object innerObj = setterMethod.getParameterTypes()[0].getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ArrayList innerSetterMethods = UDTTypeReflection.getSetterMethods((UDTType)innerObj);
        Struct innerStruct = (Struct)attributeValue;
        Object[] innerObjAttributes = innerStruct.getAttributes();
        int j = 0;
        for (Method innerSetterMethod : innerSetterMethods) {
            Method innerMethod = innerObj.getClass().getMethod(innerSetterMethod.getName(), innerSetterMethod.getParameterTypes()[0]);
            Object returnValue = this.reconstructObject(innerSetterMethod, innerObjAttributes[j]);
            innerMethod.invoke(innerObj, returnValue);
            ++j;
        }
        return innerObj;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.ensureOpen();
        EDBBytesMessageImpl byteMsg = new EDBBytesMessageImpl();
        return byteMsg;
    }

    public BytesMessage createBytesMessage(String text) throws JMSException {
        this.ensureOpen();
        return new EDBBytesMessageImpl();
    }

    public MapMessage createMapMessage() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Message createMessage() throws JMSException {
        this.ensureOpen();
        return new EDBMessageImpl();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.ensureOpen();
        return new EDBObjectMessageImpl();
    }

    public ObjectMessage createObjectMessage(Serializable obj) throws JMSException {
        EDBObjectMessageImpl objMsg = new EDBObjectMessageImpl();
        objMsg.setObject(obj);
        return objMsg;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TextMessage createTextMessage() throws JMSException {
        this.ensureOpen();
        EDBTextMessageImpl txtMsg = new EDBTextMessageImpl();
        return txtMsg;
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.ensureOpen();
        EDBTextMessageImpl txtMsg = new EDBTextMessageImpl();
        txtMsg.setText(text);
        return txtMsg;
    }

    public boolean getTransacted() throws JMSException {
        this.ensureOpen();
        return this._transacted;
    }

    protected void ensureOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Cannot perform operation - session has been closed");
        }
    }

    protected final boolean isClosed() {
        return this._closed;
    }

    public void acknowledgeMessages() throws JMSException {
        if (this.getTransacted()) {
            Logger.getLogger(EDBJmsSession.class.getName()).log(Level.INFO, "Cannot acknowledge messages in transacted session.");
            return;
        }
        int ackMode = this.getAcknowledgeMode();
        if (ackMode == 1 || ackMode == 3) {
            Logger.getLogger(EDBJmsSession.class.getName()).log(Level.INFO, "Cannot acknowledge messages in Session.AUTO_ACKNOWLEDGE mode. Messages are automatically acknowleged");
            return;
        }
        try {
            for (String ackId : this.receivedMessages) {
                this.acknowledgeMessage(ackId);
            }
            this.receivedMessages.clear();
        }
        catch (Exception ex) {
            Logger.getLogger(EDBJmsSession.class.getName()).log(Level.INFO, "Failed to acknowledge message in transaction. Error: " + ex.getMessage());
        }
    }

    private void acknowledgeMessage(String ackId) throws JMSException {
        if (ackId == null) {
            throw new JMSException("Cannot acknowlege. Message id is null.");
        }
        if (this._queueTableName == null) {
            throw new JMSException("Cannot acknowlege. Queue Table is not known.");
        }
        if (!ackId.startsWith("\\")) {
            ackId = "\\x" + ackId;
        }
        try {
            Statement stmt = this._connection.createStatement();
            String query = "DELETE FROM " + this._queueTableName + " WHERE MSGID = '" + ackId + "'";
            int count = stmt.executeUpdate(query);
            if (count < 1) {
                Logger.getLogger(EDBJmsSession.class.getName()).log(Level.INFO, "Message does not exist. It looks like it has already been acknowledged.");
            }
        }
        catch (SQLException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public int getAcknowledgeMode() throws JMSException {
        this.ensureOpen();
        return this._acknowledgeMode;
    }

    public void commit() throws JMSException {
        if (this._connection != null) {
            try {
                if (!this.getTransacted()) {
                    return;
                }
                try {
                    for (EDBCachedMessage message : this.sentMessages) {
                        this.enqueueMessage(message.getMessage(), message.getQueueName());
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(EDBJmsSession.class.getName()).log(Level.SEVERE, "Failed to save message in transaction. Error: " + ex.getMessage());
                }
                try {
                    for (String ackId : this.receivedMessages) {
                        this.acknowledgeMessage(ackId);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(EDBJmsSession.class.getName()).log(Level.SEVERE, "Failed to acknowledge message in transaction. Error: " + ex.getMessage());
                }
                this.sentMessages.clear();
                this.receivedMessages.clear();
            }
            catch (Exception e) {
                throw new JMSException(e.getMessage());
            }
        }
    }

    public void rollback() throws JMSException {
        if (this._connection != null) {
            try {
                if (!this.getTransacted()) {
                    return;
                }
                this.sentMessages.clear();
                this.receivedMessages.clear();
            }
            catch (Exception e) {
                throw new JMSException(e.getMessage());
            }
        }
    }

    public void close() throws JMSException {
        this._closed = true;
    }

    public void recover() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageListener getMessageListener() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setMessageListener(MessageListener arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void run() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return new EDBJmsMessageProducer(this, destination);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return new EDBJmsMessageConsumer(this, 1L, destination, null);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageConsumer createSharedConsumer(Topic arg0, String arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageConsumer createSharedConsumer(Topic arg0, String arg1, String arg2) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Queue createQueue(String queueName) throws JMSException {
        EDBJmsQueue queue;
        if (queueName != null && queueName.length() > 0) {
            queue = new EDBJmsQueue(queueName);
            try {
                Statement stmt = this._connection.createStatement();
                EDBJmsQueueResolver resolver = new EDBJmsQueueResolver(queueName);
                resolver.resolve(stmt);
                String queueTableName = resolver.getQueueTable();
                String queueTableSchema = resolver.getQueueTableSchema();
                String getPayLoadSchema = resolver.getPayLoadSchema();
                String payloadName = resolver.getPayloadType();
                if (queueTableName != null) {
                    if (payloadName != null) {
                        EDBQueueTable queueTable = this.getQueueTable(this._connection, queueTableName, payloadName, "Message queue table");
                        queue.setEdbQueueTbl(queueTable);
                        queue.setTypeName(payloadName);
                        if (getPayLoadSchema != null) {
                            queue.setTypeName(getPayLoadSchema + "." + payloadName);
                            queue.setSchemaName(getPayLoadSchema);
                        }
                        if (this._acknowledgeMode == 1 || this._acknowledgeMode == 3) {
                            queue.setDequeue_mode_forced(2);
                        }
                        queue.setDequeue_mode_forced(0);
                    }
                    Logger.getLogger(EDBJmsSession.class.getName()).log(Level.INFO, "No associated payload type found for Queue '" + queueName + "'.");
                }
                Logger.getLogger(EDBJmsSession.class.getName()).log(Level.INFO, "No associated Queue table found for Queue '" + queueName + "'.");
            }
            catch (SQLException exp) {
                throw new JMSException(exp.getMessage());
            }
        } else {
            throw new JMSException("Cannot create a queue with null or empty name");
        }
        return queue;
    }

    public EDBQueueTable getQueueTable(Connection conn, String queueTableName, String queuePayloadType, String comments) throws JMSException {
        if (queueTableName == null || queueTableName.length() <= 0) {
            throw new JMSException("Cannot create a queue with null or empty name");
        }
        EDBQueueTable queueTable = new EDBQueueTable(conn, queueTableName, queuePayloadType, comments);
        this._queueTableName = queueTableName;
        return queueTable;
    }

    public EDBQueueTable createQueueTable(Connection conn, String queueTableName, String queuePayloadType, String comments) throws JMSException {
        if (queueTableName == null || queueTableName.length() <= 0) {
            throw new JMSException("Cannot create a queue table with null or empty name");
        }
        EDBQueueTable queueTable = new EDBQueueTable(conn, queueTableName, queuePayloadType, comments);
        try (CallableStatement callStmt = conn.prepareCall("{call DBMS_AQADM.CREATE_QUEUE_TABLE(?,?,?,?,?,?,?,?,?,?,?,?)}");){
            callStmt.setString(1, queueTableName);
            callStmt.setString(2, queuePayloadType);
            callStmt.setString(3, null);
            callStmt.setString(4, null);
            callStmt.setBoolean(5, false);
            callStmt.setInt(6, 0);
            callStmt.setString(7, comments);
            callStmt.setBoolean(8, true);
            callStmt.setInt(9, 0);
            callStmt.setInt(10, 0);
            callStmt.setString(11, null);
            callStmt.setBoolean(12, false);
            callStmt.execute();
            Logger.getLogger(QueueTable.class.getName()).log(Level.FINE, "Queue table '" + queueTableName + "' created successfully.");
        }
        catch (SQLException ex) {
            Logger.getLogger(QueueTable.class.getName()).log(Level.SEVERE, null, ex);
        }
        this._queueTableName = queueTableName;
        return queueTable;
    }

    public Topic createTopic(String arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TopicSubscriber createDurableSubscriber(Topic arg0, String arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TopicSubscriber createDurableSubscriber(Topic arg0, String arg1, String arg2, boolean arg3) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageConsumer createDurableConsumer(Topic arg0, String arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageConsumer createDurableConsumer(Topic arg0, String arg1, String arg2, boolean arg3) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageConsumer createSharedDurableConsumer(Topic arg0, String arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageConsumer createSharedDurableConsumer(Topic arg0, String arg1, String arg2) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public QueueBrowser createBrowser(Queue arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public QueueBrowser createBrowser(Queue arg0, String arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void unsubscribe(String arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

