/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.common.uuid;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Clock
extends Thread {
    public static final int UNSYNCH_TICKS = 100;
    public static final int SYNCH_EVERY = 10;
    private static long _clock;
    private static int _unsynchTicks;
    private static int _synchEvery;
    private static long _advance;
    private static int _adjust;
    private static final Log _log;

    public static synchronized long clock() {
        return _clock;
    }

    public static void setUnsynchTicks(int ticks) {
        if (ticks <= 0) {
            ticks = 100;
        } else if (ticks < 100) {
            ticks = 100;
        }
        _unsynchTicks = ticks;
    }

    public static int getUnsynchTicks() {
        return _unsynchTicks;
    }

    public static void setSynchEvery(int every) {
        if (every <= 0) {
            every = 10;
        }
        _synchEvery = every;
    }

    public static synchronized void advance(long byMillis) {
        _advance += byMillis;
        _clock += byMillis;
    }

    public static long getAdvance() {
        return _advance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    for (int i = 0; i < _synchEvery; _clock += (long)(_unsynchTicks + _adjust), ++i) {
                        Clock.sleep(_unsynchTicks);
                        Class<Clock> clazz = Clock.class;
                        // MONITORENTER : com.edb.jms.common.uuid.Clock.class
                        // MONITOREXIT : clazz
                    }
                    Clock.synchronize();
                }
            }
            catch (InterruptedException exception) {
                Clock.synchronize();
                continue;
            }
            catch (ThreadDeath exception) {
                _log.debug((Object)"clock daemon terminating", (Throwable)exception);
                throw exception;
            }
            catch (Throwable exception) {
                _log.error((Object)"Internal error in clock daemon", exception);
                continue;
            }
            break;
        }
    }

    public static synchronized long synchronize() {
        int adjust;
        long clock;
        long retarded;
        long current = System.currentTimeMillis();
        if (current != (retarded = (clock = _clock) - _advance) && (adjust = (int)(current - retarded) / _synchEvery) != 0) {
            _adjust += adjust;
        }
        if (current > retarded) {
            _clock = clock = current + _advance;
        }
        return clock;
    }

    private Clock() {
        super("Clock Daemon");
        _clock = System.currentTimeMillis();
        this.setPriority(10);
        this.setDaemon(true);
        this.start();
    }

    public static void main(String[] args) {
        try {
            int i;
            int count = 1000000;
            System.out.println("Using Clock.clock()");
            long clock = System.currentTimeMillis();
            for (i = 0; i < count; ++i) {
                if (i % 100 == 0) {
                    Clock.synchronize();
                    continue;
                }
                Clock.clock();
            }
            clock = System.currentTimeMillis() - clock;
            System.out.println("Performed " + count + " in " + clock + "ms");
            System.out.println("Using System.currentTimeMillis()");
            clock = System.currentTimeMillis();
            for (i = 0; i < count; ++i) {
                System.currentTimeMillis();
            }
            clock = System.currentTimeMillis() - clock;
            System.out.println("Performed " + count + " in " + clock + "ms");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        _unsynchTicks = 100;
        _synchEvery = 10;
        _log = LogFactory.getLog(Clock.class);
        new Clock();
    }
}

