/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.message;

import com.edb.jms.message.EDBMessageImpl;
import com.edb.jms.message.Timestamp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UTFDataFormatException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;

public final class EDBBytesMessageImpl
extends EDBMessageImpl
implements BytesMessage {
    static final long serialVersionUID = 1L;
    private static final byte[] EMPTY = new byte[0];
    private byte[] _bytes = EMPTY;
    private DataOutputStream _out = null;
    private ByteArrayOutputStream _byteOut = null;
    private DataInputStream _in = null;
    private ByteArrayInputStream _byteIn = null;
    private int _offset = 0;

    public EDBBytesMessageImpl() throws JMSException {
        this.setJMSDeliveryMode(2);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        this.setJMSTimestamp(timestamp.getTime());
        this.setJMSType("BytesMessage");
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        EDBBytesMessageImpl result = (EDBBytesMessageImpl)super.clone();
        if (this._bodyReadOnly) {
            result._bytes = new byte[this._bytes.length];
            System.arraycopy(this._bytes, 0, result._bytes, 0, this._bytes.length);
            if (this._byteIn != null) {
                this._offset = this._bytes.length - this._byteIn.available();
            }
            result._byteIn = null;
            result._in = null;
        } else if (this._out != null) {
            try {
                this._out.flush();
            }
            catch (IOException exception) {
                throw new CloneNotSupportedException(exception.getMessage());
            }
            result._bytes = this._byteOut.toByteArray();
            result._byteOut = null;
            result._out = null;
        } else {
            result._bytes = new byte[this._bytes.length];
            System.arraycopy(this._bytes, 0, result._bytes, 0, this._bytes.length);
        }
        return result;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        if (!this._bodyReadOnly && this._out != null) {
            this._out.flush();
            this._bytes = this._byteOut.toByteArray();
        }
        super.writeExternal(out);
        out.writeLong(1L);
        out.writeInt(this._bytes.length);
        out.write(this._bytes);
        out.flush();
    }

    @Override
    public final void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        super.readExternal(in);
        long version = in.readLong();
        if (version != 1L) {
            throw new IOException("Incorrect version enountered: " + version + ". This version = " + 1L);
        }
        int length = in.readInt();
        this._bytes = new byte[length];
        in.readFully(this._bytes);
    }

    public long getBodyLength() throws JMSException {
        this.checkRead();
        return this._bytes.length;
    }

    public final boolean readBoolean() throws JMSException {
        boolean result = false;
        this.prepare();
        try {
            result = this._in.readBoolean();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final byte readByte() throws JMSException {
        byte result = 0;
        this.prepare();
        try {
            result = this._in.readByte();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final int readUnsignedByte() throws JMSException {
        int result = 0;
        this.prepare();
        try {
            result = this._in.readUnsignedByte();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final short readShort() throws JMSException {
        short result = 0;
        this.prepare();
        try {
            result = this._in.readShort();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final int readUnsignedShort() throws JMSException {
        int result = 0;
        this.prepare();
        try {
            result = this._in.readUnsignedShort();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final char readChar() throws JMSException {
        char result = '\u0000';
        this.prepare();
        try {
            result = this._in.readChar();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final int readInt() throws JMSException {
        int result = 0;
        this.prepare();
        try {
            result = this._in.readInt();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final long readLong() throws JMSException {
        long result = 0L;
        this.prepare();
        try {
            result = this._in.readLong();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final float readFloat() throws JMSException {
        float result = 0.0f;
        this.prepare();
        try {
            result = this._in.readFloat();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final double readDouble() throws JMSException {
        double result = 0.0;
        this.prepare();
        try {
            result = this._in.readDouble();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final String readUTF() throws JMSException {
        String result = null;
        this.prepare();
        try {
            result = this._in.readUTF();
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return result;
    }

    public final int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    public final int readBytes(byte[] value, int length) throws JMSException {
        int read = -1;
        this.prepare();
        if (length < 0 || length > value.length) {
            throw new IndexOutOfBoundsException("Length must be > 0 and less than array size");
        }
        try {
            this._in.mark(length);
            int remain = this._in.available();
            if (remain == 0) {
                read = -1;
            } else if (length <= remain) {
                read = length;
                this._in.read(value, 0, length);
            } else {
                this._in.readFully(value, 0, remain);
                read = remain;
            }
        }
        catch (EOFException remain) {
        }
        catch (IOException exception) {
            this.revert(exception);
        }
        return read;
    }

    public final void writeBoolean(boolean value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeBoolean(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeByte(byte value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeByte(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeShort(short value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeShort(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeChar(char value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeChar(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeInt(int value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeInt(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeLong(long value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeLong(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeFloat(float value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeFloat(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeDouble(double value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeDouble(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeUTF(String value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().writeUTF(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeBytes(byte[] value) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().write(value);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWrite();
        try {
            this.getOutputStream().write(value, offset, length);
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    public final void writeObject(Object value) throws JMSException {
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            if (value == null) {
                throw new NullPointerException("BytesMessage does not support null");
            }
            throw new MessageFormatException("Cannot write objects of type=" + value.getClass().getName());
        }
    }

    public final void reset() throws JMSException {
        try {
            if (!this._bodyReadOnly) {
                this._bodyReadOnly = true;
                if (this._out != null) {
                    this._out.flush();
                    this._bytes = this._byteOut.toByteArray();
                    this._byteOut = null;
                    this._out.close();
                    this._out = null;
                }
            } else if (this._in != null) {
                this._byteIn = null;
                this._in.close();
                this._in = null;
            }
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    @Override
    public final void clearBody() throws JMSException {
        try {
            if (this._bodyReadOnly) {
                this._bodyReadOnly = false;
                if (this._in != null) {
                    this._byteIn = null;
                    this._in.close();
                    this._in = null;
                    this._offset = 0;
                }
            } else if (this._out != null) {
                this._byteOut = null;
                this._out.close();
                this._out = null;
            }
            this._bytes = EMPTY;
            this._byteOut = null;
            this._out = null;
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    @Override
    public final void setReadOnly(boolean readOnly) throws JMSException {
        if (readOnly) {
            this.reset();
        }
        super.setReadOnly(readOnly);
    }

    private final void prepare() throws JMSException {
        this.checkRead();
        this.getInputStream();
        try {
            this._in.mark(this._bytes.length - this._in.available());
        }
        catch (IOException exception) {
            this.raise(exception);
        }
    }

    private final void revert(IOException exception) throws JMSException {
        try {
            this._in.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object error = null;
        error = exception instanceof EOFException ? new MessageEOFException(exception.getMessage()) : (exception instanceof UTFDataFormatException ? new MessageFormatException(exception.getMessage()) : new JMSException(exception.getMessage()));
        error.setLinkedException((Exception)exception);
        throw error;
    }

    private DataInputStream getInputStream() {
        if (this._in == null) {
            this._byteIn = new ByteArrayInputStream(this._bytes, this._offset, this._bytes.length - this._offset);
            this._in = new DataInputStream(this._byteIn);
        }
        return this._in;
    }

    private final DataOutputStream getOutputStream() throws IOException {
        if (this._out == null) {
            this._byteOut = new ByteArrayOutputStream();
            this._out = new DataOutputStream(this._byteOut);
            this._out.write(this._bytes);
        }
        return this._out;
    }

    private final void raise(IOException exception) throws JMSException {
        JMSException error = new JMSException(exception.getMessage());
        error.setLinkedException((Exception)exception);
        throw error;
    }
}

