/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.message;

import com.edb.jms.message.CorrelationId;
import com.edb.jms.message.DeliveryModeImpl;
import com.edb.jms.message.EDBDestinationImpl;
import com.edb.jms.message.MessageId;
import com.edb.jms.message.Priority;
import com.edb.jms.message.Timestamp;
import com.edb.jms.message.Type;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.Destination;
import javax.jms.JMSException;

class EDBMessageHeader
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 1L;
    private EDBDestinationImpl _replyTo = null;
    private Timestamp _timestamp = null;
    private CorrelationId _correlationId = null;
    private boolean _redelivered = false;
    private long _expiration = 0L;
    private Priority _priority = null;
    private Type _type = null;
    private EDBDestinationImpl _destination = null;
    private DeliveryModeImpl _mode = null;
    private MessageId _id = null;
    private transient String _ackId;
    private String _wildcard = null;
    private String _unused = null;
    private long _consumerId;

    public Object clone() throws CloneNotSupportedException {
        EDBMessageHeader result = (EDBMessageHeader)super.clone();
        result._replyTo = this._replyTo;
        result._timestamp = this._timestamp;
        result._correlationId = this._correlationId;
        result._priority = this._priority;
        result._type = this._type;
        result._destination = this._destination;
        result._mode = this._mode;
        result._id = this._id;
        result._ackId = this._ackId;
        result._wildcard = this._wildcard == null ? null : this._wildcard;
        result._consumerId = this._consumerId;
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(1L);
        out.writeObject(this._replyTo);
        out.writeObject(this._timestamp);
        out.writeObject(this._correlationId);
        out.writeBoolean(this._redelivered);
        out.writeLong(this._expiration);
        out.writeObject(this._priority);
        out.writeObject(this._type);
        out.writeObject(this._destination);
        out.writeObject(this._mode);
        out.writeObject(this._id);
        out.writeObject(this._wildcard);
        out.writeObject(this._unused);
        out.writeLong(this._consumerId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version != 1L) {
            throw new IOException("Incorrect version enountered: " + version + " This version = " + 1L);
        }
        this._replyTo = (EDBDestinationImpl)in.readObject();
        this._timestamp = (Timestamp)in.readObject();
        this._correlationId = (CorrelationId)in.readObject();
        this._redelivered = in.readBoolean();
        this._expiration = in.readLong();
        this._priority = (Priority)in.readObject();
        this._type = (Type)in.readObject();
        this._destination = (EDBDestinationImpl)in.readObject();
        this._mode = (DeliveryModeImpl)in.readObject();
        this._id = (MessageId)in.readObject();
        this._wildcard = (String)in.readObject();
        this._unused = (String)in.readObject();
        this._consumerId = in.readLong();
    }

    Destination getJMSReplyTo() throws JMSException {
        return this._replyTo;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        if (!(replyTo instanceof EDBDestinationImpl)) {
            throw new JMSException("Unknown Destination Type");
        }
        this._replyTo = (EDBDestinationImpl)replyTo;
    }

    public Destination getJMSDestination() throws JMSException {
        return this._destination;
    }

    void setJMSDestination(Destination destination) throws JMSException {
        if (!(destination instanceof EDBDestinationImpl)) {
            throw new JMSException("Unknown Destination Type");
        }
        this._destination = (EDBDestinationImpl)destination;
    }

    public String getJMSMessageID() throws JMSException {
        return this._id != null ? this._id.toString() : null;
    }

    public void setJMSMessageID(String id) throws JMSException {
        if (id != null) {
            if (!id.startsWith("ID:")) {
                throw new JMSException("Invalid JMSMessageID: " + id);
            }
            this._id = new MessageId(id);
        } else {
            this._id = null;
        }
    }

    public String getAckMessageID() {
        return this._ackId;
    }

    public void setAckMessageID(String id) {
        this._ackId = id;
    }

    public long getJMSTimestamp() throws JMSException {
        if (this._timestamp != null) {
            return this._timestamp.toLong();
        }
        throw new JMSException("No Timestamp set");
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this._timestamp = new Timestamp(timestamp);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this._correlationId != null ? this._correlationId.getBytes() : null;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this._correlationId = new CorrelationId(correlationID);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this._correlationId != null ? this._correlationId.getString() : null;
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this._correlationId = correlationID != null ? new CorrelationId(correlationID) : null;
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (this._mode != null) {
            return this._mode.getDeliveryMode();
        }
        throw new JMSException("No Delivery Mode set");
    }

    public void setJMSDeliveryMode(int mode) throws JMSException {
        this._mode = new DeliveryModeImpl(mode);
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this._redelivered;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this._redelivered = redelivered;
    }

    public String getJMSType() throws JMSException {
        return this._type != null ? this._type.getType() : null;
    }

    public void setJMSType(String type) throws JMSException {
        this._type = type != null ? new Type(type) : null;
    }

    public long getJMSExpiration() throws JMSException {
        return this._expiration;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this._expiration = expiration;
    }

    public int getJMSPriority() throws JMSException {
        if (this._priority != null) {
            return this._priority.getPriority();
        }
        return 0;
    }

    public void setJMSPriority(int priority) throws JMSException {
        this._priority = new Priority(priority);
    }

    public long getConsumerId() {
        return this._consumerId;
    }

    public void setConsumerId(long consumerId) {
        this._consumerId = consumerId;
    }

    public MessageId getMessageId() {
        return this._id;
    }

    public String getWildcard() {
        return this._wildcard;
    }

    public void setWildcard(String wildcard) {
        this._wildcard = wildcard;
    }
}

