/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.message;

import com.edb.jms.client.EDBJmsSession;
import com.edb.jms.message.EDBMessageHeader;
import com.edb.jms.message.MessageProperties;
import com.edb.jms.message.Timestamp;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class EDBMessageImpl
implements Message,
Externalizable,
Cloneable {
    protected static final byte[] EMPTY = new byte[0];
    static final long serialVersionUID = 1L;
    private final EDBMessageHeader _messageHeader = new EDBMessageHeader();
    private final MessageProperties _messageProperties = new MessageProperties();
    protected boolean _propertiesReadOnly = false;
    protected boolean _bodyReadOnly = false;
    protected long _acceptedTime;
    protected long _sequenceNumber;
    protected transient long _connectionId;
    protected boolean _processed = false;
    private EDBJmsSession _session = null;

    public EDBMessageImpl() {
        try {
            this.setJMSDeliveryMode(2);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            this.setJMSTimestamp(timestamp.getTime());
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public Object clone() throws CloneNotSupportedException {
        EDBMessageImpl result = (EDBMessageImpl)super.clone();
        return result;
    }

    public MessageProperties getMessageProperties() {
        return this._messageProperties;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(1L);
        out.writeBoolean(this._propertiesReadOnly || this._bodyReadOnly);
        out.writeBoolean(this._processed);
        out.writeLong(this._acceptedTime);
        out.writeLong(this._sequenceNumber);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean readOnly;
        long version = in.readLong();
        if (version != 1L) {
            throw new IOException("Incorrect version enountered: " + version + ". This version = " + 1L);
        }
        this._propertiesReadOnly = readOnly = in.readBoolean();
        this._bodyReadOnly = readOnly;
        this._processed = in.readBoolean();
        this._acceptedTime = in.readLong();
        this._sequenceNumber = in.readLong();
    }

    public void setSession(EDBJmsSession session) {
        this._session = session;
    }

    public String getJMSMessageID() throws JMSException {
        return this._messageHeader.getJMSMessageID();
    }

    public void setJMSMessageID(String id) throws JMSException {
        this._messageHeader.setJMSMessageID(id);
    }

    public String getAckMessageID() {
        return this._messageHeader.getAckMessageID();
    }

    public void setAckMessageID(String id) {
        this._messageHeader.setAckMessageID(id);
    }

    public long getJMSTimestamp() throws JMSException {
        return this._messageHeader.getJMSTimestamp();
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this._messageHeader.setJMSTimestamp(timestamp);
    }

    public String getWildcard() {
        return this._messageHeader.getWildcard();
    }

    public void setWildcard(String wildcard) {
        this._messageHeader.setWildcard(wildcard);
    }

    public long getConsumerId() {
        return this._messageHeader.getConsumerId();
    }

    public void setConsumerId(long consumerId) {
        this._messageHeader.setConsumerId(consumerId);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this._messageHeader.getJMSCorrelationID();
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this._messageHeader.setJMSCorrelationID(correlationID);
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this._messageHeader.getJMSReplyTo();
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this._messageHeader.setJMSReplyTo(replyTo);
    }

    public Destination getJMSDestination() throws JMSException {
        return this._messageHeader.getJMSDestination();
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this._messageHeader.setJMSDestination(destination);
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this._messageHeader.getJMSDeliveryMode();
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this._messageHeader.setJMSDeliveryMode(deliveryMode);
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this._messageHeader.getJMSRedelivered();
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this._messageHeader.setJMSRedelivered(redelivered);
    }

    public String getJMSType() throws JMSException {
        return this._messageHeader.getJMSType();
    }

    public void setJMSType(String type) throws JMSException {
        this._messageHeader.setJMSType(type);
    }

    public long getJMSExpiration() throws JMSException {
        return 0L;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this._messageHeader.setJMSExpiration(expiration);
    }

    public int getJMSPriority() throws JMSException {
        return this._messageHeader.getJMSPriority();
    }

    public void setJMSPriority(int priority) throws JMSException {
        this._messageHeader.setJMSPriority(priority);
    }

    public void clearProperties() throws JMSException {
        this._propertiesReadOnly = false;
    }

    public boolean propertyExists(String name) throws JMSException {
        return this._messageProperties.propertyExists(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return this._messageProperties.getBooleanProperty(name);
    }

    public short getShortProperty(String name) throws JMSException {
        return this._messageProperties.getShortProperty(name);
    }

    public int getIntProperty(String name) throws JMSException {
        return this._messageProperties.getIntProperty(name);
    }

    public long getLongProperty(String name) throws JMSException {
        return this._messageProperties.getLongProperty(name);
    }

    public float getFloatProperty(String name) throws JMSException {
        return this._messageProperties.getFloatProperty(name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        return this._messageProperties.getDoubleProperty(name);
    }

    public String getStringProperty(String name) throws JMSException {
        return this._messageProperties.getStringProperty(name);
    }

    public Object getObjectProperty(String name) throws JMSException {
        return this._messageProperties.getObjectProperty(name);
    }

    public void acknowledge() throws JMSException {
        if (this.getAckMessageID() == null) {
            throw new JMSException("Cannot acknowledge message: no identifier");
        }
        if (this._session == null) {
            throw new JMSException("Cannot acknowledge message: unknown session");
        }
        this._session.acknowledgeMessages();
    }

    public void clearBody() throws JMSException {
        this._bodyReadOnly = false;
    }

    public final void checkPropertyWrite() throws MessageNotWriteableException {
        if (this._propertiesReadOnly) {
            throw new MessageNotWriteableException("Message in read-only mode");
        }
    }

    public final void checkWrite() throws MessageNotWriteableException {
        if (this._bodyReadOnly) {
            throw new MessageNotWriteableException("Message in read-only mode");
        }
    }

    public final void checkRead() throws MessageNotReadableException {
        if (!this._bodyReadOnly) {
            throw new MessageNotReadableException("Message in write-only mode");
        }
    }

    public String getId() {
        return this._messageHeader.getMessageId().getId();
    }

    public long getAcceptedTime() {
        return this._acceptedTime;
    }

    public void setAcceptedTime(long time) {
        this._acceptedTime = time;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public void setSequenceNumber(long seq) {
        this._sequenceNumber = seq;
    }

    public long getConnectionId() {
        return this._connectionId;
    }

    public void setConnectionId(long id) {
        this._connectionId = id;
    }

    public boolean getProcessed() {
        return this._processed;
    }

    public void setProcessed(boolean state) {
        this._processed = state;
    }

    public final boolean getReadOnly() {
        return this._propertiesReadOnly && this._bodyReadOnly;
    }

    public void setReadOnly(boolean readOnly) throws JMSException {
        this._propertiesReadOnly = readOnly;
        this._bodyReadOnly = readOnly;
    }

    public void setJMSXRcvTimestamp(long timestamp) {
        this._messageProperties.setJMSXRcvTimestamp(timestamp);
    }

    public long getJMSDeliveryTime() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setJMSDeliveryTime(long arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T> T getBody(Class<T> arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isBodyAssignableTo(Class arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this._messageHeader.setJMSCorrelationIDAsBytes(correlationID);
    }

    public byte getByteProperty(String name) throws JMSException {
        return this._messageProperties.getByteProperty(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return this._messageProperties.getPropertyNames();
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.checkPropertyWrite();
        this._messageProperties.setBooleanProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.checkPropertyWrite();
        this._messageProperties.setByteProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.checkPropertyWrite();
        this._messageProperties.setShortProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.checkPropertyWrite();
        this._messageProperties.setIntProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this._messageProperties.setLongProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this._messageProperties.setFloatProperty(name, value);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this._messageProperties.setDoubleProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this._messageProperties.setStringProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this._messageProperties.setObjectProperty(name, value);
    }
}

