/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.message;

import com.edb.jms.message.EDBMessageImpl;
import com.edb.jms.message.Timestamp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;

public final class EDBObjectMessageImpl
extends EDBMessageImpl
implements ObjectMessage {
    static final long serialVersionUID = 1L;
    private byte[] _bytes = null;

    public EDBObjectMessageImpl() throws JMSException {
        this.setJMSDeliveryMode(2);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        this.setJMSTimestamp(timestamp.getTime());
        this.setJMSType("ObjectMessage");
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        EDBObjectMessageImpl result = (EDBObjectMessageImpl)super.clone();
        if (this._bytes != null) {
            result._bytes = new byte[this._bytes.length];
            System.arraycopy(this._bytes, 0, result._bytes, 0, this._bytes.length);
        }
        return result;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(1L);
        if (this._bytes != null) {
            out.writeInt(this._bytes.length);
            out.write(this._bytes);
            out.flush();
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        super.readExternal(in);
        long version = in.readLong();
        if (version == 1L) {
            int length = in.readInt();
            if (length != 0) {
                this._bytes = new byte[length];
                in.readFully(this._bytes);
            } else {
                this._bytes = null;
            }
        } else {
            throw new IOException("Incorrect version enountered: " + version + ". This version = " + 1L);
        }
    }

    public final Serializable getObject() throws MessageFormatException {
        Serializable result = null;
        if (this._bytes != null) {
            try {
                ByteArrayInputStream byteIn = new ByteArrayInputStream(this._bytes);
                ObjectStream in = new ObjectStream(byteIn);
                result = (Serializable)in.readObject();
                in.close();
            }
            catch (IOException exception) {
                MessageFormatException error = new MessageFormatException(exception.getMessage());
                error.setLinkedException((Exception)exception);
                throw error;
            }
            catch (ClassNotFoundException exception) {
                MessageFormatException error = new MessageFormatException(exception.getMessage());
                error.setLinkedException((Exception)exception);
                throw error;
            }
        }
        return result;
    }

    public final void setObject(Serializable object) throws MessageFormatException, MessageNotWriteableException {
        this.checkWrite();
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(object);
            out.flush();
            this._bytes = byteOut.toByteArray();
            out.close();
        }
        catch (IOException exception) {
            MessageFormatException error = new MessageFormatException(exception.getMessage());
            error.setLinkedException((Exception)exception);
            throw error;
        }
    }

    @Override
    public final void clearBody() throws JMSException {
        super.clearBody();
        this._bytes = null;
    }

    private class ObjectStream
    extends ObjectInputStream {
        public ObjectStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                try {
                    return loader.loadClass(desc.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return super.resolveClass(desc);
        }
    }
}

