/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.message;

import javax.jms.MessageFormatException;

class FormatConverter {
    FormatConverter() {
    }

    public static boolean getBoolean(Object value) throws MessageFormatException {
        boolean result = false;
        if (value instanceof Boolean) {
            result = (Boolean)value;
        } else if (value instanceof String) {
            result = Boolean.valueOf((String)value);
        } else if (value == null) {
            result = Boolean.valueOf((String)value);
        } else {
            FormatConverter.raise(value, Boolean.TYPE);
        }
        return result;
    }

    public static byte getByte(Object value) throws MessageFormatException {
        byte result = 0;
        if (value instanceof Byte) {
            result = (Byte)value;
        } else if (value instanceof String) {
            result = Byte.parseByte((String)value);
        } else if (value == null) {
            result = Byte.valueOf((String)value);
        } else {
            FormatConverter.raise(value, Byte.TYPE);
        }
        return result;
    }

    public static short getShort(Object value) throws MessageFormatException {
        short result = 0;
        if (value instanceof Short) {
            result = (Short)value;
        } else if (value instanceof Byte) {
            result = ((Byte)value).shortValue();
        } else if (value instanceof String) {
            result = Short.parseShort((String)value);
        } else if (value == null) {
            result = Short.valueOf((String)value);
        } else {
            FormatConverter.raise(value, Short.TYPE);
        }
        return result;
    }

    public static char getChar(Object value) throws MessageFormatException {
        char result = '\u0000';
        if (value instanceof Character) {
            result = ((Character)value).charValue();
        } else {
            if (value == null) {
                throw new NullPointerException("Cannot convert null value to char");
            }
            FormatConverter.raise(value, Character.TYPE);
        }
        return result;
    }

    public static int getInt(Object value) throws MessageFormatException {
        int result = 0;
        if (value instanceof Integer) {
            result = (Integer)value;
        } else if (value instanceof Short) {
            result = ((Short)value).intValue();
        } else if (value instanceof Byte) {
            result = ((Byte)value).intValue();
        } else if (value instanceof String) {
            result = Integer.parseInt((String)value);
        } else if (value == null) {
            result = Integer.valueOf((String)value);
        } else {
            FormatConverter.raise(value, Integer.TYPE);
        }
        return result;
    }

    public static long getLong(Object value) throws MessageFormatException {
        long result = 0L;
        if (value instanceof Long) {
            result = (Long)value;
        } else if (value instanceof Integer) {
            result = ((Integer)value).longValue();
        } else if (value instanceof Short) {
            result = ((Short)value).longValue();
        } else if (value instanceof Byte) {
            result = ((Byte)value).longValue();
        } else if (value instanceof String) {
            result = Long.parseLong((String)value);
        } else if (value == null) {
            result = Long.valueOf((String)value);
        } else {
            FormatConverter.raise(value, Long.TYPE);
        }
        return result;
    }

    public static float getFloat(Object value) throws MessageFormatException {
        float result = 0.0f;
        if (value instanceof Float) {
            result = ((Float)value).floatValue();
        } else if (value instanceof String) {
            result = Float.parseFloat((String)value);
        } else if (value == null) {
            result = Float.valueOf((String)value).floatValue();
        } else {
            FormatConverter.raise(value, Float.TYPE);
        }
        return result;
    }

    public static double getDouble(Object value) throws MessageFormatException {
        double result = 0.0;
        if (value instanceof Double) {
            result = (Double)value;
        } else if (value instanceof Float) {
            result = ((Float)value).doubleValue();
        } else if (value instanceof String) {
            result = Double.parseDouble((String)value);
        } else if (value == null) {
            result = Double.valueOf((String)value);
        } else {
            FormatConverter.raise(value, Double.TYPE);
        }
        return result;
    }

    public static String getString(Object value) throws MessageFormatException {
        if (value instanceof byte[]) {
            FormatConverter.raise(value, String.class);
        }
        return value == null ? null : String.valueOf(value);
    }

    public static byte[] getBytes(Object value) throws MessageFormatException {
        byte[] result = null;
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            result = new byte[bytes.length];
            System.arraycopy(bytes, 0, result, 0, bytes.length);
        } else if (value != null) {
            FormatConverter.raise(value, byte[].class);
        }
        return result;
    }

    private static void raise(Object value, Class type) throws MessageFormatException {
        throw new MessageFormatException("Cannot convert values of type " + value.getClass().getName() + " to " + type.getName());
    }
}

