/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.message;

import com.edb.jms.common.uuid.UUID;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class MessageId
implements Externalizable {
    public static final String PREFIX = "ID:";
    static final long serialVersionUID = 2L;
    private static final String NULL_ID = "ID:0";
    private String _id = null;

    public MessageId() {
    }

    public MessageId(String id) {
        this._id = id;
    }

    public static String create() {
        return UUID.next(PREFIX);
    }

    public static String getNull() {
        return NULL_ID;
    }

    public String getId() {
        return this._id;
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(2L);
        out.writeUTF(this._id);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version == 2L) {
            this._id = in.readUTF();
        } else if (version == 1L) {
            long oldID = in.readLong();
            String id = (String)in.readObject();
            this._id = PREFIX + id;
        } else {
            throw new IOException("Incorrect version enountered: " + version + " This version = " + 2L);
        }
    }

    public String toString() {
        return this._id;
    }

    public boolean equals(Object object) {
        boolean equal;
        boolean bl = equal = object == this;
        if (!equal && object instanceof MessageId && ((MessageId)object)._id.equals(this._id)) {
            equal = true;
        }
        return equal;
    }
}

