/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.JMSException;

public class Priority
implements Externalizable {
    static final long serialVersionUID = 1L;
    private int priority_ = 0;

    public Priority() {
    }

    public Priority(int priority) throws JMSException {
        if (priority < 0 || priority >= 10) {
            throw new JMSException("Invalid priority");
        }
        this.priority_ = priority;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(1L);
        out.writeInt(this.priority_);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version != 1L) {
            throw new IOException("Incorrect version enountered: " + version + " This version = " + 1L);
        }
        this.priority_ = in.readInt();
    }

    public int getPriority() {
        return this.priority_;
    }

    public boolean isExpedited() {
        return this.priority_ >= 5;
    }

    public boolean isGreater(Priority toCompare) {
        return this.priority_ > toCompare.priority_;
    }

    public boolean isEqual(Priority toCompare) {
        return this.priority_ == toCompare.priority_;
    }
}

