/*
 * Decompiled with CFR 0.152.
 */
package com.edb.util;

import com.edb.core.EncodingPredictor;
import com.edb.util.GT;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ServerErrorMessage
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(ServerErrorMessage.class.getName());
    private static final Character SEVERITY = Character.valueOf('S');
    private static final Character MESSAGE = Character.valueOf('M');
    private static final Character DETAIL = Character.valueOf('D');
    private static final Character HINT = Character.valueOf('H');
    private static final Character POSITION = Character.valueOf('P');
    private static final Character WHERE = Character.valueOf('W');
    private static final Character FILE = Character.valueOf('F');
    private static final Character LINE = Character.valueOf('L');
    private static final Character ROUTINE = Character.valueOf('R');
    private static final Character SQLSTATE = Character.valueOf('C');
    private static final Character INTERNAL_POSITION = Character.valueOf('p');
    private static final Character INTERNAL_QUERY = Character.valueOf('q');
    private static final Character SCHEMA = Character.valueOf('s');
    private static final Character TABLE = Character.valueOf('t');
    private static final Character COLUMN = Character.valueOf('c');
    private static final Character DATATYPE = Character.valueOf('d');
    private static final Character CONSTRAINT = Character.valueOf('n');
    private static final int DISPLAY_SIZE = 60;
    private static final int MIN_RIGHT_CUT = 10;
    private String sql;
    private final Map<Character, String> mesgParts = new HashMap<Character, String>();

    public ServerErrorMessage(EncodingPredictor.DecodeResult serverError) {
        this(serverError, null);
    }

    public ServerErrorMessage(EncodingPredictor.DecodeResult serverError, String sql) {
        this(serverError.result);
        if (serverError.encoding != null) {
            this.mesgParts.put(MESSAGE, this.mesgParts.get(MESSAGE) + GT.tr(" (pgjdbc: autodetected server-encoding to be {0}, if the message is not readable, please check database logs and/or host, port, dbname, user, password, pg_hba.conf)", serverError.encoding));
        }
        this.sql = sql;
    }

    public ServerErrorMessage(String serverError) {
        char[] chars = serverError.toCharArray();
        int length = chars.length;
        for (int pos = 0; pos < length; ++pos) {
            char mesgType = chars[pos];
            if (mesgType == '\u0000') continue;
            int startString = ++pos;
            while (pos < length && chars[pos] != '\u0000') {
                ++pos;
            }
            String mesgPart = new String(chars, startString, pos - startString);
            this.mesgParts.put(Character.valueOf(mesgType), mesgPart);
        }
    }

    public @Nullable String getSQLState() {
        return this.mesgParts.get(SQLSTATE);
    }

    public int getVendorCode() {
        int index;
        String message = this.getMessage();
        if (message != null && message.startsWith("EDB-") && (index = message.indexOf(":")) == 9) {
            try {
                return Integer.parseInt(message.substring(4, 9));
            }
            catch (Exception ex) {
                return 0;
            }
        }
        return 0;
    }

    public @Nullable String getMessage() {
        return this.mesgParts.get(MESSAGE);
    }

    public @Nullable String getSeverity() {
        return this.mesgParts.get(SEVERITY);
    }

    public @Nullable String getDetail() {
        return this.mesgParts.get(DETAIL);
    }

    public @Nullable String getHint() {
        return this.mesgParts.get(HINT);
    }

    public int getPosition() {
        return this.getIntegerPart(POSITION);
    }

    public @Nullable String getWhere() {
        return this.mesgParts.get(WHERE);
    }

    public @Nullable String getSchema() {
        return this.mesgParts.get(SCHEMA);
    }

    public @Nullable String getTable() {
        return this.mesgParts.get(TABLE);
    }

    public @Nullable String getColumn() {
        return this.mesgParts.get(COLUMN);
    }

    public @Nullable String getDatatype() {
        return this.mesgParts.get(DATATYPE);
    }

    public @Nullable String getConstraint() {
        return this.mesgParts.get(CONSTRAINT);
    }

    public @Nullable String getFile() {
        return this.mesgParts.get(FILE);
    }

    public int getLine() {
        return this.getIntegerPart(LINE);
    }

    public @Nullable String getRoutine() {
        return this.mesgParts.get(ROUTINE);
    }

    public @Nullable String getInternalQuery() {
        return this.mesgParts.get(INTERNAL_QUERY);
    }

    public int getInternalPosition() {
        return this.getIntegerPart(INTERNAL_POSITION);
    }

    private int getIntegerPart(Character c) {
        String s = this.mesgParts.get(c);
        if (s == null) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    String getNonSensitiveErrorMessage() {
        StringBuilder totalMessage = new StringBuilder();
        String message = this.mesgParts.get(SEVERITY);
        if (message != null) {
            totalMessage.append(message).append(": ");
        }
        if ((message = this.mesgParts.get(MESSAGE)) != null) {
            totalMessage.append(message);
        }
        return totalMessage.toString();
    }

    public String toString() {
        String position;
        StringBuilder totalMessage = new StringBuilder();
        String message = this.mesgParts.get(SEVERITY);
        if (message != null) {
            totalMessage.append(message).append(": ");
        }
        if ((message = this.mesgParts.get(MESSAGE)) != null) {
            totalMessage.append(message);
        }
        if ((message = this.mesgParts.get(DETAIL)) != null) {
            totalMessage.append("\n  ").append(GT.tr("Detail: {0}", message));
        }
        if ((message = this.mesgParts.get(HINT)) != null) {
            totalMessage.append("\n  ").append(GT.tr("Hint: {0}", message));
        }
        if ((position = this.mesgParts.get(POSITION)) != null) {
            totalMessage.append("\n  ").append(GT.tr("Position: {0}", position));
            String lineNumberMsg = ServerErrorMessage.messageWithLineNumber(this.sql, position, 2);
            if (lineNumberMsg != null) {
                totalMessage.append("\n").append(lineNumberMsg);
            }
        }
        if ((message = this.mesgParts.get(WHERE)) != null) {
            totalMessage.append("\n  ").append(GT.tr("Where: {0}", message));
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            String internalPosition;
            String internalQuery = this.mesgParts.get(INTERNAL_QUERY);
            if (internalQuery != null) {
                totalMessage.append("\n  ").append(GT.tr("Internal Query: {0}", internalQuery));
            }
            if ((internalPosition = this.mesgParts.get(INTERNAL_POSITION)) != null) {
                totalMessage.append("\n  ").append(GT.tr("Internal Position: {0}", internalPosition));
                String internalLineNumberMsg = ServerErrorMessage.messageWithLineNumber(internalQuery, internalPosition, 2);
                if (internalLineNumberMsg != null) {
                    totalMessage.append("\n").append(internalLineNumberMsg);
                }
            }
            String file = this.mesgParts.get(FILE);
            String line = this.mesgParts.get(LINE);
            String routine = this.mesgParts.get(ROUTINE);
            if (file != null || line != null || routine != null) {
                totalMessage.append("\n  ").append(GT.tr("Location: File: {0}, Routine: {1}, Line: {2}", file, routine, line));
            }
            if ((message = this.mesgParts.get(SQLSTATE)) != null) {
                totalMessage.append("\n  ").append(GT.tr("Server SQLState: {0}", message));
            }
        }
        return totalMessage.toString();
    }

    public static String messageWithLineNumber(String query, String position, int leadingSpace) {
        try {
            int loc = Integer.parseInt(position.trim());
            StringBuilder builder = new StringBuilder();
            if (loc < 0 || query == null || query.trim().equals("")) {
                return null;
            }
            for (int i = 0; i < leadingSpace; ++i) {
                builder.append(" ");
            }
            int loc_line = 1;
            int ibeg = 0;
            int iend = -1;
            query = query.replace('\t', ' ');
            int cno = 0;
            for (cno = 0; cno < query.length(); ++cno) {
                char ch = query.charAt(cno);
                if (ch != '\r' && ch != '\n') continue;
                if (cno < loc) {
                    if (ch == '\r' || cno == 0 || query.charAt(cno - 1) != '\r') {
                        ++loc_line;
                    }
                    ibeg = cno + 1;
                    continue;
                }
                iend = cno;
                break;
            }
            if (iend < 0) {
                iend = cno;
            }
            boolean end_trunc = false;
            boolean beg_trunc = false;
            if (iend - ibeg > 60) {
                if (ibeg + 60 >= loc + 10) {
                    while (iend - ibeg > 60) {
                        --iend;
                    }
                    end_trunc = true;
                } else {
                    while (loc + 10 < iend) {
                        --iend;
                        end_trunc = true;
                    }
                    while (iend - ibeg > 60) {
                        ++ibeg;
                        beg_trunc = true;
                    }
                }
            }
            builder.append("Line " + loc_line + ": ");
            if (beg_trunc) {
                builder.append("...");
            }
            StringBuilder errorMarkStr = new StringBuilder();
            int offset = builder.length();
            offset += loc - ibeg;
            for (int i = 0; i < offset - 1; ++i) {
                errorMarkStr.append(" ");
            }
            errorMarkStr.append("^");
            builder.append(query.substring(ibeg, iend));
            if (end_trunc) {
                builder.append("...");
            }
            builder.append("\n");
            builder.append(errorMarkStr.toString());
            return builder.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

