/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.service.impl;

import com.fhs.cache.service.RedisCacheService;
import com.fhs.common.spring.AnnotationTypeFilterBuilder;
import com.fhs.common.spring.SpringClassScanner;
import com.fhs.common.utils.CheckUtils;
import com.fhs.common.utils.ConverterUtils;
import com.fhs.core.trans.anno.AutoTrans;
import com.fhs.core.trans.anno.Trans;
import com.fhs.core.trans.util.ReflectUtils;
import com.fhs.core.trans.vo.VO;
import com.fhs.trans.listener.TransMessageListener;
import com.fhs.trans.service.AutoTransable;
import com.fhs.trans.service.impl.ITransTypeService;
import com.fhs.trans.service.impl.TransFieldSett;
import com.fhs.trans.service.impl.TransService;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;

public class AutoTransService
implements ITransTypeService,
InitializingBean,
ApplicationListener<ApplicationReadyEvent> {
    public static final Logger LOGGER = LoggerFactory.getLogger(AutoTransService.class);
    private Map<String, Map<String, Object>> localTransCacheMap = new HashMap<String, Map<String, Object>>();
    private RedisCacheService<Map<String, Object>> redisTransCache;
    private Map<String, AutoTransable> baseServiceMap = new HashMap<String, AutoTransable>();
    private Map<String, AutoTrans> transSettMap = new ConcurrentHashMap<String, AutoTrans>();
    private ThreadLocal<Map<String, Map<String, Object>>> threadLocalCache = new ThreadLocal();
    private Map<Field, TransFieldSett> transFieldSettMap = new HashMap<Field, TransFieldSett>();

    /*
     * Could not resolve type clashes
     */
    @Override
    public void transOne(VO obj, List<Field> toTransList) {
        Trans tempTrans = null;
        for (Field tempField : toTransList) {
            String pkey;
            TransFieldSett transFieldSett = this.transFieldSettMap.containsKey(tempField) ? this.transFieldSettMap.get(tempField) : new TransFieldSett(tempField);
            tempTrans = transFieldSett.getTrans();
            String namespace = transFieldSett.getNamespace();
            String alias = transFieldSett.getAlias();
            if (this.transSettMap.containsKey(namespace) && CheckUtils.isNullOrEmpty(alias)) {
                alias = this.transSettMap.get(namespace).defaultAlias();
            }
            if (StringUtils.isEmpty((Object)(pkey = ConverterUtils.toString(ReflectUtils.getValue((Object)obj, (String)tempField.getName()))))) continue;
            Map<Object, Object> transCache = null;
            if ((pkey = pkey.replace("[", "").replace("]", "")).contains(",")) {
                String[] pkeys = pkey.split(",");
                transCache = new LinkedHashMap();
                Map<String, Object> tempTransCache = null;
                for (String tempPkey : pkeys) {
                    tempTransCache = this.getTempTransCacheMap(namespace, tempPkey);
                    if (tempTransCache == null || tempTransCache.isEmpty()) {
                        LOGGER.warn("auto trans\u7f13\u5b58\u672a\u547d\u4e2d:" + namespace + "_" + tempPkey);
                        continue;
                    }
                    for (String key : tempTransCache.keySet()) {
                        transCache.put(key, transCache.containsKey(key) ? transCache.get(key) + "," + tempTransCache.get(key) : tempTransCache.get(key));
                    }
                }
            } else {
                transCache = this.getTempTransCacheMap(namespace, ReflectUtils.getValue((Object)obj, (String)tempField.getName()));
                if (transCache == null || transCache.isEmpty()) {
                    LOGGER.warn("auto trans\u7f13\u5b58\u672a\u547d\u4e2d:" + namespace + "_" + pkey);
                    continue;
                }
            }
            this.setRef(tempTrans, obj, transCache);
            Map transMap = obj.getTransMap();
            if (transMap == null) continue;
            if (!CheckUtils.isNullOrEmpty(alias)) {
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                Set<Object> keys = transCache.keySet();
                for (String key : keys) {
                    tempMap.put(alias + key.substring(0, 1).toUpperCase() + key.substring(1), transCache.get(key));
                }
                transCache = tempMap;
            }
            Set<Object> keys = transCache.keySet();
            for (String key : keys) {
                if (!CheckUtils.isNullOrEmpty(transMap.get(key))) continue;
                transMap.put(key, ConverterUtils.toString(transCache.get(key)));
            }
        }
    }

    @Override
    public void transMore(List<? extends VO> objList, List<Field> toTransList) {
        AutoTrans autoTransSett;
        this.threadLocalCache.set(new HashMap());
        HashMap namespaceFieldsGroupMap = new HashMap();
        for (Field tempField : toTransList) {
            tempField.setAccessible(true);
            Trans tempTrans = tempField.getAnnotation(Trans.class);
            String namespace = tempTrans.key();
            if (namespace.contains("#")) {
                namespace = namespace.substring(0, namespace.indexOf("#"));
            }
            if (!this.baseServiceMap.containsKey(namespace)) {
                LOGGER.warn("namesapce\u5bf9\u5e94\u7684service\u6ca1\u6709\u6807\u8bb0autotrans:" + namespace);
                continue;
            }
            autoTransSett = this.transSettMap.get(namespace);
            if (autoTransSett.useCache()) continue;
            List<Field> fields = namespaceFieldsGroupMap.containsKey(namespace) ? (List)namespaceFieldsGroupMap.get(namespace) : new ArrayList();
            fields.add(tempField);
            namespaceFieldsGroupMap.put(namespace, fields);
        }
        for (String namespace : namespaceFieldsGroupMap.keySet()) {
            HashSet<Object> ids = new HashSet<Object>();
            List fields = (List)namespaceFieldsGroupMap.get(namespace);
            objList.forEach(obj -> {
                for (Field field : fields) {
                    try {
                        Object tempId = field.get(obj);
                        if (!CheckUtils.isNotEmpty(tempId)) continue;
                        String pkey = ConverterUtils.toString(tempId).replace("[", "").replace("]", "");
                        if (pkey.contains(",")) {
                            String[] pkeys;
                            for (String id : pkeys = pkey.split(",")) {
                                ids.add(id);
                            }
                            continue;
                        }
                        ids.add(tempId);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            });
            if (ids.isEmpty()) continue;
            if (this.transSettMap.get(namespace).globalCache()) {
                Set<Object> newIds = this.initLocalFromGlobalCache(this.threadLocalCache, ids, namespace, "auto");
                ids.clear();
                ids.addAll(newIds);
            }
            if (ids.isEmpty() || (autoTransSett = this.transSettMap.get(namespace)).useCache()) continue;
            List<? extends VO> dbDatas = this.findByIds(() -> this.baseServiceMap.get(namespace).selectByIds(new ArrayList(ids)), null);
            for (VO vO : dbDatas) {
                this.threadLocalCache.get().put(namespace + "_" + vO.getPkey(), this.createTempTransCacheMap(vO, autoTransSett));
            }
        }
        objList.forEach(obj -> this.transOne((VO)obj, toTransList));
        this.threadLocalCache.set(null);
    }

    public void afterPropertiesSet() throws Exception {
        TransService.registerTransType("auto", this);
        TransMessageListener.regTransRefresher("auto", this::refreshCache);
    }

    public void init(ApplicationReadyEvent event) {
        ConfigurableApplicationContext context = event.getApplicationContext();
        Map beans = context.getBeansWithAnnotation(AutoTrans.class);
        for (Object baseService : beans.values()) {
            if (!(baseService instanceof AutoTransable)) continue;
            Class<?> baseServiceClass = baseService.getClass();
            AutoTrans autoTransSett = AopUtils.isAopProxy(baseService) ? (AutoTrans)AnnotationUtils.findAnnotation(baseServiceClass, AutoTrans.class) : baseServiceClass.getAnnotation(AutoTrans.class);
            this.baseServiceMap.put(autoTransSett.namespace(), (AutoTransable)baseService);
            this.transSettMap.put(autoTransSett.namespace(), autoTransSett);
        }
        new Thread(() -> {
            Thread.currentThread().setName("refresh auto trans cache");
            this.refreshCache(new HashMap<String, Object>());
        }).start();
    }

    public void refreshCache(Map<String, Object> messageMap) {
        String namespace;
        String string = namespace = messageMap.get("namespace") != null ? messageMap.get("namespace").toString() : null;
        if (namespace == null) {
            Set<String> namespaceSet = this.transSettMap.keySet();
            namespaceSet.forEach(temp -> this.refreshOneNamespace((String)temp));
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("\u5237\u65b0\u7f13\u5b58\u9519\u8bef:", (Throwable)e);
            }
            this.refreshOneNamespace(namespace);
        }
    }

    public void refreshOneNamespace(String namespace) {
        if (!this.transSettMap.containsKey(namespace)) {
            LOGGER.info("\u672c\u7cfb\u7edf\u65e0\u9700\u5237\u65b0\u6b64\u7f13\u5b58namespace:" + namespace);
            return;
        }
        AutoTrans autoTrans = this.transSettMap.get(namespace);
        if (!autoTrans.useCache()) {
            return;
        }
        LOGGER.info("\u5f00\u59cb\u5237\u65b0auto-trans\u7f13\u5b58:" + namespace);
        List vos = this.baseServiceMap.get(namespace).select();
        if (vos == null || vos.isEmpty()) {
            return;
        }
        Object pkeyVal = null;
        Object fielVal = null;
        Object tempCacheTransMap = null;
        VO po = null;
        for (int i = 0; i < vos.size(); ++i) {
            po = (VO)vos.get(i);
            pkeyVal = po.getPkey();
            if (autoTrans.useRedis()) {
                this.getRedisTransCache().put(namespace + "_" + pkeyVal, this.createTempTransCacheMap(po, autoTrans));
                continue;
            }
            this.localTransCacheMap.put(namespace + "_" + pkeyVal, this.createTempTransCacheMap(po, autoTrans));
        }
        LOGGER.info("\u5237\u65b0auto-trans\u7f13\u5b58\u5b8c\u6210:" + namespace);
    }

    public RedisCacheService<Map<String, Object>> getRedisTransCache() {
        if (this.redisTransCache == null) {
            throw new IllegalArgumentException("\u8bf7\u786e\u5b9a\u5f00\u542f\u4e86easy-tran.is-enable-redis \u4e3atrue\uff0cspringBoot\u542f\u52a8\u5df2\u7ecf\u5b8c\u6210");
        }
        return this.redisTransCache;
    }

    private Map<String, Object> createTempTransCacheMap(VO po, AutoTrans autoTrans) {
        Object fielVal = null;
        LinkedHashMap<String, Object> tempCacheTransMap = new LinkedHashMap<String, Object>();
        if (po == null) {
            return tempCacheTransMap;
        }
        for (String field : autoTrans.fields()) {
            fielVal = ReflectUtils.getValue((Object)po, (String)field);
            tempCacheTransMap.put(field, fielVal);
        }
        if (autoTrans.globalCache()) {
            this.put2GlobalCache(tempCacheTransMap, autoTrans.isAccess(), autoTrans.cacheSeconds(), autoTrans.maxCache(), po.getPkey(), autoTrans.namespace(), "auto");
        }
        return tempCacheTransMap;
    }

    private Map<String, Object> getTempTransCacheMapSource(String namespace, Object pkey) {
        AutoTrans autoTrans = this.transSettMap.get(namespace);
        if (this.localTransCacheMap.containsKey(namespace + "_" + pkey)) {
            return this.localTransCacheMap.get(namespace + "_" + pkey);
        }
        if (this.transSettMap.get(namespace).globalCache() && this.getFromGlobalCache(pkey, namespace, "auto") != null) {
            return this.getFromGlobalCache(pkey, namespace, "auto");
        }
        if (autoTrans == null || autoTrans.useRedis()) {
            Map<String, Object> redisCacheResult = this.getRedisTransCache().get(namespace + "_" + pkey);
            if (redisCacheResult != null) {
                return redisCacheResult;
            }
            return new HashMap<String, Object>();
        }
        if (autoTrans.useCache()) {
            return new HashMap<String, Object>();
        }
        if (this.threadLocalCache.get() == null) {
            if (CheckUtils.isNullOrEmpty(pkey)) {
                return new HashMap<String, Object>();
            }
            VO vo = this.findById(() -> this.baseServiceMap.get(namespace).selectById(pkey), null);
            return this.createTempTransCacheMap(vo, autoTrans);
        }
        return this.threadLocalCache.get().get(namespace + "_" + pkey);
    }

    private Map<String, Object> getTempTransCacheMap(String namespace, Object pkey) {
        Map<String, Object> transCache = this.getTempTransCacheMapSource(namespace, pkey);
        if (transCache == null || transCache.isEmpty()) {
            return transCache;
        }
        LinkedHashMap<String, Object> transCacheResult = new LinkedHashMap<String, Object>(transCache);
        return transCacheResult;
    }

    public String transKey(String namespace, String pkeyVal) {
        Map<String, Object> tempCacheTransMap = this.localTransCacheMap.get(namespace + "_" + pkeyVal);
        if (tempCacheTransMap == null) {
            LOGGER.error("auto trans\u7f13\u5b58\u672a\u547d\u4e2d:" + namespace + "_" + pkeyVal);
        } else {
            Iterator<String> iterator = tempCacheTransMap.keySet().iterator();
            if (iterator.hasNext()) {
                String key = iterator.next();
                return ConverterUtils.toString(tempCacheTransMap.get(key));
            }
        }
        return null;
    }

    public static Set<Class<?>> scan(Class<? extends Annotation> annotationClass, String[] packageNames) {
        TypeFilter entityFilter = AnnotationTypeFilterBuilder.build(annotationClass);
        SpringClassScanner entityScanner = new SpringClassScanner.Builder().typeFilter(entityFilter).build();
        for (String packageName : packageNames) {
            entityScanner.getScanPackages().add(packageName);
        }
        Set<Class<?>> entitySet = null;
        try {
            entitySet = entityScanner.scan();
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("\u5305\u626b\u63cf\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e);
        }
        return entitySet;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.init(event);
    }

    public void setRedisTransCache(RedisCacheService<Map<String, Object>> redisTransCache) {
        this.redisTransCache = redisTransCache;
    }

    public void regTransable(AutoTransable transAble, AutoTrans autoTransSett) {
        this.baseServiceMap.put(autoTransSett.namespace(), transAble);
        this.transSettMap.put(autoTransSett.namespace(), autoTransSett);
    }
}

