/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.bag.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.bag.MutableBag;

/**
 * This file was automatically generated from template file mutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface MutableShortBag extends MutableShortCollection, ShortBag
{
    void addOccurrences(short item, int occurrences);

    boolean removeOccurrences(short item, int occurrences);

    MutableShortBag select(ShortPredicate predicate);

    MutableShortBag reject(ShortPredicate predicate);

    <V> MutableBag<V> collect(ShortToObjectFunction<? extends V> function);

    MutableShortBag with(short element);

    MutableShortBag without(short element);

    MutableShortBag withAll(ShortIterable elements);

    MutableShortBag withoutAll(ShortIterable elements);

    MutableShortBag asUnmodifiable();

    MutableShortBag asSynchronized();

    /**
     * Returns an immutable copy of this bag.
     */
    ImmutableShortBag toImmutable();
}
