/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import java.util.List;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.list.ListIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.ordered.primitive.ReversibleByteIterable;

/**
 * This file was automatically generated from template file primitiveList.stg.
 *
 * @since 3.0.
 */
public interface ByteList extends ReversibleByteIterable
{
    byte get(int index);

    long dotProduct(ByteList list);

    int lastIndexOf(byte value);

    ByteList select(BytePredicate predicate);

    ByteList reject(BytePredicate predicate);

    <V> ListIterable<V> collect(ByteToObjectFunction<? extends V> function);

    /**
     * Follows the same general contract as {@link List#equals(Object)}.
     */
    @Override
    boolean equals(Object o);

    /**
     * Follows the same general contract as {@link List#hashCode()}.
     */
    @Override
    int hashCode();

    /**
     * Returns an immutable copy of this list. If the list is immutable, it returns itself.
     */
    ImmutableByteList toImmutable();

    /**
     * @since 5.0.
     */
    ByteList toReversed();

    /**
     * @see {@link List#subList(int fromIndex, int toIndex)}
     * @since 5.0.
     */
    ByteList subList(int fromIndex, int toIndex);
}
