/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.predicate.primitive.ByteBytePredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableByteByteMap extends ByteByteMap
{
    void clear();

    void put(byte key, byte value);

    void putAll(ByteByteMap map);

    void removeKey(byte key);

    void remove(byte key);

    byte removeKeyIfAbsent(byte key, byte value);

    byte getIfAbsentPut(byte key, byte value);

    byte getIfAbsentPut(byte key, ByteFunction0 function);

    byte getIfAbsentPutWithKey(byte key, ByteToByteFunction function);

    <P> byte getIfAbsentPutWith(byte key, ByteFunction<? super P> function, P parameter);

    byte updateValue(byte key, byte initialValueIfAbsent, ByteToByteFunction function);

    MutableByteByteMap select(ByteBytePredicate predicate);

    MutableByteByteMap reject(ByteBytePredicate predicate);

    MutableByteCollection select(BytePredicate predicate);

    MutableByteCollection reject(BytePredicate predicate);

    <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function);

    MutableByteByteMap withKeyValue(byte key, byte value);

    MutableByteByteMap withoutKey(byte key);

    MutableByteByteMap withoutAllKeys(ByteIterable keys);

    MutableByteByteMap asUnmodifiable();

    MutableByteByteMap asSynchronized();

    byte addToValue(byte key, byte toBeAdded);
}
