/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.function.primitive.CharToLongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.predicate.primitive.CharLongPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableCharLongMap extends CharLongMap
{
    void clear();

    void put(char key, long value);

    void putAll(CharLongMap map);

    void removeKey(char key);

    void remove(char key);

    long removeKeyIfAbsent(char key, long value);

    long getIfAbsentPut(char key, long value);

    long getIfAbsentPut(char key, LongFunction0 function);

    long getIfAbsentPutWithKey(char key, CharToLongFunction function);

    <P> long getIfAbsentPutWith(char key, LongFunction<? super P> function, P parameter);

    long updateValue(char key, long initialValueIfAbsent, LongToLongFunction function);

    MutableCharLongMap select(CharLongPredicate predicate);

    MutableCharLongMap reject(CharLongPredicate predicate);

    MutableLongCollection select(LongPredicate predicate);

    MutableLongCollection reject(LongPredicate predicate);

    <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function);

    MutableCharLongMap withKeyValue(char key, long value);

    MutableCharLongMap withoutKey(char key);

    MutableCharLongMap withoutAllKeys(CharIterable keys);

    MutableCharLongMap asUnmodifiable();

    MutableCharLongMap asSynchronized();

    long addToValue(char key, long toBeAdded);
}
