/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.function.primitive.DoubleToIntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleIntPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableDoubleIntMap extends DoubleIntMap
{
    void clear();

    void put(double key, int value);

    void putAll(DoubleIntMap map);

    void removeKey(double key);

    void remove(double key);

    int removeKeyIfAbsent(double key, int value);

    int getIfAbsentPut(double key, int value);

    int getIfAbsentPut(double key, IntFunction0 function);

    int getIfAbsentPutWithKey(double key, DoubleToIntFunction function);

    <P> int getIfAbsentPutWith(double key, IntFunction<? super P> function, P parameter);

    int updateValue(double key, int initialValueIfAbsent, IntToIntFunction function);

    MutableDoubleIntMap select(DoubleIntPredicate predicate);

    MutableDoubleIntMap reject(DoubleIntPredicate predicate);

    MutableIntCollection select(IntPredicate predicate);

    MutableIntCollection reject(IntPredicate predicate);

    <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function);

    MutableDoubleIntMap withKeyValue(double key, int value);

    MutableDoubleIntMap withoutKey(double key);

    MutableDoubleIntMap withoutAllKeys(DoubleIterable keys);

    MutableDoubleIntMap asUnmodifiable();

    MutableDoubleIntMap asSynchronized();

    int addToValue(double key, int toBeAdded);
}
