/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.function.primitive.LongToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.predicate.primitive.LongFloatPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableLongFloatMap extends LongFloatMap
{
    void clear();

    void put(long key, float value);

    void putAll(LongFloatMap map);

    void removeKey(long key);

    void remove(long key);

    float removeKeyIfAbsent(long key, float value);

    float getIfAbsentPut(long key, float value);

    float getIfAbsentPut(long key, FloatFunction0 function);

    float getIfAbsentPutWithKey(long key, LongToFloatFunction function);

    <P> float getIfAbsentPutWith(long key, FloatFunction<? super P> function, P parameter);

    float updateValue(long key, float initialValueIfAbsent, FloatToFloatFunction function);

    MutableLongFloatMap select(LongFloatPredicate predicate);

    MutableLongFloatMap reject(LongFloatPredicate predicate);

    MutableFloatCollection select(FloatPredicate predicate);

    MutableFloatCollection reject(FloatPredicate predicate);

    <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function);

    MutableLongFloatMap withKeyValue(long key, float value);

    MutableLongFloatMap withoutKey(long key);

    MutableLongFloatMap withoutAllKeys(LongIterable keys);

    MutableLongFloatMap asUnmodifiable();

    MutableLongFloatMap asSynchronized();

    float addToValue(long key, float toBeAdded);
}
