/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectFloatPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;

/**
 * This file was automatically generated from template file mutableObjectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableObjectFloatMap<K> extends ObjectFloatMap<K>
{
    void clear();

    void put(K key, float value);

    void putAll(ObjectFloatMap<? extends K> map);

    void removeKey(K key);

    void remove(Object key);

    float removeKeyIfAbsent(K key, float value);

    float getIfAbsentPut(K key, float value);

    float getIfAbsentPut(K key, FloatFunction0 function);

    float getIfAbsentPutWithKey(K key, FloatFunction<? super K> function);

    <P> float getIfAbsentPutWith(K key, FloatFunction<? super P> function, P parameter);

    float updateValue(K key, float initialValueIfAbsent, FloatToFloatFunction function);

    MutableObjectFloatMap<K> select(ObjectFloatPredicate<? super K> predicate);

    MutableObjectFloatMap<K> reject(ObjectFloatPredicate<? super K> predicate);

    MutableFloatCollection select(FloatPredicate predicate);

    MutableFloatCollection reject(FloatPredicate predicate);

    <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function);

    MutableObjectFloatMap<K> withKeyValue(K key, float value);

    MutableObjectFloatMap<K> withoutKey(K key);

    MutableObjectFloatMap<K> withoutAllKeys(Iterable<? extends K> keys);

    MutableObjectFloatMap<K> asUnmodifiable();

    MutableObjectFloatMap<K> asSynchronized();

    float addToValue(K key, float toBeAdded);
}
