/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.FormattingError;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import java.io.IOError;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openjdk.javax.tools.DiagnosticCollector;
import org.openjdk.javax.tools.DiagnosticListener;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.javax.tools.SimpleJavaFileObject;
import org.openjdk.javax.tools.StandardLocation;
import org.openjdk.source.doctree.DocCommentTree;
import org.openjdk.source.doctree.IdentifierTree;
import org.openjdk.source.doctree.ReferenceTree;
import org.openjdk.source.tree.ImportTree;
import org.openjdk.source.tree.Tree;
import org.openjdk.source.util.DocTreePath;
import org.openjdk.source.util.DocTreePathScanner;
import org.openjdk.source.util.TreePathScanner;
import org.openjdk.source.util.TreeScanner;
import org.openjdk.tools.javac.api.JavacTrees;
import org.openjdk.tools.javac.file.JavacFileManager;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.parser.JavacParser;
import org.openjdk.tools.javac.parser.ParserFactory;
import org.openjdk.tools.javac.tree.DCTree;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Options;

public class RemoveUnusedImports {
    public static String removeUnusedImports(String contents, JavadocOnlyImports javadocOnlyImports) {
        Context context = new Context();
        Options.instance((Context)context).put(Option.SOURCE, "9");
        JCTree.JCCompilationUnit unit = RemoveUnusedImports.parse(context, contents);
        if (unit == null) {
            return contents;
        }
        UnusedImportScanner scanner = new UnusedImportScanner(JavacTrees.instance((Context)context));
        scanner.scan((Tree)unit, null);
        return RemoveUnusedImports.applyReplacements(contents, RemoveUnusedImports.buildReplacements(contents, unit, scanner.usedNames, (Multimap<String, Range<Integer>>)scanner.usedInJavadoc, javadocOnlyImports));
    }

    private static JCTree.JCCompilationUnit parse(Context context, final String javaInput) {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        context.put(DiagnosticListener.class, (Object)diagnostics);
        Options.instance((Context)context).put("allowStringFolding", "false");
        JavacFileManager fileManager = new JavacFileManager(context, true, StandardCharsets.UTF_8);
        try {
            fileManager.setLocation((JavaFileManager.Location)StandardLocation.PLATFORM_CLASS_PATH, (Iterable)ImmutableList.of());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SimpleJavaFileObject source = new SimpleJavaFileObject(URI.create("source"), JavaFileObject.Kind.SOURCE){

            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return javaInput;
            }
        };
        Log.instance((Context)context).useSource((JavaFileObject)source);
        ParserFactory parserFactory = ParserFactory.instance((Context)context);
        JavacParser parser = parserFactory.newParser((CharSequence)javaInput, true, true, true);
        JCTree.JCCompilationUnit unit = parser.parseCompilationUnit();
        unit.sourcefile = source;
        Iterable errorDiagnostics = Iterables.filter((Iterable)diagnostics.getDiagnostics(), Formatter.ERROR_DIAGNOSTIC);
        if (!Iterables.isEmpty((Iterable)errorDiagnostics)) {
            throw FormattingError.fromJavacDiagnostics(errorDiagnostics);
        }
        return unit;
    }

    private static RangeMap<Integer, String> buildReplacements(String contents, JCTree.JCCompilationUnit unit, Set<String> usedNames, Multimap<String, Range<Integer>> usedInJavadoc, JavadocOnlyImports javadocOnlyImports) {
        TreeRangeMap replacements = TreeRangeMap.create();
        for (JCTree.JCImport importTree : unit.getImports()) {
            String sep;
            String simpleName;
            if (!RemoveUnusedImports.isUnused(unit, usedNames, usedInJavadoc, javadocOnlyImports, importTree, simpleName = RemoveUnusedImports.getSimpleName(importTree))) continue;
            int endPosition = importTree.getEndPosition(unit.endPositions);
            endPosition = Math.max(CharMatcher.isNot((char)' ').indexIn((CharSequence)contents, endPosition), endPosition);
            if (endPosition + (sep = Newlines.guessLineSeparator(contents)).length() < contents.length() && contents.subSequence(endPosition, endPosition + sep.length()).equals(sep)) {
                endPosition += sep.length();
            }
            replacements.put(Range.closedOpen((Comparable)Integer.valueOf(importTree.getStartPosition()), (Comparable)Integer.valueOf(endPosition)), (Object)"");
            if (importTree.isStatic()) continue;
            for (Range docRange : usedInJavadoc.get((Object)simpleName)) {
                if (docRange == null) continue;
                String replaceWith = importTree.getQualifiedIdentifier().toString();
                replacements.put(docRange, (Object)replaceWith);
            }
        }
        return replacements;
    }

    private static String getSimpleName(JCTree.JCImport importTree) {
        return importTree.getQualifiedIdentifier() instanceof JCTree.JCIdent ? ((JCTree.JCIdent)importTree.getQualifiedIdentifier()).getName().toString() : ((JCTree.JCFieldAccess)importTree.getQualifiedIdentifier()).getIdentifier().toString();
    }

    private static boolean isUnused(JCTree.JCCompilationUnit unit, Set<String> usedNames, Multimap<String, Range<Integer>> usedInJavadoc, JavadocOnlyImports javadocOnlyImports, JCTree.JCImport importTree, String simpleName) {
        String qualifier;
        String string = qualifier = importTree.getQualifiedIdentifier() instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)importTree.getQualifiedIdentifier()).getExpression().toString() : null;
        if (qualifier.equals("java.lang")) {
            return true;
        }
        if (unit.getPackageName() != null && unit.getPackageName().toString().equals(qualifier)) {
            return true;
        }
        if (importTree.getQualifiedIdentifier() instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)importTree.getQualifiedIdentifier()).getIdentifier().contentEquals((CharSequence)"*")) {
            return false;
        }
        if (usedNames.contains(simpleName)) {
            return false;
        }
        return !usedInJavadoc.containsKey((Object)simpleName) || javadocOnlyImports != JavadocOnlyImports.KEEP;
    }

    private static String applyReplacements(String source, RangeMap<Integer, String> replacements) {
        TreeRangeSet fixedRanges = TreeRangeSet.create();
        StringBuilder sb = new StringBuilder(source);
        int offset = 0;
        for (Map.Entry replacement : replacements.asMapOfRanges().entrySet()) {
            Range range = (Range)replacement.getKey();
            String replaceWith = (String)replacement.getValue();
            int start = offset + (Integer)range.lowerEndpoint();
            int end = offset + (Integer)range.upperEndpoint();
            sb.replace(start, end, replaceWith);
            if (!replaceWith.isEmpty()) {
                fixedRanges.add(Range.closedOpen((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)));
            }
            offset += replaceWith.length() - ((Integer)range.upperEndpoint() - (Integer)range.lowerEndpoint());
        }
        String result = sb.toString();
        if (!fixedRanges.isEmpty()) {
            try {
                result = new Formatter().formatSource(result, fixedRanges.asRanges());
            }
            catch (FormatterException formatterException) {
                // empty catch block
            }
        }
        return result;
    }

    private static class UnusedImportScanner
    extends TreePathScanner<Void, Void> {
        private final Set<String> usedNames = new LinkedHashSet<String>();
        private final Multimap<String, Range<Integer>> usedInJavadoc = HashMultimap.create();
        final JavacTrees trees;
        final DocTreeScanner docTreeSymbolScanner;

        private UnusedImportScanner(JavacTrees trees) {
            this.trees = trees;
            this.docTreeSymbolScanner = new DocTreeScanner();
        }

        public Void visitImport(ImportTree importTree, Void usedSymbols) {
            return null;
        }

        public Void visitIdentifier(org.openjdk.source.tree.IdentifierTree tree, Void unused) {
            if (tree == null) {
                return null;
            }
            this.usedNames.add(tree.getName().toString());
            return null;
        }

        public Void scan(Tree tree, Void unused) {
            if (tree == null) {
                return null;
            }
            this.scanJavadoc();
            return (Void)super.scan(tree, (Object)unused);
        }

        private void scanJavadoc() {
            if (this.getCurrentPath() == null) {
                return;
            }
            DocCommentTree commentTree = this.trees.getDocCommentTree(this.getCurrentPath());
            if (commentTree == null) {
                return;
            }
            this.docTreeSymbolScanner.scan(new DocTreePath(this.getCurrentPath(), commentTree), null);
        }

        class DocTreeScanner
        extends DocTreePathScanner<Void, Void> {
            DocTreeScanner() {
            }

            public Void visitIdentifier(IdentifierTree node, Void aVoid) {
                return null;
            }

            public Void visitReference(ReferenceTree referenceTree, Void unused) {
                DCTree.DCReference reference = (DCTree.DCReference)referenceTree;
                long basePos = reference.getSourcePosition((DCTree.DCDocComment)this.getCurrentPath().getDocComment());
                if (reference.qualifierExpression != null) {
                    new ReferenceScanner(basePos).scan((Tree)reference.qualifierExpression, null);
                }
                if (reference.paramTypes != null) {
                    for (JCTree param : reference.paramTypes) {
                        new ReferenceScanner(-1L).scan((Tree)param, null);
                    }
                }
                return null;
            }

            private class ReferenceScanner
            extends TreeScanner<Void, Void> {
                private final long basePos;

                public ReferenceScanner(long basePos) {
                    this.basePos = basePos;
                }

                public Void visitIdentifier(org.openjdk.source.tree.IdentifierTree node, Void aVoid) {
                    UnusedImportScanner.this.usedInJavadoc.put((Object)node.getName().toString(), this.basePos != -1L ? Range.closedOpen((Comparable)Integer.valueOf((int)this.basePos), (Comparable)Integer.valueOf((int)this.basePos + node.getName().length())) : null);
                    return (Void)super.visitIdentifier(node, (Object)aVoid);
                }
            }
        }
    }

    public static enum JavadocOnlyImports {
        REMOVE,
        KEEP;

    }
}

