/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca.core;

import com.googlecode.jsendnsca.core.INagiosPassiveCheckSender;
import com.googlecode.jsendnsca.core.MessagePayload;
import com.googlecode.jsendnsca.core.NagiosException;
import com.googlecode.jsendnsca.core.NagiosSettings;
import com.googlecode.jsendnsca.core.PassiveCheckBytesBuilder;
import com.googlecode.jsendnsca.core.utils.IOUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class NagiosPassiveCheckSender
implements INagiosPassiveCheckSender {
    private static final int INITIALISATION_VECTOR_SIZE = 128;
    private NagiosSettings nagiosSettings;

    public NagiosPassiveCheckSender(NagiosSettings nagiosSettings) {
        if (nagiosSettings == null) {
            throw new IllegalArgumentException("nagiosSettings cannot be null");
        }
        this.nagiosSettings = nagiosSettings;
    }

    @Override
    public void send(MessagePayload payload) throws NagiosException, IOException {
        if (payload == null) {
            throw new IllegalArgumentException("payload cannot be null");
        }
        Socket socket = new Socket();
        InetSocketAddress nagiosEndpoint = new InetSocketAddress(this.nagiosSettings.getNagiosHost(), this.nagiosSettings.getPort());
        OutputStream outputStream = null;
        DataInputStream inputStream = null;
        socket.connect(nagiosEndpoint, this.nagiosSettings.getConnectTimeout());
        socket.setSoTimeout(this.nagiosSettings.getTimeout());
        outputStream = socket.getOutputStream();
        inputStream = new DataInputStream(socket.getInputStream());
        byte[] initVector = this.readInitializationVector(inputStream);
        int timeStamp = inputStream.readInt();
        try {
            byte[] passiveCheckBytes = new PassiveCheckBytesBuilder().withTimeStamp(timeStamp).withLevel(payload.getLevel()).withHostname(payload.getHostname()).withServiceName(payload.getServiceName()).withMessage(payload.getMessage()).writeCRC().encrypt(initVector, this.nagiosSettings).toByteArray();
            outputStream.write(passiveCheckBytes, 0, passiveCheckBytes.length);
            outputStream.flush();
        }
        catch (SocketTimeoutException ste) {
            throw ste;
        }
        catch (Exception e) {
            throw new NagiosException("Error occurred while sending passive alert", e);
        }
        finally {
            IOUtils.closeQuietly(outputStream);
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(socket);
        }
    }

    private byte[] readInitializationVector(DataInputStream inputStream) throws NagiosException, SocketTimeoutException {
        byte[] initVector = new byte[128];
        try {
            inputStream.readFully(initVector, 0, 128);
            return initVector;
        }
        catch (SocketTimeoutException ste) {
            throw ste;
        }
        catch (Exception e) {
            throw new NagiosException("Can't read initialisation vector", e);
        }
    }
}

