/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca.core;

import com.googlecode.jsendnsca.core.Encryptor;
import com.googlecode.jsendnsca.core.utils.StringUtils;

class XorEncryptor
implements Encryptor {
    XorEncryptor() {
    }

    @Override
    public void encrypt(byte[] passiveCheckBytes, byte[] initVector, String password) {
        int y = 0;
        int x = 0;
        while (y < passiveCheckBytes.length) {
            if (x >= 128) {
                x = 0;
            }
            int n = y++;
            passiveCheckBytes[n] = (byte)(passiveCheckBytes[n] ^ initVector[x]);
            ++x;
        }
        if (StringUtils.isNotBlank(password)) {
            byte[] passwordBytes = password.getBytes();
            int y2 = 0;
            int x2 = 0;
            while (y2 < passiveCheckBytes.length) {
                if (x2 >= passwordBytes.length) {
                    x2 = 0;
                }
                int n = y2++;
                passiveCheckBytes[n] = (byte)(passiveCheckBytes[n] ^ passwordBytes[x2]);
                ++x2;
            }
        }
    }
}

