/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca.core.builders;

import com.googlecode.jsendnsca.core.Level;
import com.googlecode.jsendnsca.core.MessagePayload;
import java.net.UnknownHostException;

public class MessagePayloadBuilder {
    private MessagePayload payload = new MessagePayload();

    public MessagePayload create() {
        return this.payload;
    }

    public MessagePayloadBuilder withLocalHostname() throws UnknownHostException {
        this.payload.useLocalHostname();
        return this;
    }

    public MessagePayloadBuilder withCanonicalHostname() throws UnknownHostException {
        this.payload.setHostname(true);
        return this;
    }

    public MessagePayloadBuilder withHostname(String hostname) {
        this.payload.setHostname(hostname);
        return this;
    }

    public MessagePayloadBuilder withLevel(int level) {
        this.payload.setLevel(level);
        return this;
    }

    public MessagePayloadBuilder withLevel(String level) {
        this.payload.setLevel(level);
        return this;
    }

    public MessagePayloadBuilder withLevel(Level level) {
        this.payload.setLevel(level);
        return this;
    }

    public MessagePayloadBuilder withServiceName(String serviceName) {
        this.payload.setServiceName(serviceName);
        return this;
    }

    public MessagePayloadBuilder withMessage(String message) {
        this.payload.setMessage(message);
        return this;
    }
}

