/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxParsingException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxUnexpectedCharException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.SystemId;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public abstract class InputBootstrapper {
    protected static final String ERR_XMLDECL_KW_VERSION = "; expected keyword 'version'";
    protected static final String ERR_XMLDECL_KW_ENCODING = "; expected keyword 'encoding'";
    protected static final String ERR_XMLDECL_KW_STANDALONE = "; expected keyword 'standalone'";
    protected static final String ERR_XMLDECL_END_MARKER = "; expected \"?>\" end marker";
    protected static final String ERR_XMLDECL_EXP_SPACE = "; expected a white space";
    protected static final String ERR_XMLDECL_EXP_EQ = "; expected '=' after ";
    protected static final String ERR_XMLDECL_EXP_ATTRVAL = "; expected a quote character enclosing value for ";
    public static final char CHAR_NULL = '\u0000';
    public static final char CHAR_SPACE = ' ';
    public static final char CHAR_NEL = '\u0085';
    public static final byte CHAR_CR = 13;
    public static final byte CHAR_LF = 10;
    public static final byte BYTE_NULL = 0;
    public static final byte BYTE_CR = 13;
    public static final byte BYTE_LF = 10;
    protected final String mPublicId;
    protected final SystemId mSystemId;
    protected int mInputProcessed = 0;
    protected int mInputRow = 1;
    protected int mInputRowStart = 0;
    protected int mDeclaredXmlVersion = 0;
    protected String mFoundEncoding;
    protected String mStandalone;
    protected boolean mXml11Handling = false;
    protected final char[] mKeywordBuffer = new char[60];

    protected InputBootstrapper(String string, SystemId systemId) {
        this.mPublicId = string;
        this.mSystemId = systemId;
    }

    protected void initFrom(InputBootstrapper inputBootstrapper) {
        this.mInputProcessed = inputBootstrapper.mInputProcessed;
        this.mInputRow = inputBootstrapper.mInputRow;
        this.mInputRowStart = inputBootstrapper.mInputRowStart;
        this.mDeclaredXmlVersion = inputBootstrapper.mDeclaredXmlVersion;
        this.mFoundEncoding = inputBootstrapper.mFoundEncoding;
        this.mStandalone = inputBootstrapper.mStandalone;
        this.mXml11Handling = inputBootstrapper.mXml11Handling;
    }

    public abstract Reader bootstrapInput(ReaderConfig var1, boolean var2, int var3) throws IOException, XMLStreamException;

    public String getPublicId() {
        return this.mPublicId;
    }

    public SystemId getSystemId() {
        return this.mSystemId;
    }

    public int getDeclaredVersion() {
        return this.mDeclaredXmlVersion;
    }

    public boolean declaredXml11() {
        return this.mDeclaredXmlVersion == 272;
    }

    public String getStandalone() {
        return this.mStandalone;
    }

    public String getDeclaredEncoding() {
        return this.mFoundEncoding;
    }

    public abstract int getInputTotal();

    public int getInputRow() {
        return this.mInputRow;
    }

    public abstract int getInputColumn();

    public abstract String getInputEncoding();

    protected void readXmlDecl(boolean bl2, int n2) throws IOException, WstxException {
        boolean bl3;
        int n3 = this.getNextAfterWs(false);
        if (n3 != 118) {
            if (bl2) {
                this.reportUnexpectedChar(n3, ERR_XMLDECL_KW_VERSION);
            }
        } else {
            this.mDeclaredXmlVersion = this.readXmlVersion();
            n3 = this.getWsOrChar(63);
        }
        boolean bl4 = bl3 = this.mDeclaredXmlVersion == 272;
        if (n2 != 0) {
            boolean bl5 = this.mXml11Handling = 272 == n2;
            if (bl3 && !this.mXml11Handling) {
                this.reportXmlProblem(ErrorConsts.ERR_XML_10_VS_11);
            }
        } else {
            this.mXml11Handling = bl3;
        }
        if (n3 != 101) {
            if (!bl2) {
                this.reportUnexpectedChar(n3, ERR_XMLDECL_KW_ENCODING);
            }
        } else {
            this.mFoundEncoding = this.readXmlEncoding();
            n3 = this.getWsOrChar(63);
        }
        if (bl2 && n3 == 115) {
            this.mStandalone = this.readXmlStandalone();
            n3 = this.getWsOrChar(63);
        }
        if (n3 != 63) {
            this.reportUnexpectedChar(n3, ERR_XMLDECL_END_MARKER);
        }
        if ((n3 = this.getNext()) != 62) {
            this.reportUnexpectedChar(n3, ERR_XMLDECL_END_MARKER);
        }
    }

    private final int readXmlVersion() throws IOException, WstxException {
        int n2;
        int n3 = this.checkKeyword("version");
        if (n3 != 0) {
            this.reportUnexpectedChar(n3, "version");
        }
        if ((n2 = this.readQuotedValue(this.mKeywordBuffer, n3 = this.handleEq("version"))) == 3 && this.mKeywordBuffer[0] == '1' && this.mKeywordBuffer[1] == '.') {
            n3 = this.mKeywordBuffer[2];
            if (n3 == 48) {
                return 256;
            }
            if (n3 == 49) {
                return 272;
            }
        }
        String string = n2 < 0 ? "'" + new String(this.mKeywordBuffer) + "[..]'" : (n2 == 0 ? "<empty>" : "'" + new String(this.mKeywordBuffer, 0, n2) + "'");
        this.reportPseudoAttrProblem("version", string, "1.0", "1.1");
        return 0;
    }

    private final String readXmlEncoding() throws IOException, WstxException {
        int n2;
        int n3 = this.checkKeyword("encoding");
        if (n3 != 0) {
            this.reportUnexpectedChar(n3, "encoding");
        }
        if ((n2 = this.readQuotedValue(this.mKeywordBuffer, n3 = this.handleEq("encoding"))) == 0) {
            this.reportPseudoAttrProblem("encoding", null, null, null);
        }
        if (n2 < 0) {
            return new String(this.mKeywordBuffer);
        }
        return new String(this.mKeywordBuffer, 0, n2);
    }

    private final String readXmlStandalone() throws IOException, WstxException {
        int n2;
        int n3 = this.checkKeyword("standalone");
        if (n3 != 0) {
            this.reportUnexpectedChar(n3, "standalone");
        }
        if ((n2 = this.readQuotedValue(this.mKeywordBuffer, n3 = this.handleEq("standalone"))) == 2) {
            if (this.mKeywordBuffer[0] == 'n' && this.mKeywordBuffer[1] == 'o') {
                return "no";
            }
        } else if (n2 == 3 && this.mKeywordBuffer[0] == 'y' && this.mKeywordBuffer[1] == 'e' && this.mKeywordBuffer[2] == 's') {
            return "yes";
        }
        String string = n2 < 0 ? "'" + new String(this.mKeywordBuffer) + "[..]'" : (n2 == 0 ? "<empty>" : "'" + new String(this.mKeywordBuffer, 0, n2) + "'");
        this.reportPseudoAttrProblem("standalone", string, "yes", "no");
        return string;
    }

    private final int handleEq(String string) throws IOException, WstxException {
        int n2 = this.getNextAfterWs(false);
        if (n2 != 61) {
            this.reportUnexpectedChar(n2, "; expected '=' after '" + string + "'");
        }
        if ((n2 = this.getNextAfterWs(false)) != 34 && n2 != 39) {
            this.reportUnexpectedChar(n2, "; expected a quote character enclosing value for '" + string + "'");
        }
        return n2;
    }

    private final int getWsOrChar(int n2) throws IOException, WstxException {
        int n3 = this.getNext();
        if (n3 == n2) {
            return n3;
        }
        if (n3 > 32) {
            this.reportUnexpectedChar(n3, "; expected either '" + (char)n2 + "' or white space");
        }
        if (n3 == 10 || n3 == 13) {
            this.pushback();
        }
        return this.getNextAfterWs(false);
    }

    protected abstract void pushback();

    protected abstract int getNext() throws IOException, WstxException;

    protected abstract int getNextAfterWs(boolean var1) throws IOException, WstxException;

    protected abstract int checkKeyword(String var1) throws IOException, WstxException;

    protected abstract int readQuotedValue(char[] var1, int var2) throws IOException, WstxException;

    protected abstract Location getLocation();

    protected void reportNull() throws WstxException {
        throw new WstxException("Illegal null byte in input stream", this.getLocation());
    }

    protected void reportXmlProblem(String string) throws WstxException {
        throw new WstxParsingException(string, this.getLocation());
    }

    protected void reportUnexpectedChar(int n2, String string) throws WstxException {
        char c2 = (char)n2;
        String string2 = Character.isISOControl(c2) ? "Unexpected character (CTRL-CHAR, code " + n2 + ")" + string : "Unexpected character '" + c2 + "' (code " + n2 + ")" + string;
        Location location = this.getLocation();
        throw new WstxUnexpectedCharException(string2, location, c2);
    }

    private final void reportPseudoAttrProblem(String string, String string2, String string3, String string4) throws WstxException {
        String string5;
        String string6 = string5 = string3 == null ? "" : "; expected \"" + string3 + "\" or \"" + string4 + "\"";
        if (string2 == null || string2.length() == 0) {
            throw new WstxParsingException("Missing XML pseudo-attribute '" + string + "' value" + string5, this.getLocation());
        }
        throw new WstxParsingException("Invalid XML pseudo-attribute '" + string + "' value " + string2 + string5, this.getLocation());
    }
}

