/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.osgi;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ValidatorConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDSchemaFactory;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.msv.RelaxNGSchemaFactory;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.msv.W3CSchemaFactory;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.osgi.Stax2ValidationSchemaFactoryProvider;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidationSchemaFactory;
import java.util.Properties;

public abstract class ValidationSchemaFactoryProviderImpl
implements Stax2ValidationSchemaFactoryProvider {
    final String mSchemaType;

    protected ValidationSchemaFactoryProviderImpl(String string) {
        this.mSchemaType = string;
    }

    public static ValidationSchemaFactoryProviderImpl[] createAll() {
        return new ValidationSchemaFactoryProviderImpl[]{new DTD(), new RelaxNG(), new W3CSchema()};
    }

    @Override
    public abstract XMLValidationSchemaFactory createValidationSchemaFactory();

    @Override
    public String getSchemaType() {
        return this.mSchemaType;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("com.gradle.maven.extension.internal.dep.org.codehaus.stax2.implName", ValidatorConfig.getImplName());
        properties.setProperty("com.gradle.maven.extension.internal.dep.org.codehaus.stax2.implVersion", ValidatorConfig.getImplVersion());
        properties.setProperty("com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.schemaType", this.mSchemaType);
        return properties;
    }

    static final class W3CSchema
    extends ValidationSchemaFactoryProviderImpl {
        W3CSchema() {
            super("http://www.w3.org/2001/XMLSchema");
        }

        @Override
        public XMLValidationSchemaFactory createValidationSchemaFactory() {
            return new W3CSchemaFactory();
        }
    }

    static final class RelaxNG
    extends ValidationSchemaFactoryProviderImpl {
        RelaxNG() {
            super("http://relaxng.org/ns/structure/0.9");
        }

        @Override
        public XMLValidationSchemaFactory createValidationSchemaFactory() {
            return new RelaxNGSchemaFactory();
        }
    }

    static final class DTD
    extends ValidationSchemaFactoryProviderImpl {
        DTD() {
            super("http://www.w3.org/XML/1998/namespace");
        }

        @Override
        public XMLValidationSchemaFactory createValidationSchemaFactory() {
            return new DTDSchemaFactory();
        }
    }
}

