/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.ssl;

import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.ConscryptAlpnSslEngine;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;

final class Conscrypt {
    private static final Method IS_CONSCRYPT_SSLENGINE;

    static boolean isAvailable() {
        return IS_CONSCRYPT_SSLENGINE != null;
    }

    static boolean isEngineSupported(SSLEngine sSLEngine) {
        try {
            return IS_CONSCRYPT_SSLENGINE != null && (Boolean)IS_CONSCRYPT_SSLENGINE.invoke(null, sSLEngine) != false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    static {
        Method method = null;
        if (PlatformDependent.javaVersion() >= 8 && PlatformDependent.javaVersion() < 15 || PlatformDependent.isAndroid()) {
            try {
                Class<?> clazz = Class.forName("org.conscrypt.OpenSSLProvider", true, PlatformDependent.getClassLoader(ConscryptAlpnSslEngine.class));
                clazz.newInstance();
                Class<?> clazz2 = Class.forName("org.conscrypt.Conscrypt", true, PlatformDependent.getClassLoader(ConscryptAlpnSslEngine.class));
                method = clazz2.getMethod("isConscrypt", SSLEngine.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        IS_CONSCRYPT_SSLENGINE = method;
    }
}

