/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.ssl;

import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslKeyMaterial;
import com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.SSL;
import com.gradle.maven.extension.internal.dep.io.netty.util.AbstractReferenceCounted;
import com.gradle.maven.extension.internal.dep.io.netty.util.ResourceLeakDetector;
import com.gradle.maven.extension.internal.dep.io.netty.util.ResourceLeakDetectorFactory;
import com.gradle.maven.extension.internal.dep.io.netty.util.ResourceLeakTracker;
import java.security.cert.X509Certificate;

final class DefaultOpenSslKeyMaterial
extends AbstractReferenceCounted
implements OpenSslKeyMaterial {
    private static final ResourceLeakDetector<DefaultOpenSslKeyMaterial> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(DefaultOpenSslKeyMaterial.class);
    private final ResourceLeakTracker<DefaultOpenSslKeyMaterial> leak;
    private final X509Certificate[] x509CertificateChain;
    private long chain;
    private long privateKey;

    DefaultOpenSslKeyMaterial(long l2, long l3, X509Certificate[] x509CertificateArray) {
        this.chain = l2;
        this.privateKey = l3;
        this.x509CertificateChain = x509CertificateArray;
        this.leak = leakDetector.track(this);
    }

    @Override
    protected void deallocate() {
        SSL.freeX509Chain((long)this.chain);
        this.chain = 0L;
        SSL.freePrivateKey((long)this.privateKey);
        this.privateKey = 0L;
        if (this.leak != null) {
            boolean bl2 = this.leak.close(this);
            assert (bl2);
        }
    }

    @Override
    public DefaultOpenSslKeyMaterial retain() {
        if (this.leak != null) {
            this.leak.record();
        }
        super.retain();
        return this;
    }

    @Override
    public DefaultOpenSslKeyMaterial touch(Object object) {
        if (this.leak != null) {
            this.leak.record(object);
        }
        return this;
    }

    @Override
    public boolean release() {
        if (this.leak != null) {
            this.leak.record();
        }
        return super.release();
    }

    @Override
    public boolean release(int n2) {
        if (this.leak != null) {
            this.leak.record();
        }
        return super.release(n2);
    }
}

