/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.ssl;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslKeyMaterial;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509KeyManager;

public final class OpenSslX509KeyManagerFactory
extends KeyManagerFactory {
    private final OpenSslKeyManagerFactorySpi spi;

    public OpenSslX509KeyManagerFactory() {
        this(OpenSslX509KeyManagerFactory.newOpenSslKeyManagerFactorySpi(null));
    }

    private OpenSslX509KeyManagerFactory(OpenSslKeyManagerFactorySpi openSslKeyManagerFactorySpi) {
        super(openSslKeyManagerFactorySpi, openSslKeyManagerFactorySpi.kmf.getProvider(), openSslKeyManagerFactorySpi.kmf.getAlgorithm());
        this.spi = openSslKeyManagerFactorySpi;
    }

    private static OpenSslKeyManagerFactorySpi newOpenSslKeyManagerFactorySpi(Provider provider) {
        try {
            return OpenSslX509KeyManagerFactory.newOpenSslKeyManagerFactorySpi(null, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
    }

    private static OpenSslKeyManagerFactorySpi newOpenSslKeyManagerFactorySpi(String string, Provider provider) throws NoSuchAlgorithmException {
        if (string == null) {
            string = KeyManagerFactory.getDefaultAlgorithm();
        }
        return new OpenSslKeyManagerFactorySpi(provider == null ? KeyManagerFactory.getInstance(string) : KeyManagerFactory.getInstance(string, provider));
    }

    OpenSslKeyMaterialProvider newProvider() {
        return this.spi.newProvider();
    }

    private static final class OpenSslKeyManagerFactorySpi
    extends KeyManagerFactorySpi {
        final KeyManagerFactory kmf;
        private volatile ProviderFactory providerFactory;

        OpenSslKeyManagerFactorySpi(KeyManagerFactory keyManagerFactory) {
            this.kmf = ObjectUtil.checkNotNull(keyManagerFactory, "kmf");
        }

        @Override
        protected synchronized void engineInit(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            if (this.providerFactory != null) {
                throw new KeyStoreException("Already initialized");
            }
            if (!keyStore.aliases().hasMoreElements()) {
                throw new KeyStoreException("No aliases found");
            }
            this.kmf.init(keyStore, cArray);
            this.providerFactory = new ProviderFactory(ReferenceCountedOpenSslContext.chooseX509KeyManager(this.kmf.getKeyManagers()), OpenSslKeyManagerFactorySpi.password(cArray), Collections.list(keyStore.aliases()));
        }

        private static String password(char[] cArray) {
            if (cArray == null || cArray.length == 0) {
                return null;
            }
            return new String(cArray);
        }

        @Override
        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("Not supported");
        }

        @Override
        protected KeyManager[] engineGetKeyManagers() {
            ProviderFactory providerFactory = this.providerFactory;
            if (providerFactory == null) {
                throw new IllegalStateException("engineInit(...) not called yet");
            }
            return new KeyManager[]{providerFactory.keyManager};
        }

        OpenSslKeyMaterialProvider newProvider() {
            ProviderFactory providerFactory = this.providerFactory;
            if (providerFactory == null) {
                throw new IllegalStateException("engineInit(...) not called yet");
            }
            return providerFactory.newProvider();
        }

        private static final class ProviderFactory {
            private final X509KeyManager keyManager;
            private final String password;
            private final Iterable<String> aliases;

            ProviderFactory(X509KeyManager x509KeyManager, String string, Iterable<String> iterable) {
                this.keyManager = x509KeyManager;
                this.password = string;
                this.aliases = iterable;
            }

            OpenSslKeyMaterialProvider newProvider() {
                return new OpenSslPopulatedKeyMaterialProvider(this.keyManager, this.password, this.aliases);
            }

            private static final class OpenSslPopulatedKeyMaterialProvider
            extends OpenSslKeyMaterialProvider {
                private final Map<String, Object> materialMap = new HashMap<String, Object>();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                OpenSslPopulatedKeyMaterialProvider(X509KeyManager x509KeyManager, String string, Iterable<String> iterable) {
                    super(x509KeyManager, string);
                    boolean bl2 = false;
                    try {
                        for (String string2 : iterable) {
                            if (string2 == null || this.materialMap.containsKey(string2)) continue;
                            try {
                                this.materialMap.put(string2, super.chooseKeyMaterial(UnpooledByteBufAllocator.DEFAULT, string2));
                            }
                            catch (Exception exception) {
                                this.materialMap.put(string2, exception);
                            }
                        }
                        bl2 = true;
                    }
                    finally {
                        if (!bl2) {
                            this.destroy();
                        }
                    }
                    ObjectUtil.checkNonEmpty(this.materialMap, "materialMap");
                }

                @Override
                OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator byteBufAllocator, String string) throws Exception {
                    Object object = this.materialMap.get(string);
                    if (object == null) {
                        return null;
                    }
                    if (object instanceof OpenSslKeyMaterial) {
                        return ((OpenSslKeyMaterial)object).retain();
                    }
                    throw (Exception)object;
                }

                @Override
                void destroy() {
                    for (Object object : this.materialMap.values()) {
                        ReferenceCountUtil.release(object);
                    }
                    this.materialMap.clear();
                }
            }
        }
    }
}

