/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.concurrent;

import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.AbstractEventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.DefaultPromise;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FailedFuture;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.GlobalEventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Promise;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public final class ImmediateEventExecutor
extends AbstractEventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ImmediateEventExecutor.class);
    public static final ImmediateEventExecutor INSTANCE = new ImmediateEventExecutor();
    private static final FastThreadLocal<Queue<Runnable>> DELAYED_RUNNABLES = new FastThreadLocal<Queue<Runnable>>(){

        @Override
        protected Queue<Runnable> initialValue() throws Exception {
            return new ArrayDeque<Runnable>();
        }
    };
    private static final FastThreadLocal<Boolean> RUNNING = new FastThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() throws Exception {
            return false;
        }
    };
    private final Future<?> terminationFuture = new FailedFuture(GlobalEventExecutor.INSTANCE, new UnsupportedOperationException());

    private ImmediateEventExecutor() {
    }

    @Override
    public boolean inEventLoop() {
        return true;
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return true;
    }

    @Override
    public Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
    }

    @Override
    public boolean isShuttingDown() {
        return false;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        ObjectUtil.checkNotNull(runnable, "command");
        if (!RUNNING.get().booleanValue()) {
            RUNNING.set(true);
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                logger.info("Throwable caught while executing Runnable {}", runnable, throwable);
            }
            finally {
                Runnable runnable2;
                Queue<Runnable> queue = DELAYED_RUNNABLES.get();
                while ((runnable2 = queue.poll()) != null) {
                    try {
                        runnable2.run();
                    }
                    catch (Throwable throwable) {
                        logger.info("Throwable caught while executing Runnable {}", runnable2, throwable);
                    }
                }
                RUNNING.set(false);
            }
        } else {
            DELAYED_RUNNABLES.get().add(runnable);
        }
    }

    @Override
    public <V> Promise<V> newPromise() {
        return new ImmediatePromise(this);
    }

    static class ImmediatePromise<V>
    extends DefaultPromise<V> {
        ImmediatePromise(EventExecutor eventExecutor) {
            super(eventExecutor);
        }

        @Override
        protected void checkDeadLock() {
        }
    }
}

