/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.AccessException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.BeanResolver;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;

public class BeanReference
extends SpelNodeImpl {
    private final String beanName;

    public BeanReference(int n2, int n3, String string) {
        super(n2, n3, new SpelNodeImpl[0]);
        this.beanName = string;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        BeanResolver beanResolver = expressionState.getEvaluationContext().getBeanResolver();
        if (beanResolver == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.NO_BEAN_RESOLVER_REGISTERED, this.beanName);
        }
        try {
            return new TypedValue(beanResolver.resolve(expressionState.getEvaluationContext(), this.beanName));
        }
        catch (AccessException accessException) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)accessException, SpelMessage.EXCEPTION_DURING_BEAN_RESOLUTION, this.beanName, accessException.getMessage());
        }
    }

    @Override
    public String toStringAST() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.beanName.startsWith("&")) {
            stringBuilder.append('@');
        }
        if (!this.beanName.contains(".")) {
            stringBuilder.append(this.beanName);
        } else {
            stringBuilder.append('\'').append(this.beanName).append('\'');
        }
        return stringBuilder.toString();
    }
}

