/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.Operation;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Operator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.util.NumberUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class OperatorPower
extends Operator {
    public OperatorPower(int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super("^", n2, n3, spelNodeImplArray);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        SpelNodeImpl spelNodeImpl = this.getLeftOperand();
        SpelNodeImpl spelNodeImpl2 = this.getRightOperand();
        Object object = spelNodeImpl.getValueInternal(expressionState).getValue();
        Object object2 = spelNodeImpl2.getValueInternal(expressionState).getValue();
        if (object instanceof Number && object2 instanceof Number) {
            Number number = (Number)object;
            Number number2 = (Number)object2;
            if (number instanceof BigDecimal) {
                BigDecimal bigDecimal = NumberUtils.convertNumberToTargetClass(number, BigDecimal.class);
                return new TypedValue(bigDecimal.pow(number2.intValue()));
            }
            if (number instanceof BigInteger) {
                BigInteger bigInteger = NumberUtils.convertNumberToTargetClass(number, BigInteger.class);
                return new TypedValue(bigInteger.pow(number2.intValue()));
            }
            if (number instanceof Double || number2 instanceof Double) {
                return new TypedValue(Math.pow(number.doubleValue(), number2.doubleValue()));
            }
            if (number instanceof Float || number2 instanceof Float) {
                return new TypedValue(Math.pow(number.floatValue(), number2.floatValue()));
            }
            double d2 = Math.pow(number.doubleValue(), number2.doubleValue());
            if (d2 > 2.147483647E9 || number instanceof Long || number2 instanceof Long) {
                return new TypedValue((long)d2);
            }
            return new TypedValue((int)d2);
        }
        return expressionState.operate(Operation.POWER, object, object2);
    }
}

